/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.bansystem;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import me.entity303.serversystem.bansystem.Ban;
import me.entity303.serversystem.bansystem.ManagerBan;
import me.entity303.serversystem.bansystem.TimeUnit;
import me.entity303.serversystem.main.ServerSystem;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class BanManager_SQLite
extends ManagerBan {
    private final ServerSystem plugin;
    private Connection connection;
    private String dateFormat;

    public BanManager_SQLite(String dateFormat, ServerSystem plugin) {
        super(new File("plugins//ServerSystem", "bans.sqlite"), dateFormat, plugin);
        this.dateFormat = dateFormat;
        this.plugin = plugin;
        this.open();
        try {
            this.connection.createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS BannedPlayers (BannedUUID VARCHAR(100), SenderUUID VARCHAR(100), Reason VARCHAR(100), UnbanTime BIGINT(1))");
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }

    protected boolean initialize() {
        try {
            Class.forName("org.sqlite.JDBC");
            return true;
        }
        catch (ClassNotFoundException var2) {
            this.plugin.error("Class not found in initialize(): " + var2);
            return false;
        }
    }

    private void open() {
        if (this.initialize()) {
            try {
                this.connection = DriverManager.getConnection("jdbc:sqlite:" + new File("plugins//ServerSystem", "bans.sqlite").getAbsolutePath());
            }
            catch (SQLException var2) {
                this.plugin.error("Could not establish an SQLite connection, SQLException: " + var2.getMessage());
            }
        }
    }

    @Override
    public boolean isBanned(UUID uuid) {
        return this.checkPlayerInSQLite(uuid.toString());
    }

    @Override
    public List<String> getBannedPlayerNames() {
        ArrayList<String> playerNames = new ArrayList<String>();
        ResultSet resultSet = null;
        try {
            resultSet = this.connection.createStatement().executeQuery("SELECT BannedUUID from BannedPlayers");
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        while (true) {
            try {
                while (resultSet != null && resultSet.next()) {
                    String uuid = resultSet.getString("BannedUUID");
                    if (!this.checkPlayerInSQLite(uuid)) continue;
                    playerNames.add(Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid)).getName());
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        return playerNames;
    }

    @Override
    public Ban getBanByUUID(UUID uuid) {
        if (!this.checkPlayerInSQLite(uuid.toString())) {
            return null;
        }
        UUID bannedUUID = uuid;
        String reason = this.getReason(uuid.toString());
        long unbanTime = this.getUnbanTime(uuid.toString());
        String senderUUID = this.getUUIDSender(uuid.toString());
        String unbanDate = this.convertLongToDate(unbanTime);
        return new Ban(bannedUUID, reason, senderUUID, unbanTime, unbanDate);
    }

    @Override
    public Ban getBanByUUIDString(String uuid) {
        return this.getBanByUUID(UUID.fromString(uuid));
    }

    @Override
    public Ban getBanByPlayer(OfflinePlayer player) {
        return this.getBanByUUID(player.getUniqueId());
    }

    @Override
    public String convertLongToDate(Long l) {
        if (l < 1L) {
            return this.getBanSystem("PermaBan");
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(l);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy:MM:dd:kk:mm:ss");
        String[] dates = dateFormat.format(c.getTime()).split(":");
        String year = dates[0];
        String month = dates[1];
        String day = dates[2];
        String hour = dates[3];
        String minute = dates[4];
        String second = dates[5];
        if (month.chars().count() == 1L) {
            month = "0" + month;
        }
        if (day.chars().count() == 1L) {
            day = "0" + day;
        }
        if (hour.chars().count() == 1L) {
            hour = "0" + hour;
        }
        if (minute.chars().count() == 1L) {
            minute = "0" + minute;
        }
        if (second.chars().count() == 1L) {
            second = "0" + second;
        }
        return this.getDateFormat().replace("<YEAR>", year).replace("<MONTH>", month).replace("<DAY>", day).replace("<HOUR>", hour).replace("<MINUTE>", minute).replace("<SECOND>", second);
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    private boolean checkPlayerInSQLite(String uuid) {
        ResultSet rs = null;
        try {
            rs = this.connection.createStatement().executeQuery("SELECT * FROM BannedPlayers WHERE BannedUUID='" + uuid + "'");
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        return false;
    }

    private String getReason(String uuid) {
        ResultSet rs = null;
        try {
            rs = this.connection.createStatement().executeQuery("SELECT * FROM BannedPlayers WHERE BannedUUID='" + uuid + "'");
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        try {
            if (rs.next()) {
                return rs.getString("Reason");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Long getUnbanTime(String uuid) {
        ResultSet rs = null;
        try {
            rs = this.connection.createStatement().executeQuery("SELECT * FROM BannedPlayers WHERE BannedUUID='" + uuid + "'");
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        try {
            if (rs.next()) {
                return rs.getLong("UnbanTime");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getUUIDSender(String uuid) {
        ResultSet rs = null;
        try {
            rs = this.connection.createStatement().executeQuery("SELECT * FROM BannedPlayers WHERE BannedUUID='" + uuid + "'");
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        try {
            if (rs.next()) {
                return rs.getString("SenderUUID");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Ban createBan(UUID banned, String senderUUID, String reason, Long howLong, TimeUnit timeUnit) {
        if (this.isBanned(banned)) {
            this.unBan(banned);
        }
        long unbanTime = System.currentTimeMillis() + howLong * timeUnit.getValue();
        if (howLong < 1L) {
            unbanTime = -1L;
        }
        try {
            this.connection.createStatement().executeUpdate("INSERT INTO `BannedPlayers` (BannedUUID, SenderUUID, Reason, UnbanTime) VALUES ('" + banned + "','" + senderUUID + "','" + reason + "','" + unbanTime + "')");
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        return new Ban(banned, reason, senderUUID, unbanTime, this.convertLongToDate(unbanTime));
    }

    @Override
    public void unBan(UUID banned) {
        try {
            this.connection.createStatement().executeUpdate("DELETE FROM BannedPlayers WHERE BannedUUID='" + banned.toString() + "'");
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

