/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.serversystem.api;

import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;
import me.entity303.serversystem.economy.EconomyManager_Disabled;
import me.entity303.serversystem.main.ServerSystem;
import org.bukkit.OfflinePlayer;

public class EconomyAPI {
    private final ServerSystem plugin;

    public EconomyAPI(ServerSystem plugin) {
        this.plugin = plugin;
    }

    public CompletableFuture<Double> getMoney(OfflinePlayer player) {
        return CompletableFuture.supplyAsync(() -> this.plugin.getEconomyManager().getMoneyAsNumber(player));
    }

    public CompletableFuture<String> getFormattedMoney(OfflinePlayer player) {
        return CompletableFuture.supplyAsync(() -> this.plugin.getEconomyManager().getMoney(player));
    }

    public String formatMoney(Double money) {
        return this.plugin.getEconomyManager().format(money);
    }

    public void makeTransaction(OfflinePlayer playerPaying, OfflinePlayer playerReceiving, Double amountToPay) {
        this.plugin.getEconomyManager().makeTransaction(playerPaying, playerReceiving, (double)amountToPay);
    }

    public CompletableFuture<Boolean> hasEnoughMoney(OfflinePlayer playerPaying, Double amountToPay) {
        return CompletableFuture.supplyAsync(() -> this.plugin.getEconomyManager().hasEnoughMoney(playerPaying, (double)amountToPay));
    }

    public void setMoney(OfflinePlayer player, Double money) {
        this.plugin.getEconomyManager().setMoney(player, (double)money);
    }

    public void removeMoney(OfflinePlayer player, Double amount) {
        this.plugin.getEconomyManager().removeMoney(player, (double)amount);
    }

    public void addMoney(OfflinePlayer player, Double amount) {
        this.plugin.getEconomyManager().addMoney(player, (double)amount);
    }

    public CompletableFuture<Boolean> hasAccount(OfflinePlayer player) {
        return CompletableFuture.supplyAsync(() -> this.plugin.getEconomyManager().hasAccount(player));
    }

    public void createAccount(OfflinePlayer player) {
        this.plugin.getEconomyManager().createAccount(player);
    }

    public void deleteAccount(OfflinePlayer player) {
        this.plugin.getEconomyManager().deleteAccount(player);
    }

    public Double getStartingMoney() {
        return Double.parseDouble(this.plugin.getEconomyManager().getStartingMoney());
    }

    public LinkedHashMap<OfflinePlayer, Double> getTopTen() {
        return new LinkedHashMap<OfflinePlayer, Double>(this.plugin.getEconomyManager().getTopTen());
    }

    public boolean isEconomyEnabled() {
        return !(this.plugin.getEconomyManager() instanceof EconomyManager_Disabled);
    }
}

