/*
 * Decompiled with CFR 0.152.
 */
package com.daveedoo.hihead;

import com.daveedoo.hihead.commands.ClearAll;
import com.daveedoo.hihead.commands.DeleteStick;
import com.daveedoo.hihead.commands.SetDefault;
import com.daveedoo.hihead.commands.Stick;
import com.daveedoo.hihead.commands.ToggleDefault;
import com.daveedoo.hihead.events.SkullClicked;
import com.daveedoo.hihead.events.SkullDestroyed;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class HiHead
extends JavaPlugin {
    private Connection connection;
    public String host;
    public String database;
    public String username;
    public String password;
    public String table;
    public int port;
    public boolean my_sql;

    public void onEnable() {
        this.getLogger().info(ChatColor.GREEN + "HiHead has started.");
        this.getConfig().options().copyDefaults();
        this.saveDefaultConfig();
        if (this.getConfig().getBoolean("mysql-options.enabled")) {
            this.getLogger().info("MySQL option enabled.");
            this.my_sql = true;
            this.intializeDb();
        }
        this.getServer().getPluginManager().registerEvents((Listener)new SkullClicked(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SkullDestroyed(), (Plugin)this);
        this.getCommand("stick").setExecutor((CommandExecutor)new Stick());
        this.getCommand("deletestick").setExecutor((CommandExecutor)new DeleteStick());
        this.getCommand("clearall").setExecutor((CommandExecutor)new ClearAll());
        this.getCommand("toggledefaultmessage").setExecutor((CommandExecutor)new ToggleDefault());
        this.getCommand("setdefaultmessage").setExecutor((CommandExecutor)new SetDefault());
    }

    public void onDisable() {
        this.getLogger().info(ChatColor.GREEN + "HiHead has ended. Goodbye.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intializeDb() {
        this.host = this.getConfig().getString("mysql-options.host");
        this.port = this.getConfig().getInt("mysql-options.port");
        this.database = this.getConfig().getString("mysql-options.database");
        this.username = this.getConfig().getString("mysql-options.username");
        this.password = this.getConfig().getString("mysql-options.password");
        try {
            HiHead hiHead = this;
            synchronized (hiHead) {
                if (this.getConnection() != null && !this.getConnection().isClosed()) {
                    return;
                }
                Class.forName("com.mysql.jdbc.Driver");
                this.setConnection(DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database, this.username, this.password));
                Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "MySQL Connected! :D");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.createTables(this.database);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void createTables(String db) {
        this.getLogger().info(ChatColor.GREEN + "Attempting to create table...");
        try {
            DatabaseMetaData dbm = this.connection.getMetaData();
            ResultSet tables = dbm.getTables(null, null, "hihead_messages", null);
            if (tables.next()) {
                this.getLogger().info("Table already exists!");
            } else {
                String sql = "CREATE TABLE `" + db + "`.`hihead_messages` (\n  `index` INT NOT NULL AUTO_INCREMENT,\n  `location` VARCHAR(45) NOT NULL,\n  `message` VARCHAR(500) NOT NULL,\n  PRIMARY KEY (`index`),\n  UNIQUE INDEX `index_UNIQUE` (`index` ASC),\n  UNIQUE INDEX `location_UNIQUE` (`location` ASC));";
                PreparedStatement statement = this.getConnection().prepareStatement(sql);
                statement.executeUpdate();
                this.getLogger().info(ChatColor.GREEN + "Table created successfully in " + db);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deletePlayerMessage(String coor, Player player) {
        try {
            PreparedStatement statement = this.getConnection().prepareStatement("DELETE FROM hihead_messages WHERE location=?");
            statement.setString(1, coor);
            int i = statement.executeUpdate();
            if (i > 0) {
                player.sendMessage(ChatColor.GREEN + "Message deleted!");
            } else {
                player.getPlayer().sendMessage(ChatColor.RED + "There was nothing to delete!");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void setPlayerMessage(String coor, String message, Player player) {
        try {
            PreparedStatement statement = this.getConnection().prepareStatement("UPDATE hihead_messages SET message=? WHERE location=?");
            statement.setString(1, message);
            statement.setString(2, coor);
            if (statement.executeUpdate() < 1) {
                statement = this.getConnection().prepareStatement("INSERT INTO hihead_messages (location, message) VALUES(?,?)");
                statement.setString(1, coor);
                statement.setString(2, message);
                int i = statement.executeUpdate();
                if (i > 0) {
                    player.sendMessage(ChatColor.GREEN + "Message set!");
                } else {
                    player.sendMessage(ChatColor.RED + "Something went wrong...");
                }
            } else {
                player.sendMessage(ChatColor.GREEN + "Message set!");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String getPlayerMessage(String coor) {
        try {
            PreparedStatement statement = this.getConnection().prepareStatement("SELECT * FROM hihead_messages WHERE location=?");
            statement.setString(1, coor);
            ResultSet results = statement.executeQuery();
            if (results.next()) {
                return results.getString("message");
            }
            if (this.getConfig().getBoolean("do-default-message")) {
                return this.getConfig().getString("default-message");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "";
    }
}

