/*
 * Decompiled with CFR 0.152.
 */
package xy.plugins.villagermodifications;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentWrapper;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import xy.plugins.villagermodifications.Metrics;

public final class VillagerModifications
extends JavaPlugin
implements Listener {
    private String mainPath;
    private long begin;
    private long end;
    private long allVillagersr;
    private long allVillagersxp;
    private long alert;
    private long TradesOff;
    private long CustomOnly;
    private long MaxLevel;
    private int HotV;
    private String BookTitle;
    private String BookLore;
    private String widentifier;
    private String bidentifier;
    private String alertmessage;
    private boolean professionchange;
    private boolean usesRestrictedAll;
    private boolean usesRestrictedBooks;
    private int uses;
    private boolean minimumCostAll;
    private boolean minimumCostBooks;
    private int amount;

    public void onEnable() {
        this.getConfig().options().copyDefaults();
        this.saveDefaultConfig();
        this.loadSettings();
        this.getLogger().info("VillagerModifications is running");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        int pluginId = 10822;
        Metrics metrics = new Metrics(this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("chart_id", () -> "My value"));
    }

    public void loadSettings() {
        this.mainPath = this.getDataFolder().getPath() + "/";
        File file = new File(this.mainPath, "config.yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
        this.widentifier = " ";
        this.bidentifier = " ";
        File wfile = new File(this.mainPath, "whitelist.yml");
        YamlConfiguration whitelist_info = YamlConfiguration.loadConfiguration((File)wfile);
        if (!wfile.exists()) {
            ArrayList<String> whitelist = new ArrayList<String>();
            whitelist.add("placeholder");
            whitelist_info.addDefault("whitelist", whitelist);
            whitelist_info.options().copyDefaults(true);
            try {
                whitelist_info.save(wfile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.begin = cfg.getInt("Work.begin");
        this.end = cfg.getInt("Work.end");
        this.allVillagersr = cfg.getLong("allVillagers.restricted");
        this.allVillagersxp = cfg.getLong("allVillagers.disablexp");
        this.alert = cfg.getLong("AlertOn");
        this.TradesOff = cfg.getInt("TradesOff");
        this.CustomOnly = cfg.getInt("CustomOnly");
        this.alertmessage = cfg.getString("AlertMessage");
        this.BookLore = cfg.getString("Book.Lore");
        this.BookTitle = cfg.getString("Book.Title");
        this.MaxLevel = cfg.getInt("allVillagers.levelmax");
        this.uses = cfg.getInt("usesRestricted.amount");
        this.amount = cfg.getInt("minimumCost.amount");
        this.HotV = cfg.getInt("allVillagers.HotV", 5);
        this.professionchange = cfg.getBoolean("allVillagers.changeProfessions", true);
        this.usesRestrictedAll = cfg.getBoolean("usesRestricted.All", false);
        this.usesRestrictedBooks = cfg.getBoolean("usesRestricted.Books", false);
        this.minimumCostAll = cfg.getBoolean("minimumCost.All", false);
        this.minimumCostBooks = cfg.getBoolean("minimumCost.Books", false);
    }

    @EventHandler
    public void interact(PlayerInteractEntityEvent event) {
        Player p = event.getPlayer();
        if (!(event.getRightClicked() instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)event.getRightClicked();
        this.mainPath = this.getDataFolder().getPath() + "/";
        File file = new File(this.mainPath, "config.yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
        File wfile = new File(this.mainPath, "whitelist.yml");
        YamlConfiguration whitelist_info = YamlConfiguration.loadConfiguration((File)wfile);
        World currentWorld = villager.getWorld();
        for (String world : cfg.getStringList("DisableWorlds")) {
            if (!currentWorld.getName().equals(world)) continue;
            return;
        }
        if (p.hasPotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE)) {
            PotionEffect hero = p.getPotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE);
            if (this.HotV == 0) {
                p.removePotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE);
            } else if (hero.getAmplifier() > this.HotV - 1) {
                p.removePotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE);
                p.addPotionEffect(new PotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE, hero.getDuration(), this.HotV - 1));
            }
        }
        List whitelist = whitelist_info.getStringList("whitelist");
        if (this.widentifier.equals(p.getName())) {
            if (!whitelist.contains(villager.getUniqueId().toString())) {
                whitelist.add(villager.getUniqueId().toString());
                whitelist_info.set("whitelist", (Object)whitelist);
                p.sendMessage("Villager has been added to the whitelist");
                try {
                    whitelist_info.save(wfile);
                }
                catch (IOException world) {}
            } else {
                p.sendMessage("Villager is already whitelisted");
            }
        }
        if (this.bidentifier.equals(p.getName())) {
            if (whitelist.contains(villager.getUniqueId().toString())) {
                whitelist.remove(villager.getUniqueId().toString());
                whitelist_info.set("whitelist", (Object)whitelist);
                p.sendMessage("Villager has been removed from the whitelist");
                try {
                    whitelist_info.save(wfile);
                }
                catch (IOException world) {}
            } else {
                p.sendMessage("Villager was not found in the whitelist");
            }
        }
        if (this.MaxLevel == 1L && villager.getVillagerExperience() < 499) {
            villager.setVillagerExperience(499);
        }
        if (!whitelist.contains(villager.getUniqueId().toString())) {
            if (this.TradesOff == 0L) {
                if (this.allVillagersr == 1L && !villager.getProfession().equals((Object)Villager.Profession.NONE)) {
                    if (villager.getWorld().getTime() >= this.end) {
                        if (this.alert == 1L) {
                            p.sendMessage(this.alertmessage);
                        }
                        event.setCancelled(true);
                    } else if (villager.getWorld().getTime() <= this.begin) {
                        if (this.alert == 1L) {
                            p.sendMessage(this.alertmessage);
                        }
                        event.setCancelled(true);
                    }
                }
                List configbooks = cfg.getStringList("enchantments");
                List restricteditems = cfg.getStringList("CustomItem");
                ArrayList recipes = Lists.newArrayList((Iterable)villager.getRecipes());
                int pos = -1;
                ItemStack book_item = new ItemStack(Material.BOOK, 1);
                ItemMeta custom_book = book_item.getItemMeta();
                custom_book.setLore(Arrays.asList(this.BookLore));
                custom_book.setDisplayName(this.BookTitle);
                for (MerchantRecipe recipe : recipes) {
                    ++pos;
                    if (this.allVillagersxp == 1L) {
                        recipe.setExperienceReward(false);
                    } else if (this.allVillagersxp == 0L) {
                        recipe.setExperienceReward(true);
                    }
                    if (this.usesRestrictedAll) {
                        recipe.setMaxUses(this.uses);
                    }
                    if (this.usesRestrictedBooks && recipe.getResult().getType().equals((Object)Material.ENCHANTED_BOOK)) {
                        recipe.setMaxUses(this.uses);
                    }
                    if (this.minimumCostAll && ((ItemStack)recipe.getIngredients().get(0)).equals((Object)Material.EMERALD)) {
                        ((ItemStack)recipe.getIngredients().get(0)).setAmount(this.amount);
                    }
                    if (this.minimumCostBooks && ((ItemStack)recipe.getIngredients().get(0)).equals((Object)Material.EMERALD) && recipe.getResult().getType().equals((Object)Material.ENCHANTED_BOOK)) {
                        ((ItemStack)recipe.getIngredients().get(0)).setAmount(this.amount);
                    }
                    for (String item : restricteditems) {
                        ItemStack currency;
                        item = item.toUpperCase();
                        if (!recipe.getResult().getType().equals((Object)Material.matchMaterial((String)item))) continue;
                        int vrestricted = cfg.getInt(item + ".restricted");
                        int vchange = cfg.getInt(item + ".change");
                        String vmaterial = cfg.getString(item + ".material").toUpperCase();
                        int vcost = cfg.getInt(item + ".cost");
                        int vuses = cfg.getInt(item + ".uses");
                        int vxpvalue = cfg.getInt(item + ".xpvalue");
                        int vxpscale = cfg.getInt(item + ".xpscale");
                        if (villager.getWorld().getTime() >= this.end && vrestricted == 1) {
                            if (this.alert == 1L) {
                                p.sendMessage(this.alertmessage);
                            }
                            event.setCancelled(true);
                        } else if (villager.getWorld().getTime() <= this.begin && vrestricted == 1) {
                            if (this.alert == 1L) {
                                p.sendMessage(this.alertmessage);
                            }
                            event.setCancelled(true);
                        }
                        if (vchange != 1) continue;
                        int uses = recipe.getUses();
                        if (vmaterial.equals("CUSTOM")) {
                            vmaterial = cfg.getString("CustomCurrency.Material").toUpperCase();
                            ItemMeta customMeta = (ItemMeta)cfg.get("CustomCurrency.ItemMeta");
                            currency = new ItemStack(Material.getMaterial((String)vmaterial), vcost);
                            currency.setItemMeta(customMeta);
                        } else {
                            currency = new ItemStack(Material.getMaterial((String)vmaterial), vcost);
                        }
                        ItemStack tradeditem = recipe.getResult();
                        MerchantRecipe changedrec = new MerchantRecipe(tradeditem, vuses);
                        changedrec.setUses(uses);
                        changedrec.addIngredient(currency);
                        if (vxpscale == 1) {
                            if (villager.getVillagerLevel() == 2) {
                                vxpvalue *= 4;
                            }
                            if (villager.getVillagerLevel() == 3) {
                                vxpvalue *= 5;
                            }
                            if (villager.getVillagerLevel() == 4) {
                                vxpvalue *= 6;
                            }
                        }
                        changedrec.setVillagerExperience(vxpvalue);
                        if (this.allVillagersxp == 1L) {
                            changedrec.setExperienceReward(false);
                        } else if (this.allVillagersxp == 0L) {
                            changedrec.setExperienceReward(true);
                        }
                        villager.setRecipe(pos, changedrec);
                    }
                    if (!recipe.getResult().getType().equals((Object)Material.ENCHANTED_BOOK)) continue;
                    EnchantmentStorageMeta meta = (EnchantmentStorageMeta)recipe.getResult().getItemMeta();
                    for (String book : configbooks) {
                        ItemStack emerald;
                        if (!book.contains(":")) continue;
                        String[] book_level = book.split(":");
                        Enchantment enchantment = EnchantmentWrapper.getByKey((NamespacedKey)NamespacedKey.minecraft((String)book_level[0]));
                        int level = Integer.parseInt(book_level[1]);
                        if (!meta.hasStoredEnchant(enchantment) || meta.getStoredEnchantLevel(enchantment) != level) continue;
                        book = book.replace(":", "_");
                        int vrestricted = cfg.getInt(book + ".restricted");
                        int vchange = cfg.getInt(book + ".change");
                        String vmaterial = cfg.getString(book + ".material");
                        int vcost = cfg.getInt(book + ".cost");
                        int vbook = cfg.getInt(book + ".book");
                        int vuses = cfg.getInt(book + ".uses");
                        int vxpvalue = cfg.getInt(book + ".xpvalue");
                        int vxpscale = cfg.getInt(book + ".xpscale");
                        if (villager.getWorld().getTime() >= this.end && vrestricted == 1) {
                            if (this.alert == 1L) {
                                p.sendMessage(this.alertmessage);
                            }
                            event.setCancelled(true);
                        } else if (villager.getWorld().getTime() <= this.begin && vrestricted == 1) {
                            if (this.alert == 1L) {
                                p.sendMessage(this.alertmessage);
                            }
                            event.setCancelled(true);
                        }
                        if (vchange != 1) continue;
                        int uses = recipe.getUses();
                        if (vmaterial.equals("CUSTOM")) {
                            vmaterial = cfg.getString("CustomCurrency.Material").toUpperCase();
                            ItemMeta customMeta = (ItemMeta)cfg.get("CustomCurrency.ItemMeta");
                            emerald = new ItemStack(Material.getMaterial((String)vmaterial), vcost);
                            emerald.setItemMeta(customMeta);
                        } else {
                            emerald = new ItemStack(Material.getMaterial((String)vmaterial), vcost);
                        }
                        ItemStack enchantedbook = new ItemStack(recipe.getResult().getType(), 1);
                        if (vbook == 1) {
                            book_item.setItemMeta(custom_book);
                        }
                        enchantedbook.setItemMeta((ItemMeta)meta);
                        MerchantRecipe changedrec = new MerchantRecipe(enchantedbook, vuses);
                        changedrec.setUses(uses);
                        changedrec.addIngredient(emerald);
                        changedrec.addIngredient(book_item);
                        if (vxpscale == 1) {
                            if (villager.getVillagerLevel() == 2) {
                                vxpvalue *= 4;
                            }
                            if (villager.getVillagerLevel() == 3) {
                                vxpvalue *= 5;
                            }
                            if (villager.getVillagerLevel() == 4) {
                                vxpvalue *= 6;
                            }
                        }
                        changedrec.setVillagerExperience(vxpvalue);
                        if (this.allVillagersxp == 1L) {
                            changedrec.setExperienceReward(false);
                        } else if (this.allVillagersxp == 0L) {
                            changedrec.setExperienceReward(true);
                        }
                        villager.setRecipe(pos, changedrec);
                    }
                }
            } else if (this.TradesOff == 1L) {
                event.setCancelled(true);
            } else {
                p.sendMessage("TradesOff is set to a value other than 0 or 1 in the config.");
                p.sendMessage("Villager trades will not be disabled, nor will they be altered.");
                p.sendMessage("Please ensure the value is either 0 or 1 to ensure proper plugin function.");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player p;
        block38: {
            block42: {
                block39: {
                    block40: {
                        ItemStack book;
                        block41: {
                            if (command.getName().equals("vmreload")) {
                                if (!(sender instanceof Player)) {
                                    System.out.println("Plugin has been reloaded");
                                    this.loadSettings();
                                    return true;
                                }
                                Player p2 = (Player)sender;
                                if (p2.hasPermission("VillagerModification.reload")) {
                                    p2.sendMessage("Plugin has been reloaded");
                                    this.loadSettings();
                                    return true;
                                }
                                p2.sendMessage("No permission");
                                return true;
                            }
                            if (!command.getName().equals("vmbook")) break block38;
                            if (!(sender instanceof Player)) break block39;
                            p = (Player)sender;
                            if (!p.hasPermission("VillagerModification.reload")) break block40;
                            String subcommand = "";
                            String name = "";
                            int amount = 0;
                            book = new ItemStack(Material.BOOK, 1);
                            ItemMeta custom_book = book.getItemMeta();
                            custom_book.setLore(Arrays.asList(this.BookLore));
                            custom_book.setDisplayName(this.BookTitle);
                            book.setItemMeta(custom_book);
                            if (args.length <= 0) break block41;
                            subcommand = args[0];
                            if (subcommand.equals("give")) {
                                if (args.length <= 1) {
                                    p.sendMessage("Error passing player name, please enter a player name and amount.");
                                    return true;
                                }
                                name = args[1];
                                if (!Bukkit.getServer().getPlayer(name).isOnline()) {
                                    p.sendMessage("Error passing player name to server, please ensure the player is online.");
                                    return true;
                                }
                                if (args.length > 2) {
                                    try {
                                        amount = Integer.parseInt(args[2]);
                                    }
                                    catch (NumberFormatException e) {
                                        p.sendMessage("Error parsing " + args[2] + " as a number. please enter an amount between 1 and 64.");
                                        return true;
                                    }
                                    if (amount > 64 || amount < 1) {
                                        p.sendMessage("Error out of bounds, please enter an amount between 1 and 64.");
                                        return true;
                                    }
                                } else {
                                    amount = 1;
                                }
                                Player pTarget = Bukkit.getPlayer((String)name);
                                book.setAmount(amount);
                                pTarget.getInventory().addItem(new ItemStack[]{book});
                            }
                            break block38;
                        }
                        p.sendMessage("\u00a7aBook received.");
                        p.getInventory().addItem(new ItemStack[]{book});
                        break block38;
                    }
                    p.sendMessage("No permission");
                    break block38;
                }
                String subcommand = "";
                String name = "";
                int amount = 0;
                ItemStack book = new ItemStack(Material.BOOK, 1);
                ItemMeta custom_book = book.getItemMeta();
                custom_book.setLore(Arrays.asList(this.BookLore));
                custom_book.setDisplayName(this.BookTitle);
                book.setItemMeta(custom_book);
                if (args.length <= 0) break block42;
                subcommand = args[0];
                if (subcommand.equals("give")) {
                    if (args.length <= 1) {
                        this.getLogger().info("Error passing player name, please enter a player name and amount.");
                        return true;
                    }
                    name = args[1];
                    if (!Bukkit.getServer().getPlayer(name).isOnline()) {
                        this.getLogger().info("Error passing player name to server, please ensure the player is online.");
                        return true;
                    }
                    if (args.length > 2) {
                        try {
                            amount = Integer.parseInt(args[2]);
                        }
                        catch (NumberFormatException e) {
                            this.getLogger().info("Error parsing " + args[2] + " as a number. please enter an amount between 1 and 64.");
                            return true;
                        }
                        if (amount > 64 || amount < 1) {
                            this.getLogger().info("Error out of bounds, please enter an amount between 1 and 64.");
                            return true;
                        }
                    } else {
                        amount = 1;
                    }
                    Player pTarget = Bukkit.getPlayer((String)name);
                    book.setAmount(amount);
                    pTarget.getInventory().addItem(new ItemStack[]{book});
                }
                break block38;
            }
            System.out.println("Cannot give book to console, please enter a player name and amount.");
        }
        if (command.getName().equals("vmwhitelist")) {
            if (!(sender instanceof Player)) {
                System.out.println("Cannot identify UUID in console");
                return true;
            }
            p = (Player)sender;
            if (!p.hasPermission("VillagerModification.whitelist")) {
                p.sendMessage("No permission");
                return true;
            }
            if (this.bidentifier.equals(" ")) {
                p.sendMessage("Villager whitelist mode activated");
                p.sendMessage("Enter /vmoff to deactivate");
                this.widentifier = p.getName();
            }
            if (this.bidentifier.equals(" ")) return true;
            p.sendMessage("Whitelist mode has not been activated.");
            p.sendMessage("Please enter /vmoff before activating this.");
            return true;
        }
        if (command.getName().equals("vmoff")) {
            if (!(sender instanceof Player)) {
                System.out.println("Cannot identify UUID in console");
                return true;
            }
            p = (Player)sender;
            if (!p.hasPermission("VillagerModification.whitelist")) {
                p.sendMessage("No permission");
                return true;
            }
            if (!this.widentifier.equals(" ")) {
                p.sendMessage("Villager whitelist mode deactivated");
                this.widentifier = " ";
            }
            if (this.bidentifier.equals(" ")) return true;
            p.sendMessage("Villager whitelist removing mode deactivated");
            this.bidentifier = " ";
            return true;
        }
        if (command.getName().equals("vmremove")) {
            if (!(sender instanceof Player)) {
                System.out.println("Cannot identify UUID in console");
                return true;
            }
            p = (Player)sender;
            if (!p.hasPermission("VillagerModification.whitelist")) {
                p.sendMessage("No permission");
                return true;
            }
            if (this.widentifier.equals(" ")) {
                p.sendMessage("Villager whitelist removing mode activated");
                p.sendMessage("Enter /vmoff to deactivate");
                this.bidentifier = p.getName();
            }
            if (this.widentifier.equals(" ")) return true;
            p.sendMessage("Removal mode has not been activated.");
            p.sendMessage("Please enter /vmoff before activating this.");
            return true;
        }
        if (command.getName().equals("vmtime")) {
            if (!(sender instanceof Player)) {
                System.out.println("Trades begin at " + this.begin + " ticks and ends at " + this.end + " ticks.");
                return true;
            }
            p = (Player)sender;
            if (p.hasPermission("VillagerModification.time")) {
                p.sendMessage("Trades begin at " + this.begin + " ticks and ends at " + this.end + " ticks.");
                return true;
            }
            p.sendMessage("No permission");
            return true;
        }
        if (!command.getName().equals("vmeta")) return false;
        if (!(sender instanceof Player)) {
            System.out.println("[VillagerModifications] Cannot check item meta in console.");
            return true;
        }
        p = (Player)sender;
        if (!p.hasPermission("VillagerModification.meta")) {
            p.sendMessage("No permission");
            return true;
        }
        File metaFile = new File(this.mainPath, "metaOutput.yml");
        YamlConfiguration metaConfig = YamlConfiguration.loadConfiguration((File)metaFile);
        metaConfig.set("ItemMeta", (Object)p.getInventory().getItemInMainHand().getItemMeta());
        try {
            metaConfig.save(metaFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        p.sendMessage("Item meta has been sent to the ItemMeta file in the Villager Modifications folder.");
        p.sendMessage("You can put this in the custom currency at the top of the config, and use the");
        p.sendMessage("material name 'CUSTOM' to set trades to use this. Simply copy the meta values");
        p.sendMessage("into the correct space in the custom currency section. Please check on the");
        p.sendMessage("spigot page for an example, or contact on my discord if you are having trouble.");
        return true;
    }
}

