/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.ingamereviews.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.athlaeos.ingamereviews.callbacks.BooleanCallback;
import me.athlaeos.ingamereviews.callbacks.DoubleCallback;
import me.athlaeos.ingamereviews.callbacks.ReviewListCallback;
import me.athlaeos.ingamereviews.domain.Review;
import me.athlaeos.ingamereviews.main.Main;
import me.athlaeos.ingamereviews.persistence.DatabaseConnection;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MySQLReviewDao {
    private static MySQLReviewDao reviewdao = null;
    private DatabaseConnection db = DatabaseConnection.getInstance();

    public static MySQLReviewDao getInstance() {
        if (reviewdao == null) {
            reviewdao = new MySQLReviewDao();
        }
        return reviewdao;
    }

    public List<Review> getReviews(String query) throws ClassNotFoundException, SQLException {
        Connection conn = this.db.getConnection(Main.getInstance());
        this.createDatabase();
        Statement stmt = conn.createStatement();
        ResultSet result = stmt.executeQuery(query);
        ArrayList<Review> reviews = new ArrayList<Review>();
        while (result.next()) {
            Review review = new Review(result.getInt("id"), UUID.fromString(result.getString("uuid")), result.getString("subject"), result.getInt("rating"), result.getString("review"), result.getDate("created"));
            reviews.add(review);
        }
        return reviews;
    }

    public void uploadReview(final Review review) {
        new BukkitRunnable(){

            public void run() {
                try {
                    Connection conn = MySQLReviewDao.this.db.getConnection(Main.getInstance());
                    MySQLReviewDao.this.createDatabase();
                    PreparedStatement stmt = conn.prepareStatement("INSERT INTO ingamereviews (uuid, subject, rating, review, created) VALUES (?, ?, ?, ?, ?)");
                    stmt.setString(1, review.getUUID().toString());
                    stmt.setString(2, review.getSubject());
                    stmt.setInt(3, review.getRating());
                    stmt.setString(4, review.getReview());
                    stmt.setDate(5, review.getCreatedOn());
                    stmt.execute();
                }
                catch (ClassNotFoundException | SQLException e) {
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public void updateReview(Review review) {
        try {
            Connection conn = this.db.getConnection(Main.getInstance());
            this.createDatabase();
            PreparedStatement stmt = conn.prepareStatement("UPDATE ingamereviews SET rating = ?, review = ?, created = ? WHERE uuid = ? AND subject = ?");
            stmt.setInt(1, review.getRating());
            stmt.setString(2, review.getReview());
            stmt.setDate(3, review.getCreatedOn());
            stmt.setString(4, review.getUUID().toString());
            stmt.setString(5, review.getSubject());
            stmt.execute();
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
        }
    }

    public void alreadyReviewed(final BooleanCallback c, final UUID uuid, final String subject) {
        new BukkitRunnable(){
            boolean alreadyreviewed;

            public void run() {
                try {
                    Connection conn = MySQLReviewDao.this.db.getConnection(Main.getInstance());
                    MySQLReviewDao.this.createDatabase();
                    PreparedStatement exists = conn.prepareStatement("SELECT * FROM ingamereviews WHERE uuid = ? AND subject = ?");
                    exists.setString(1, uuid.toString());
                    exists.setString(2, subject);
                    ResultSet rs = exists.executeQuery();
                    this.alreadyreviewed = rs.next();
                    new BukkitRunnable(){

                        public void run() {
                            c.booleanCallback(alreadyreviewed);
                        }
                    }.runTask((Plugin)Main.getInstance());
                }
                catch (ClassNotFoundException | SQLException e) {
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public void lookupSubject(final ReviewListCallback cl, final DoubleCallback cd, final String subject) {
        new BukkitRunnable(){
            List<Review> reviews = new ArrayList<Review>();
            double averagerating;

            public void run() {
                try {
                    Connection conn = MySQLReviewDao.this.db.getConnection(Main.getInstance());
                    PreparedStatement resultreviews = conn.prepareStatement("SELECT * FROM ingamereviews WHERE subject = ?");
                    PreparedStatement average = conn.prepareStatement("SELECT AVG(rating) 'average' FROM ingamereviews WHERE subject = ?");
                    resultreviews.setString(1, subject);
                    average.setString(1, subject);
                    ResultSet rs1 = resultreviews.executeQuery();
                    while (rs1.next()) {
                        this.reviews.add(new Review(rs1.getInt("id"), UUID.fromString(rs1.getString("uuid")), rs1.getString("subject"), rs1.getInt("rating"), rs1.getString("review"), rs1.getDate("created")));
                    }
                    ResultSet rs2 = average.executeQuery();
                    this.averagerating = rs2.next() ? rs2.getDouble("average") : 0.0;
                    new BukkitRunnable(){

                        public void run() {
                            cl.listCallback(reviews);
                            if (reviews.size() > 0) {
                                cd.doubleCallback(averagerating);
                            }
                        }
                    }.runTask((Plugin)Main.getInstance());
                }
                catch (ClassNotFoundException | SQLException e) {
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public void myReviews(final ReviewListCallback c, final UUID uuid) {
        new BukkitRunnable(){
            List<Review> reviews = new ArrayList<Review>();

            public void run() {
                try {
                    Connection conn = MySQLReviewDao.this.db.getConnection(Main.getInstance());
                    PreparedStatement resultreviews = conn.prepareStatement("SELECT * FROM ingamereviews WHERE uuid = ?");
                    resultreviews.setString(1, uuid.toString());
                    ResultSet rs = resultreviews.executeQuery();
                    while (rs.next()) {
                        this.reviews.add(new Review(rs.getInt("id"), UUID.fromString(rs.getString("uuid")), rs.getString("subject"), rs.getInt("rating"), rs.getString("review"), rs.getDate("created")));
                    }
                    new BukkitRunnable(){

                        public void run() {
                            c.listCallback(reviews);
                        }
                    }.runTask((Plugin)Main.getInstance());
                }
                catch (ClassNotFoundException | SQLException e) {
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public void wipeDatabase() {
        System.out.println("Tried to create new table");
        new BukkitRunnable(){

            public void run() {
                try {
                    Connection conn = MySQLReviewDao.this.db.getConnection(Main.getInstance());
                    PreparedStatement query = conn.prepareStatement("TRUNCATE TABLE INGAMEREVIEWS");
                    query.execute();
                }
                catch (ClassNotFoundException | SQLException e) {
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)Main.getInstance());
    }

    public void createDatabase() throws SQLException, ClassNotFoundException {
        Connection conn = this.db.getConnection(Main.getInstance());
        Statement statement = conn.createStatement();
        statement.execute("CREATE TABLE IF NOT EXISTS ingamereviews (id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY, uuid VARCHAR(40) NOT NULL,subject VARCHAR(40) NOT NULL,rating INT(1) NOT NULL,review VARCHAR(300),created DATE)");
    }
}

