/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.ingamereviews.main;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import me.athlaeos.ingamereviews.managers.CommandManager;
import me.athlaeos.ingamereviews.persistence.DatabaseConnection;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Main
extends JavaPlugin {
    private static Main plugin;
    private DatabaseConnection connection = DatabaseConnection.getInstance();

    public void onEnable() {
        plugin = this;
        this.saveDefaultConfig();
        this.enableDatabase();
        this.registerManagers();
        this.registerListeners();
        this.registerCommands();
        this.registerTasks();
    }

    public void onDisable() {
        try {
            this.connection.closeConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Main getInstance() {
        return plugin;
    }

    public void enableDatabase() {
        BukkitRunnable r = new BukkitRunnable(){

            public void run() {
                try {
                    Connection conn = Main.this.connection.getConnection(Main.this);
                    Statement statement = conn.createStatement();
                    statement.execute("CREATE TABLE IF NOT EXISTS ingamereviews (id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY, uuid VARCHAR(40) NOT NULL,subject VARCHAR(40) NOT NULL,rating INT(1) NOT NULL,review VARCHAR(300),created DATE)");
                }
                catch (ClassNotFoundException e) {
                    System.out.println("\n\nSomething went wrong\n\n");
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    System.out.println("\n\nSomething went wrong\n\n");
                    e.printStackTrace();
                }
                catch (Exception e) {
                    System.out.println("\n\nSomething went wrong\n\n");
                    return;
                }
            }
        };
        r.runTaskAsynchronously((Plugin)this);
    }

    public void registerManagers() {
        new CommandManager(this);
    }

    public void registerListeners() {
    }

    public void registerCommands() {
    }

    private void registerTasks() {
    }
}

