/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.ingamereviews.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.athlaeos.ingamereviews.callbacks.DoubleCallback;
import me.athlaeos.ingamereviews.callbacks.ReviewListCallback;
import me.athlaeos.ingamereviews.commands.Command;
import me.athlaeos.ingamereviews.domain.Review;
import me.athlaeos.ingamereviews.main.Main;
import me.athlaeos.ingamereviews.persistence.MySQLReviewDao;
import me.athlaeos.ingamereviews.utils.Utils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ViewSubjectReviewsCommand
implements Command {
    private Main plugin;
    private String[] permissionRequired = new String[]{"reviews.viewreviews"};
    private MySQLReviewDao reviewdao = MySQLReviewDao.getInstance();

    public ViewSubjectReviewsCommand(Main plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(final CommandSender sender, final String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("&cOnly players can do this!");
            return true;
        }
        boolean hasPermission = false;
        for (String permission : this.permissionRequired) {
            if (!sender.hasPermission(permission)) continue;
            hasPermission = true;
            break;
        }
        if (!hasPermission) {
            sender.sendMessage(Utils.chat(this.plugin.getConfig().getString("error_no_permission")));
            return true;
        }
        ReviewListCallback cr = new ReviewListCallback(){

            @Override
            public void listCallback(List<Review> result) {
                int page = 1;
                if (args.length > 2) {
                    page = Integer.parseInt(args[2]);
                }
                if (result.size() > 0) {
                    ArrayList<String> reviewstrings = new ArrayList<String>();
                    for (Review r : result) {
                        reviewstrings.add(String.format("&8> &a%s &8| &a%s &8| &e%s &8| &e%s &8| &7%s", ViewSubjectReviewsCommand.this.plugin.getServer().getOfflinePlayer(r.getUUID()).getName(), r.getCreatedOn(), r.getSubject(), r.getRating(), r.getReview()));
                    }
                    Map<Integer, ArrayList<String>> pages = Utils.pagesCreator(5, reviewstrings);
                    if (page > pages.size()) {
                        page = pages.size();
                    }
                    for (String line : pages.get(page - 1)) {
                        sender.sendMessage(Utils.chat(line));
                    }
                    sender.sendMessage(Utils.chat(String.format("&8[&e%s&8/&e%s&8]", page, pages.size())));
                    sender.sendMessage(Utils.chat(ViewSubjectReviewsCommand.this.plugin.getConfig().getString("translation_amount_reviews") + result.size()));
                    return;
                }
                sender.sendMessage(Utils.chat(ViewSubjectReviewsCommand.this.plugin.getConfig().getString("notify_no_reviews_found")));
            }
        };
        DoubleCallback cd = new DoubleCallback(){

            @Override
            public void doubleCallback(double result) {
                sender.sendMessage(Utils.chat(ViewSubjectReviewsCommand.this.plugin.getConfig().getString("translation_average_rating") + result));
            }
        };
        if (args.length > 1) {
            if (args.length > 2) {
                try {
                    Integer.parseInt(args[2]);
                    if (Integer.parseInt(args[2]) < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    sender.sendMessage(Utils.chat(this.plugin.getConfig().getString("error_invalid_page_number")));
                    return true;
                }
            }
            this.reviewdao.lookupSubject(cr, cd, args[1]);
            return true;
        }
        return false;
    }

    @Override
    public String[] getRequiredPermission() {
        return this.permissionRequired;
    }

    @Override
    public String getFailureMessage() {
        return String.format("&c%s: &4/reviews viewsubject", this.plugin.getConfig().getString("translation_invalid_command_usage"));
    }

    @Override
    public String[] getHelpEntry() {
        String[] entry = new String[]{"&e/reviews view <subject> <page>", "&8>&7 " + this.plugin.getConfig().getString("description_subjectoverview"), "&8>&7 " + this.plugin.getConfig().getString("translation_permissions") + ": &e" + String.join((CharSequence)", ", this.permissionRequired)};
        return entry;
    }

    @Override
    public List<String> getSubcommandArgs(CommandSender sender, String[] args) {
        if (args.length == 2) {
            ArrayList<String> subargs = new ArrayList<String>();
            for (String subject : this.plugin.getConfig().getStringList("subject_list")) {
                subargs.add(subject);
            }
            return subargs;
        }
        if (args.length == 3) {
            ArrayList<String> subargs = new ArrayList<String>();
            subargs.add("1");
            subargs.add("2");
            subargs.add("3");
            subargs.add("...");
            return subargs;
        }
        ArrayList<String> subargs = new ArrayList<String>();
        subargs.add(" ");
        return subargs;
    }
}

