/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.ingamereviews.commands;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.athlaeos.ingamereviews.callbacks.BooleanCallback;
import me.athlaeos.ingamereviews.commands.Command;
import me.athlaeos.ingamereviews.domain.Review;
import me.athlaeos.ingamereviews.main.Main;
import me.athlaeos.ingamereviews.managers.ReviewCacheManager;
import me.athlaeos.ingamereviews.persistence.MySQLReviewDao;
import me.athlaeos.ingamereviews.utils.Utils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class NewReviewCommand
implements Command {
    private Main plugin;
    private String[] permissionRequired = new String[]{"reviews.postreview"};
    private MySQLReviewDao reviewdao = MySQLReviewDao.getInstance();
    private ReviewCacheManager cachemanager = ReviewCacheManager.getInstance();

    public NewReviewCommand(Main plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(final CommandSender sender, final String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.chat("&cOnly players can do this!"));
            return true;
        }
        boolean hasPermission = false;
        for (String permission : this.permissionRequired) {
            if (!sender.hasPermission(permission)) continue;
            hasPermission = true;
            break;
        }
        if (!hasPermission) {
            sender.sendMessage(Utils.chat(this.plugin.getConfig().getString("error_no_permission")));
            return true;
        }
        if (args.length < 3) {
            return false;
        }
        if (args.length >= 3) {
            int rating;
            try {
                rating = Integer.parseInt(args[2]);
                if (rating < 0 && rating > this.plugin.getConfig().getInt("rating_scale")) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                sender.sendMessage(Utils.chat(this.plugin.getConfig().getString("error_invalid_rating").replace("{max_rating}", "" + this.plugin.getConfig().getInt("rating_scale"))));
                return true;
            }
            if (!this.plugin.getConfig().getBoolean("allow_any_subject") && !this.plugin.getConfig().getStringList("subject_list").contains(args[1])) {
                sender.sendMessage(Utils.chat(this.plugin.getConfig().getString("error_invalid_subject")));
                return true;
            }
            final Review review = args.length == 3 ? new Review(((Player)sender).getUniqueId(), args[1], rating, null, new Date(System.currentTimeMillis())) : new Review(((Player)sender).getUniqueId(), args[1], rating, String.join((CharSequence)" ", Arrays.copyOfRange(args, 3, args.length)), new Date(System.currentTimeMillis()));
            BooleanCallback callback = new BooleanCallback(){

                @Override
                public void booleanCallback(boolean reviewed) {
                    if (reviewed) {
                        NewReviewCommand.this.cachemanager.saveReview(review);
                        sender.sendMessage(Utils.chat(NewReviewCommand.this.plugin.getConfig().getString("warning_repeat_review")));
                        return;
                    }
                    sender.sendMessage(Utils.chat(NewReviewCommand.this.plugin.getConfig().getString("post_new_review").replace("{player}", sender.getName()).replace("{subject}", args[1])));
                    NewReviewCommand.this.reviewdao.uploadReview(review);
                    List commands = NewReviewCommand.this.plugin.getConfig().getStringList("commands_new_review");
                    if (commands.size() != 0) {
                        for (String command : commands) {
                            if (command.equalsIgnoreCase("")) continue;
                            NewReviewCommand.this.plugin.getServer().dispatchCommand((CommandSender)NewReviewCommand.this.plugin.getServer().getConsoleSender(), command.replace("{player}", sender.getName()));
                        }
                    }
                }
            };
            this.reviewdao.alreadyReviewed(callback, ((Player)sender).getUniqueId(), args[1]);
            return true;
        }
        return false;
    }

    @Override
    public String[] getRequiredPermission() {
        return this.permissionRequired;
    }

    @Override
    public String getFailureMessage() {
        return String.format("&c%s: &4/reviews new <subject> <rating> <review>", this.plugin.getConfig().getString("translation_invalid_command_usage"));
    }

    @Override
    public String[] getHelpEntry() {
        String[] entry = new String[]{"&e/reviews new <subject> <rating> <review>", "&8>&7 " + this.plugin.getConfig().getString("description_new"), "&8>&7 " + this.plugin.getConfig().getString("translation_permissions") + ": &e" + String.join((CharSequence)", ", this.permissionRequired)};
        return entry;
    }

    @Override
    public List<String> getSubcommandArgs(CommandSender sender, String[] args) {
        if (args.length == 2) {
            return this.plugin.getConfig().getStringList("subject_list");
        }
        if (args.length == 3) {
            ArrayList<String> subargs = new ArrayList<String>();
            for (int i = 0; i < this.plugin.getConfig().getInt("rating_scale"); ++i) {
                subargs.add("" + (i + 1));
            }
            return subargs;
        }
        if (args.length == 4) {
            ArrayList<String> subargs = new ArrayList<String>();
            subargs.add("''");
            return subargs;
        }
        ArrayList<String> subargs = new ArrayList<String>();
        subargs.add(" ");
        return subargs;
    }
}

