/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.ingamereviews.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.athlaeos.ingamereviews.commands.Command;
import me.athlaeos.ingamereviews.main.Main;
import me.athlaeos.ingamereviews.utils.Utils;
import org.bukkit.command.CommandSender;

public class HelpCommand
implements Command {
    private Main plugin;
    private String[] permissionRequired = new String[]{"reviews.help"};
    private List<Command> commands = new ArrayList<Command>();

    public HelpCommand(Main plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        boolean hasPermission = false;
        for (String permission : this.permissionRequired) {
            if (!sender.hasPermission(permission)) continue;
            hasPermission = true;
            break;
        }
        if (!hasPermission) {
            sender.sendMessage(Utils.chat(this.plugin.getConfig().getString("error_no_permission")));
            return true;
        }
        Map<Object, Object> helpCommandList = new HashMap();
        ArrayList<String[]> helpEntries = new ArrayList<String[]>();
        ArrayList<String> helpLines = new ArrayList<String>();
        block3: for (Command c : this.commands) {
            for (String permission : c.getRequiredPermission()) {
                if (!sender.hasPermission(permission)) continue;
                helpEntries.add(c.getHelpEntry());
                continue block3;
            }
        }
        for (String[] commandHelp : helpEntries) {
            for (String entry : commandHelp) {
                helpLines.add(entry);
            }
        }
        helpCommandList = Utils.pagesCreator(9, helpLines);
        if (helpCommandList.size() == 0) {
            return true;
        }
        if (args.length == 1) {
            for (String line : (ArrayList)helpCommandList.get(0)) {
                sender.sendMessage(Utils.chat(line));
            }
            sender.sendMessage(Utils.chat(String.format("&8[&e1&8/&e%s&8]", helpCommandList.size())));
            return true;
        }
        if (args.length == 2) {
            try {
                Integer.parseInt(args[1]);
            }
            catch (NumberFormatException nfe) {
                sender.sendMessage(Utils.chat(this.plugin.getConfig().getString("error_invalid_page_number")));
                return true;
            }
            int pageNumber = Integer.parseInt(args[1]);
            if (pageNumber < 1) {
                pageNumber = 1;
            }
            if (pageNumber > helpCommandList.size()) {
                pageNumber = helpCommandList.size();
            }
            for (String entry : (ArrayList)helpCommandList.get(pageNumber - 1)) {
                sender.sendMessage(Utils.chat(entry));
            }
            sender.sendMessage(Utils.chat(String.format("&8[&e%s&8/&e%s&8]", pageNumber, helpCommandList.size())));
            return true;
        }
        return false;
    }

    @Override
    public String[] getRequiredPermission() {
        return this.permissionRequired;
    }

    @Override
    public String getFailureMessage() {
        return String.format("&c%s: &4/reviews help", this.plugin.getConfig().getString("translation_invalid_command_usage"));
    }

    @Override
    public String[] getHelpEntry() {
        String[] entry = new String[]{"&e/reviews help", "&8>&7 " + this.plugin.getConfig().getString("description_help"), "&8>&7 " + this.plugin.getConfig().getString("translation_permissions") + ": &e" + String.join((CharSequence)", ", this.permissionRequired)};
        return entry;
    }

    public void giveCommandMap(Map<String, Command> commandMap) {
        for (String key : commandMap.keySet()) {
            this.commands.add(commandMap.get(key));
        }
    }

    @Override
    public List<String> getSubcommandArgs(CommandSender sender, String[] args) {
        if (args.length == 2) {
            ArrayList<String> subargs = new ArrayList<String>();
            subargs.add("1");
            subargs.add("2");
            subargs.add("3");
            subargs.add("...");
            return subargs;
        }
        ArrayList<String> subargs = new ArrayList<String>();
        subargs.add(" ");
        return subargs;
    }
}

