/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.ingamereviews.commands;

import java.util.ArrayList;
import java.util.List;
import me.athlaeos.ingamereviews.commands.Command;
import me.athlaeos.ingamereviews.main.Main;
import me.athlaeos.ingamereviews.utils.Utils;
import org.bukkit.command.CommandSender;

public class BaseCommand
implements Command {
    private Main plugin;
    private String[] permissionRequired = new String[]{"reviews.postreview"};

    public BaseCommand(Main plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        boolean hasPermission = false;
        for (String permission : this.permissionRequired) {
            if (!sender.hasPermission(permission)) continue;
            hasPermission = true;
            break;
        }
        if (!hasPermission) {
            sender.sendMessage(Utils.chat("&cYou do not have permission to use this command!"));
            return true;
        }
        return false;
    }

    @Override
    public String[] getRequiredPermission() {
        return this.permissionRequired;
    }

    @Override
    public String getFailureMessage() {
        return String.format("&c%s: &4/reviews command", this.plugin.getConfig().getString("translation_invalid_command_usage"));
    }

    @Override
    public String[] getHelpEntry() {
        String[] entry = new String[]{"&e/reviews post", "&8>&7 " + this.plugin.getConfig().getString("description_command"), "&8>&7 " + this.plugin.getConfig().getString("translation_permissions") + ": &e" + String.join((CharSequence)", ", this.permissionRequired)};
        return entry;
    }

    @Override
    public List<String> getSubcommandArgs(CommandSender sender, String[] args) {
        ArrayList<String> subargs = new ArrayList<String>();
        subargs.add(" ");
        return subargs;
    }
}

