/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.storage.sqlite;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;

public abstract class SQLStorageBase {
    public static final String DATABSE_NAME = "database.db";
    protected static Connection conn;
    private final IPeriodicHolographicDisplays phd;

    public SQLStorageBase(IPeriodicHolographicDisplays phd) {
        this.phd = phd;
        try {
            if (conn == null || conn.isClosed()) {
                conn = this.connect();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private Connection connect() {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Connection conn = null;
        try {
            String url = "jdbc:sqlite:" + this.phd.getDataFolder().getAbsolutePath() + "/database.db";
            conn = DriverManager.getConnection(url);
            this.phd.getLogger().info(this.phd.getMessages().getSqlConnectionMessage().getMessage().getFilled());
        }
        catch (SQLException e) {
            this.phd.getLogger().log(Level.SEVERE, "Problem connecting to database", e);
        }
        return conn;
    }

    protected SQLResponse executeQuery(String query, String ... args) {
        this.checkConnection();
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            int i = 1;
            for (String arg : args) {
                statement.setString(i, arg);
                ++i;
            }
            return new SQLResponse(statement.executeQuery(), statement);
        }
        catch (SQLException e) {
            this.phd.getLogger().warning("Unable to execute QUERY:" + query);
            e.printStackTrace();
            return null;
        }
    }

    protected boolean tableExists(String table) {
        ResultSet rs;
        PreparedStatement statement;
        this.checkConnection();
        try {
            statement = conn.prepareStatement("SHOW TABLES LIKE '" + table + "';");
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            this.phd.getLogger().log(Level.WARNING, "Unable to check if table exists: " + table, e);
            return false;
        }
        try {
            boolean can = rs.next();
            rs.close();
            statement.close();
            return can;
        }
        catch (SQLException e) {
            this.phd.getLogger().log(Level.WARNING, "Unable to check if table exists(next): " + table, e);
            return false;
        }
    }

    protected void checkConnection() {
        try {
            if (conn.isClosed() || !conn.isValid(10)) {
                conn.close();
                conn = this.connect();
                this.phd.getLogger().info("Creating a new connection for DB");
            }
        }
        catch (SQLException e) {
            this.phd.getLogger().log(Level.WARNING, "Unable to check if connection is closed!", e);
        }
    }

    protected boolean executeUpdate(String query, String ... args) {
        this.checkConnection();
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            int i = 1;
            for (String arg : args) {
                statement.setString(i, arg);
                ++i;
            }
            statement.executeUpdate();
            statement.close();
            return true;
        }
        catch (SQLException e) {
            this.phd.getLogger().log(Level.WARNING, "Unable to update QUERY: " + query, e);
            return false;
        }
    }

    public void close() {
        try {
            if (conn.isClosed()) {
                conn.close();
                return;
            }
        }
        catch (SQLException e) {
            this.phd.getLogger().log(Level.WARNING, "Issue while closing connection (while checking if connection is closed)", e);
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            this.phd.getLogger().log(Level.WARNING, "Issue while closing connection:", e);
        }
    }

    public class SQLResponse {
        private final ResultSet rs;
        private final PreparedStatement statement;

        public SQLResponse(ResultSet rs, PreparedStatement statement) {
            this.rs = rs;
            this.statement = statement;
        }

        public ResultSet getResultSet() {
            return this.rs;
        }

        public boolean close() {
            try {
                this.rs.close();
                this.statement.close();
            }
            catch (SQLException e) {
                SQLStorageBase.this.phd.getLogger().log(Level.WARNING, "Issue while closing result set and/or statement", e);
                return false;
            }
            return true;
        }
    }
}

