/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.listeners.legacy;

import java.util.HashMap;
import java.util.Map;
import me.ford.periodicholographicdisplays.PeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.holograms.HologramStorage;
import me.ford.periodicholographicdisplays.holograms.PeriodicHologramBase;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.WorldHologramStorage;
import me.ford.periodicholographicdisplays.holograms.events.StartedManagingHologramEvent;
import me.ford.periodicholographicdisplays.holograms.events.StoppedManagingHologramEvent;
import me.ford.periodicholographicdisplays.listeners.WorldTimeListener;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LegacyWorldTimeListener
extends WorldTimeListener {
    private final PeriodicHolographicDisplays phd;
    private final Map<World, Long> worldTimes = new HashMap<World, Long>();

    public LegacyWorldTimeListener(HologramStorage storage) {
        super(storage);
        this.phd = (PeriodicHolographicDisplays)JavaPlugin.getPlugin(PeriodicHolographicDisplays.class);
        this.phd.getServer().getScheduler().runTaskTimer((Plugin)this.phd, (Runnable)new TickRunnable(), 1L, 1L);
    }

    @EventHandler
    public void onStartManage(StartedManagingHologramEvent event) {
        if (event.getHologram().getType() != PeriodicType.MCTIME) {
            return;
        }
        World world = event.getHologram().getLocation().getWorld();
        if (!this.worldTimes.containsKey(world)) {
            this.addWorld(world);
        }
    }

    @EventHandler
    public void onStopManage(StoppedManagingHologramEvent event) {
        if (event.getHologram().getType() != PeriodicType.MCTIME) {
            return;
        }
        this.phd.getServer().getScheduler().runTask((Plugin)this.phd, (Runnable)new WorldChecker(event.getHologram().getLocation().getWorld()));
    }

    private void addWorld(World world) {
        this.phd.debug("Adding world to LegacyWorldTimeListener: " + world.getName());
        this.worldTimes.put(world, world.getFullTime());
    }

    private void removeWorld(World world) {
        this.phd.debug("Removing world from LegacyWorldTimeListener: " + world.getName());
        this.worldTimes.remove(world);
    }

    private void timeChanged(World world, long addTime) {
        this.phd.debug("Time changed in " + world.getName() + " by " + addTime);
        this.getStorage().mcTimeChanged(world, addTime);
    }

    private final class TickRunnable
    implements Runnable {
        private TickRunnable() {
        }

        @Override
        public void run() {
            for (Map.Entry<World, Long> entry : LegacyWorldTimeListener.this.worldTimes.entrySet()) {
                World world = entry.getKey();
                long prevTime = entry.getValue();
                long newTime = world.getFullTime();
                if (newTime != prevTime + 1L && ((Boolean)world.getGameRuleValue(GameRule.DO_DAYLIGHT_CYCLE)).booleanValue()) {
                    LegacyWorldTimeListener.this.timeChanged(world, newTime - (prevTime + 1L));
                }
                LegacyWorldTimeListener.this.worldTimes.put(world, newTime);
            }
        }
    }

    private final class WorldChecker
    implements Runnable {
        private final World world;

        private WorldChecker(World world) {
            this.world = world;
        }

        @Override
        public void run() {
            WorldHologramStorage holos = LegacyWorldTimeListener.this.getStorage().getHolograms(this.world);
            if (holos == null || holos.getHolograms().isEmpty()) {
                LegacyWorldTimeListener.this.removeWorld(this.world);
            } else if (holos != null) {
                boolean hasMctime = false;
                for (PeriodicHologramBase periodicHologramBase : holos.getHolograms()) {
                    if (periodicHologramBase.getType() != PeriodicType.MCTIME) continue;
                    hasMctime = true;
                    break;
                }
                if (!hasMctime) {
                    LegacyWorldTimeListener.this.removeWorld(this.world);
                }
            }
        }
    }
}

