/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.listeners;

import me.ford.periodicholographicdisplays.holograms.AlwaysHologram;
import me.ford.periodicholographicdisplays.holograms.HologramStorage;
import me.ford.periodicholographicdisplays.holograms.PeriodicHologramBase;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.WorldHologramStorage;
import me.ford.periodicholographicdisplays.hooks.NPCHook;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class HologramListener
implements Listener {
    private final HologramStorage holograms;
    private final NPCHook hook;

    public HologramListener(HologramStorage holograms, NPCHook hook) {
        this.holograms = holograms;
        this.hook = hook;
    }

    private void movedTo(Player player, Location location, boolean forceUpdate) {
        if (this.hook != null && this.hook.isNPC((Entity)player)) {
            return;
        }
        WorldHologramStorage wh = this.holograms.getHolograms(location.getWorld());
        for (PeriodicHologramBase periodicHologramBase : wh.getHolograms(true)) {
            double dist2 = periodicHologramBase.getLocation().distanceSquared(location);
            boolean showing = false;
            if (dist2 < periodicHologramBase.getSquareDistance()) {
                if (periodicHologramBase.getType() == PeriodicType.ALWAYS && ((AlwaysHologram)periodicHologramBase).isShownOnWorldJoin()) continue;
                periodicHologramBase.attemptToShow(player);
                showing = periodicHologramBase.isBeingShownTo(player);
            }
            if (periodicHologramBase.getType() == PeriodicType.ALWAYS) {
                AlwaysHologram always = (AlwaysHologram)periodicHologramBase;
                if (!always.isShownWhileInArea()) continue;
                if (periodicHologramBase.getLocation().distanceSquared(location) > periodicHologramBase.getSquareDistance()) {
                    always.leftArea(player);
                }
            }
            if (!forceUpdate || showing) continue;
            periodicHologramBase.hideFrom(player);
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        if (event.getFrom().distanceSquared(event.getTo()) == 0.0) {
            return;
        }
        this.movedTo(event.getPlayer(), event.getTo(), false);
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        this.movedTo(event.getPlayer(), event.getTo(), event.getPlayer().getWorld() != event.getTo().getWorld());
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        this.movedTo(event.getPlayer(), event.getPlayer().getLocation(), true);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.movedTo(event.getPlayer(), event.getPlayer().getLocation(), true);
    }
}

