/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.hooks;

import java.util.List;
import java.util.UUID;
import me.ford.periodicholographicdisplays.PeriodicHolographicDisplays;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.event.node.NodeAddEvent;
import net.luckperms.api.event.node.NodeRemoveEvent;
import net.luckperms.api.event.user.track.UserDemoteEvent;
import net.luckperms.api.event.user.track.UserPromoteEvent;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class LuckPermsHook {
    private final PeriodicHolographicDisplays phd;
    private final JavaPlugin lp;
    private final LuckPerms api;
    private final String lpCommand = "luckperms";
    private final String[] lpArgs = new String[]{"user", "N/A", "permission", "set", null};

    public LuckPermsHook(PeriodicHolographicDisplays phd) {
        this.phd = phd;
        this.lp = (JavaPlugin)this.phd.getServer().getPluginManager().getPlugin("LuckPerms");
        if (this.lp == null) {
            throw new IllegalStateException("Need LuckPerms to be enabled for the LuckPermsHook to work");
        }
        RegisteredServiceProvider provider = phd.getServer().getServicesManager().getRegistration(LuckPerms.class);
        if (provider == null) {
            throw new IllegalStateException("The LuckPerms service was not provided!");
        }
        this.api = (LuckPerms)provider.getProvider();
        this.api.getEventBus().subscribe(NodeAddEvent.class, node -> this.nodeAdded((NodeAddEvent)node));
        this.api.getEventBus().subscribe(NodeRemoveEvent.class, node -> this.nodeRemoved((NodeRemoveEvent)node));
        this.api.getEventBus().subscribe(UserPromoteEvent.class, node -> this.userPromote((UserPromoteEvent)node));
        this.api.getEventBus().subscribe(UserDemoteEvent.class, node -> this.userDemote((UserDemoteEvent)node));
    }

    private void nodeAdded(NodeAddEvent event) {
        UUID id;
        String name = event.getTarget().getIdentifier().getName();
        try {
            id = UUID.fromString(name);
        }
        catch (IllegalArgumentException e) {
            this.handleGroup(name);
            return;
        }
        Player player = this.phd.getServer().getPlayer(id);
        if (player == null) {
            return;
        }
        this.resetAlwaysHolgramPermissionsSafely(player);
    }

    private void resetHolograms(Player player) {
        this.resetAlwaysHolgramPermissionsSafely(player);
    }

    private void resetAlwaysHolgramPermissionsSafely(Player player) {
        if (!this.phd.getServer().isPrimaryThread()) {
            this.phd.getServer().getScheduler().runTask((Plugin)this.phd, () -> this.resetAlwaysHolgramPermissionsSafely(player));
            return;
        }
        this.phd.getHolograms().getHolograms(player.getWorld()).resetAlwaysHologramPermissions(player);
    }

    private void handleGroup(String name) {
        for (Player player : this.phd.getServer().getOnlinePlayers()) {
            if (!player.hasPermission("group." + name)) continue;
            this.resetHolograms(player);
        }
    }

    private void nodeRemoved(NodeRemoveEvent event) {
        UUID id;
        String name = event.getTarget().getIdentifier().getName();
        try {
            id = UUID.fromString(name);
        }
        catch (IllegalArgumentException e) {
            this.handleGroup(name);
            return;
        }
        Player player = this.phd.getServer().getPlayer(id);
        if (player == null) {
            return;
        }
        this.resetAlwaysHolgramPermissionsSafely(player);
    }

    private void userPromote(UserPromoteEvent event) {
        Player player = this.phd.getServer().getPlayer(event.getUser().getUniqueId());
        if (player == null) {
            return;
        }
        this.resetAlwaysHolgramPermissionsSafely(player);
    }

    private void userDemote(UserDemoteEvent event) {
        Player player = this.phd.getServer().getPlayer(event.getUser().getUniqueId());
        if (player == null) {
            return;
        }
        this.resetAlwaysHolgramPermissionsSafely(player);
    }

    public List<String> tabCompletePermissions(CommandSender sender, String cur) {
        PluginCommand command = this.lp.getCommand("luckperms");
        String[] args = (String[])this.lpArgs.clone();
        args[args.length - 1] = cur;
        return command.getTabCompleter().onTabComplete(sender, (Command)command, "luckperms", args);
    }
}

