/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.holograms.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.events.HologramsLoadedEvent;
import me.ford.periodicholographicdisplays.holograms.storage.HologramInfo;
import me.ford.periodicholographicdisplays.holograms.storage.HologramLoadException;
import me.ford.periodicholographicdisplays.holograms.storage.Storage;
import me.ford.periodicholographicdisplays.holograms.storage.TypeInfo;
import me.ford.periodicholographicdisplays.storage.yaml.CustomConfigHandler;
import me.ford.periodicholographicdisplays.util.TimeUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.event.Event;
import org.bukkit.plugin.PluginManager;

public class YAMLStorage
extends CustomConfigHandler
implements Storage {
    public static final String FILE_NAME = "database.yml";
    private final IPeriodicHolographicDisplays phd;
    private final PluginManager pm;

    public YAMLStorage(IPeriodicHolographicDisplays phd, PluginManager pm) throws InvalidConfigurationException {
        super(phd, FILE_NAME);
        this.phd = phd;
        this.pm = pm;
    }

    @Override
    public void saveHolograms(Set<Storage.HDHologramInfo> holograms, boolean inSync) {
        for (Storage.HDHologramInfo hdHoloInfo : holograms) {
            ConfigurationSection nameSection = this.getConfig().getConfigurationSection(hdHoloInfo.getHoloName());
            if (nameSection == null) {
                nameSection = this.getConfig().createSection(hdHoloInfo.getHoloName());
            }
            for (HologramInfo info : hdHoloInfo.getInfos()) {
                if (info.getTypeInfo() instanceof TypeInfo.NullTypeInfo) {
                    nameSection.set(info.getType().name(), null);
                    continue;
                }
                this.saveInfo(nameSection.createSection(info.getType().name()), info);
            }
            if (!nameSection.getKeys(false).isEmpty()) continue;
            this.getConfig().set(hdHoloInfo.getHoloName(), null);
        }
        this.saveConfig();
    }

    private void saveInfo(ConfigurationSection section, HologramInfo info) {
        TypeInfo typeInfo = info.getTypeInfo();
        section.set("type", (Object)info.getType().name());
        if (info.getActivationDistance() != -1.0) {
            section.set("activation-distance", (Object)info.getActivationDistance());
        }
        if (info.getShowTime() != -1L) {
            section.set("show-time", (Object)info.getShowTime());
        }
        if (info.getFlashOn() != -1.0 && info.getFlashOff() != -1.0) {
            section.set("flash-on", (Object)info.getFlashOn());
            section.set("flash-off", (Object)info.getFlashOff());
        }
        section.set("permission", (Object)info.getPermissions());
        if (typeInfo.getType() == PeriodicType.NTIMES) {
            TypeInfo.NTimesTypeInfo ntimes = (TypeInfo.NTimesTypeInfo)typeInfo;
            section.set("times-to-show", (Object)ntimes.getShowTimes());
            ConfigurationSection shownToSection = section.getConfigurationSection("shown-to");
            if (shownToSection == null) {
                shownToSection = section.createSection("shown-to");
            }
            for (Map.Entry<UUID, Integer> entry : ntimes.getShownToTimes().entrySet()) {
                int value = entry.getValue();
                shownToSection.set(entry.getKey().toString(), (Object)(value == 0 ? null : Integer.valueOf(value)));
            }
        } else if (typeInfo instanceof TypeInfo.MCTimeTypeInfo) {
            TypeInfo.MCTimeTypeInfo mctime = (TypeInfo.MCTimeTypeInfo)typeInfo;
            section.set("show-at", (Object)TimeUtils.toMCTime(mctime.getAtTime()));
        } else if (typeInfo instanceof TypeInfo.IRLTimeTypeInfo) {
            TypeInfo.IRLTimeTypeInfo irltime = (TypeInfo.IRLTimeTypeInfo)typeInfo;
            section.set("show-at", (Object)TimeUtils.toIRLTime(irltime.getAtTime()));
        }
    }

    @Override
    public void loadHolograms(Consumer<Storage.HDHologramInfo> consumer) {
        for (String name : this.getConfig().getKeys(false)) {
            this.loadHologram(name, consumer);
        }
        this.pm.callEvent((Event)new HologramsLoadedEvent());
    }

    private void loadHologram(String name, Consumer<Storage.HDHologramInfo> consumer) {
        ConfigurationSection section = this.getConfig().getConfigurationSection(name);
        Storage.HDHologramInfo info = new Storage.HDHologramInfo(name);
        for (String typeStr : section.getKeys(false)) {
            HologramInfo holo;
            try {
                holo = this.loadType(name, section.getConfigurationSection(typeStr));
            }
            catch (HologramLoadException e) {
                this.phd.getLogger().log(Level.WARNING, "Problem loading hologram of type " + typeStr + " from file for hologram " + name, e);
                continue;
            }
            info.addInfo(holo);
        }
        consumer.accept(info);
    }

    private HologramInfo loadType(String name, ConfigurationSection section) throws HologramLoadException {
        TypeInfo typeInfo;
        PeriodicType type;
        if (section == null) {
            throw new HologramLoadException("Unable to parse hologram because of incorrect config (using the old system?): " + name);
        }
        try {
            type = PeriodicType.valueOf(section.getName());
        }
        catch (IllegalArgumentException e) {
            throw new HologramLoadException("Unable to parse type of hologram: " + section.getName());
        }
        double distance = section.getDouble("activation-distance", -1.0);
        long showTime = section.getLong("show-time", -1L);
        String perms = section.getString("permission");
        double flashOn = section.getDouble("flash-on", -1.0);
        double flashOff = section.getDouble("flash-off", -1.0);
        switch (type) {
            case IRLTIME: {
                long atTime = TimeUtils.parseHoursAndMinutesToSeconds(section.getString("show-at", "00:00"));
                typeInfo = new TypeInfo.IRLTimeTypeInfo(atTime);
                break;
            }
            case MCTIME: {
                long time = TimeUtils.parseMCTime(section.getString("show-at", "00:00"));
                typeInfo = new TypeInfo.MCTimeTypeInfo(time);
                break;
            }
            case ALWAYS: 
            case NTIMES: {
                int timesToShow = type == PeriodicType.ALWAYS ? -1 : section.getInt("times-to-show", -1);
                typeInfo = new TypeInfo.NTimesTypeInfo(timesToShow, this.getShownToTimes(section.getConfigurationSection("shown-to")));
                break;
            }
            default: {
                this.phd.getLogger().info("Undefined loading behavour with type: " + type);
                return null;
            }
        }
        return new HologramInfo(name, type, distance, showTime, perms, typeInfo, flashOn, flashOff);
    }

    private Map<UUID, Integer> getShownToTimes(ConfigurationSection section) {
        HashMap<UUID, Integer> map = new HashMap<UUID, Integer>();
        if (section == null) {
            return map;
        }
        for (String uuid : section.getKeys(false)) {
            UUID id;
            try {
                id = UUID.fromString(uuid);
            }
            catch (IllegalArgumentException e) {
                this.phd.getLogger().warning("Unable to parse UUID of Periodic hologram " + section.getCurrentPath() + " : " + uuid);
                continue;
            }
            map.put(id, section.getInt(uuid));
        }
        return map;
    }

    public void reload() {
        try {
            this.reloadConfig();
        }
        catch (InvalidConfigurationException e) {
            this.phd.getLogger().severe("Problem reloading YAML storage! Incorrectly formatted. All pHD information is lost until the formatting is fixed (the reload command must be used again afterwards)");
        }
    }

    @Override
    public boolean hasData() {
        return !this.getConfig().getKeys(true).isEmpty();
    }

    @Override
    public void clear() {
        for (String key : this.getConfig().getKeys(false)) {
            this.getConfig().set(key, null);
        }
        this.saveConfig();
    }
}

