/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.holograms.storage;

import java.util.Map;
import java.util.UUID;
import me.ford.periodicholographicdisplays.holograms.FlashingHologram;
import me.ford.periodicholographicdisplays.holograms.IRLTimeHologram;
import me.ford.periodicholographicdisplays.holograms.MCTimeHologram;
import me.ford.periodicholographicdisplays.holograms.NTimesHologram;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;

public interface TypeInfo {
    public PeriodicType getType();

    public static TypeInfo of(PeriodicType type, FlashingHologram holo) {
        if (holo == null) {
            return new NullTypeInfo(type);
        }
        switch (type) {
            case MCTIME: {
                return new MCTimeTypeInfo(((MCTimeHologram)holo).getTime());
            }
            case IRLTIME: {
                return new IRLTimeTypeInfo(((IRLTimeHologram)holo).getTime());
            }
            case ALWAYS: 
            case NTIMES: {
                NTimesHologram ntimes = (NTimesHologram)holo;
                return new NTimesTypeInfo(ntimes.getTimesToShow(), ntimes.getToSave());
            }
        }
        throw new IllegalArgumentException("Need to specify type of hologram to get type info, got " + holo.getType());
    }

    public static class NullTypeInfo
    implements TypeInfo {
        private final PeriodicType type;

        public NullTypeInfo(PeriodicType type) {
            this.type = type;
        }

        @Override
        public PeriodicType getType() {
            return this.type;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof NullTypeInfo)) {
                return false;
            }
            return this.getType() == ((NullTypeInfo)other).getType();
        }
    }

    public static class MCTimeTypeInfo
    implements TypeInfo {
        private final long atTime;

        public MCTimeTypeInfo(long atTime) {
            this.atTime = atTime;
        }

        @Override
        public PeriodicType getType() {
            return PeriodicType.MCTIME;
        }

        public long getAtTime() {
            return this.atTime;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof MCTimeTypeInfo)) {
                return false;
            }
            MCTimeTypeInfo oh = (MCTimeTypeInfo)other;
            return Math.abs(this.atTime - oh.atTime) < 17L;
        }

        public String toString() {
            return String.format("[MCTI:%d]", this.atTime);
        }
    }

    public static class IRLTimeTypeInfo
    implements TypeInfo {
        private final long atTime;

        public IRLTimeTypeInfo(long atTime) {
            this.atTime = atTime;
        }

        @Override
        public PeriodicType getType() {
            return PeriodicType.IRLTIME;
        }

        public long getAtTime() {
            return this.atTime;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof IRLTimeTypeInfo)) {
                return false;
            }
            IRLTimeTypeInfo oh = (IRLTimeTypeInfo)other;
            return Math.abs(this.atTime - oh.atTime) < 60L;
        }

        public String toString() {
            return String.format("[IRLTI:%d]", this.atTime);
        }
    }

    public static class NTimesTypeInfo
    implements TypeInfo {
        private final int showTimes;
        private final Map<UUID, Integer> shownToTimes;

        public NTimesTypeInfo(int showTimes, Map<UUID, Integer> shownToTimes) {
            this.showTimes = showTimes;
            this.shownToTimes = shownToTimes;
        }

        public void addAllShownTo(Map<UUID, Integer> shownTo) {
            this.shownToTimes.putAll(shownTo);
        }

        public void addShownTo(UUID id, int times) {
            this.shownToTimes.put(id, times);
        }

        public int getShowTimes() {
            return this.showTimes;
        }

        public Map<UUID, Integer> getShownToTimes() {
            return this.shownToTimes;
        }

        @Override
        public PeriodicType getType() {
            return this.showTimes == -1 ? PeriodicType.ALWAYS : PeriodicType.NTIMES;
        }

        public String toString() {
            return String.format("<%s(%d):%s>", this.getType().name(), this.showTimes, this.shownToTimes.toString());
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof NTimesTypeInfo)) {
                return false;
            }
            NTimesTypeInfo oh = (NTimesTypeInfo)other;
            return this.showTimes == oh.showTimes && this.shownToTimes.equals(oh.shownToTimes);
        }
    }
}

