/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.holograms.storage;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.events.HologramsLoadedEvent;
import me.ford.periodicholographicdisplays.holograms.storage.HologramInfo;
import me.ford.periodicholographicdisplays.holograms.storage.Storage;
import me.ford.periodicholographicdisplays.holograms.storage.TypeInfo;
import me.ford.periodicholographicdisplays.storage.sqlite.SQLStorageBase;
import me.ford.periodicholographicdisplays.util.TimeUtils;
import org.bukkit.event.Event;
import org.bukkit.plugin.PluginManager;

public class SQLStorage
extends SQLStorageBase
implements Storage {
    private final IPeriodicHolographicDisplays phd;
    private final PluginManager pm;
    private final String hologramTableName = "phd_hologram";
    private final String playerTableName = "phd_player";

    public SQLStorage(IPeriodicHolographicDisplays phd, PluginManager pm) {
        super(phd);
        this.phd = phd;
        this.pm = pm;
    }

    @Override
    public void saveHolograms(Set<Storage.HDHologramInfo> holograms, boolean inSync) {
        if (inSync) {
            this.saveHologramsAsync(holograms);
        } else {
            this.phd.getScheduler().runTaskAsync(() -> this.saveHologramsAsync(holograms));
        }
    }

    private void saveHologramsAsync(Set<Storage.HDHologramInfo> holograms) {
        this.createHologramTableIfNotExists();
        this.createPlayerTableIfNotExists();
        String deleteQuery = "DELETE FROM phd_hologram WHERE hologram_name=? AND hologram_type=?";
        String query = "INSERT INTO phd_hologram VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?) ON CONFLICT(hologram_name, hologram_type) DO UPDATE SET activation_distance=? , display_seconds=? , clock_time=?, max_views=?, permission=?, flash_on=?, flash_off=?;";
        for (Storage.HDHologramInfo hologram : holograms) {
            for (HologramInfo info : hologram.getInfos()) {
                PreparedStatement statement;
                TypeInfo typeInfo = info.getTypeInfo();
                if (typeInfo instanceof TypeInfo.NullTypeInfo) {
                    this.executeUpdate(deleteQuery, info.getName(), typeInfo.getType().name());
                    this.saveTypeInfoAsync(info.getName(), typeInfo);
                    continue;
                }
                String time = "";
                switch (info.getType()) {
                    case IRLTIME: {
                        TypeInfo.IRLTimeTypeInfo irlTypeInfo = (TypeInfo.IRLTimeTypeInfo)typeInfo;
                        time = TimeUtils.toIRLTime(irlTypeInfo.getAtTime());
                        break;
                    }
                    case MCTIME: {
                        TypeInfo.MCTimeTypeInfo mcTypeInfo = (TypeInfo.MCTimeTypeInfo)typeInfo;
                        time = TimeUtils.toMCTime(mcTypeInfo.getAtTime());
                        break;
                    }
                    case ALWAYS: 
                    case NTIMES: {
                        time = "";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Incorrect type of info:" + info.getType());
                    }
                }
                int activationTimes = 0;
                if (info.getType() == PeriodicType.NTIMES) {
                    activationTimes = ((TypeInfo.NTimesTypeInfo)info.getTypeInfo()).getShowTimes();
                }
                try {
                    statement = conn.prepareStatement(query);
                    statement.setString(1, info.getName());
                    statement.setString(2, info.getType().name());
                    statement.setDouble(3, info.getActivationDistance());
                    statement.setLong(4, info.getShowTime());
                    statement.setString(5, time);
                    statement.setInt(6, activationTimes);
                    statement.setString(7, info.getPermissions());
                    statement.setDouble(8, info.getFlashOn());
                    statement.setDouble(9, info.getFlashOff());
                    statement.setDouble(10, info.getActivationDistance());
                    statement.setLong(11, info.getShowTime());
                    statement.setString(12, time);
                    statement.setInt(13, activationTimes);
                    statement.setString(14, info.getPermissions());
                    statement.setDouble(15, info.getFlashOn());
                    statement.setDouble(16, info.getFlashOff());
                }
                catch (SQLException e) {
                    this.phd.getLogger().log(Level.WARNING, "Problem while setting up prepared statement", e);
                    continue;
                }
                try {
                    statement.executeUpdate();
                    statement.close();
                }
                catch (SQLException e) {
                    this.phd.getLogger().log(Level.WARNING, "Problem while executing update", e);
                }
                this.saveTypeInfoAsync(info.getName(), typeInfo);
            }
        }
    }

    private void saveTypeInfoAsync(String holoName, TypeInfo info) {
        String query = "INSERT INTO phd_player VALUES (?, ?, ?, ?) ON CONFLICT(player_UUID, hologram_name, hologram_type) DO UPDATE SET views=?;";
        if (info instanceof TypeInfo.NullTypeInfo) {
            String deleteQuery = "DELETE FROM phd_player WHERE hologram_name=? AND hologram_type=?;";
            this.executeUpdate(deleteQuery, holoName, info.getType().name());
            return;
        }
        String deleteQuery = "DELETE FROM phd_player WHERE player_UUID=? AND hologram_name=? AND hologram_type=?;";
        switch (info.getType()) {
            case NTIMES: {
                TypeInfo.NTimesTypeInfo ninfo = (TypeInfo.NTimesTypeInfo)info;
                for (Map.Entry<UUID, Integer> entry : ninfo.getShownToTimes().entrySet()) {
                    PreparedStatement statement;
                    try {
                        boolean isDelete = entry.getValue() == 0;
                        statement = !isDelete ? conn.prepareStatement(query) : conn.prepareStatement(deleteQuery);
                        statement.setString(1, entry.getKey().toString());
                        statement.setString(2, holoName);
                        statement.setString(3, info.getType().name());
                        if (!isDelete) {
                            statement.setInt(4, entry.getValue());
                            statement.setInt(5, entry.getValue());
                        }
                    }
                    catch (SQLException e) {
                        this.phd.getLogger().log(Level.WARNING, "Problem while setting up prepared statement", e);
                        continue;
                    }
                    try {
                        statement.executeUpdate();
                        statement.close();
                    }
                    catch (SQLException e) {
                        this.phd.getLogger().log(Level.WARNING, "Problem while executing update", e);
                    }
                }
                break;
            }
        }
    }

    @Override
    public void loadHolograms(Consumer<Storage.HDHologramInfo> consumer) {
        this.phd.getScheduler().runTaskAsync(() -> this.loadHologramsAsync(consumer));
    }

    private void loadHologramsAsync(Consumer<Storage.HDHologramInfo> consumer) {
        this.createHologramTableIfNotExists();
        this.createPlayerTableIfNotExists();
        HashMap<String, Storage.HDHologramInfo> infos = new HashMap<String, Storage.HDHologramInfo>();
        String query = "SELECT * FROM phd_hologram;";
        SQLStorageBase.SQLResponse sr = this.executeQuery(query, new String[0]);
        if (sr == null) {
            return;
        }
        ResultSet rs = sr.getResultSet();
        try {
            while (rs.next()) {
                TypeInfo typeInfo;
                Storage.HDHologramInfo info;
                PeriodicType type;
                String holoName = rs.getString("hologram_name");
                String typeStr = rs.getString("hologram_type");
                try {
                    type = PeriodicType.valueOf(typeStr);
                }
                catch (IllegalArgumentException e) {
                    this.phd.getLogger().log(Level.WARNING, "Unable to parse periodic type from '" + typeStr + "'", e);
                    continue;
                }
                double distance = rs.getDouble("activation_distance");
                int seconds = rs.getInt("display_seconds");
                String time = rs.getString("clock_time");
                String perms = rs.getString("permission");
                double flashOn = rs.getDouble("flash_on");
                double flashOff = rs.getDouble("flash_off");
                if (flashOn == 0.0 || flashOff == 0.0) {
                    flashOn = -1.0;
                    flashOff = -1.0;
                }
                if ((info = (Storage.HDHologramInfo)infos.get(holoName)) == null) {
                    info = new Storage.HDHologramInfo(holoName);
                    infos.put(holoName, info);
                }
                String activationTimes = rs.getString("max_views");
                try {
                    typeInfo = this.getTypeInfo(type, time, activationTimes);
                }
                catch (IllegalArgumentException e) {
                    this.phd.getLogger().log(Level.WARNING, "Unable to get typeinfo of " + holoName + " of type " + type.name());
                    continue;
                }
                HologramInfo holo = new HologramInfo(holoName, type, distance, seconds, perms, typeInfo, flashOn, flashOff);
                info.addInfo(holo);
            }
        }
        catch (SQLException e) {
            this.phd.getLogger().log(Level.WARNING, "Issue while loading holograms from database!", e);
        }
        sr.close();
        for (Storage.HDHologramInfo info : infos.values()) {
            for (HologramInfo hinfo : info.getInfos()) {
                if (hinfo.getType() != PeriodicType.NTIMES) continue;
                this.addShownTo(info.getHoloName(), (TypeInfo.NTimesTypeInfo)hinfo.getTypeInfo());
            }
        }
        this.phd.getScheduler().runTask(() -> {
            for (Storage.HDHologramInfo info : infos.values()) {
                consumer.accept(info);
            }
            this.pm.callEvent((Event)new HologramsLoadedEvent());
        });
    }

    private void addShownTo(String name, TypeInfo.NTimesTypeInfo info) {
        String query = "SELECT * FROM phd_player WHERE hologram_name=?;";
        SQLStorageBase.SQLResponse sr = this.executeQuery(query, name);
        if (sr == null) {
            return;
        }
        ResultSet rs = sr.getResultSet();
        try {
            while (rs.next()) {
                UUID uuid;
                String id = rs.getString("player_UUID");
                try {
                    uuid = UUID.fromString(id);
                }
                catch (IllegalArgumentException e) {
                    this.phd.getLogger().log(Level.WARNING, "Cannot parse UUID " + id);
                    continue;
                }
                int ntimes = rs.getInt("views");
                info.addShownTo(uuid, ntimes);
            }
        }
        catch (SQLException e) {
            this.phd.getLogger().log(Level.WARNING, "Issue while loading user shown times from database!", e);
        }
        sr.close();
    }

    private TypeInfo getTypeInfo(PeriodicType type, String time, String activationTimes) {
        int times = -1;
        return switch (type) {
            case PeriodicType.IRLTIME -> new TypeInfo.IRLTimeTypeInfo(TimeUtils.parseHoursAndMinutesToSeconds(time));
            case PeriodicType.MCTIME -> new TypeInfo.MCTimeTypeInfo(TimeUtils.parseMCTime(time));
            case PeriodicType.ALWAYS, PeriodicType.NTIMES -> {
                if (type == PeriodicType.NTIMES) {
                    try {
                        times = Integer.parseInt(activationTimes);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Incorrect activation times specified:" + activationTimes);
                    }
                }
                yield new TypeInfo.NTimesTypeInfo(times, new HashMap<UUID, Integer>());
            }
            default -> throw new IllegalArgumentException("Incorrect type specified:" + type);
        };
    }

    public void createHologramTableIfNotExists() {
        String indexQuery;
        String query = "CREATE TABLE IF NOT EXISTS phd_hologram (hologram_name VARCHAR(255) NOT NULL,hologram_type VARCHAR(16) NOT NULL,activation_distance REAL DEFAULT -1.0,display_seconds INTEGER DEFAULT -1,clock_time VARCHAR(8),max_views INTEGER,permission VARCHAR(255),flash_on REAL DEFAULT -1.0,flash_off REAL DEFAULT -1.0,PRIMARY KEY (hologram_name, hologram_type));";
        if (!this.executeUpdate(query, new String[0])) {
            this.phd.getLogger().severe("Unable to create table: phd_hologram");
        }
        if (!this.executeUpdate(indexQuery = "CREATE INDEX IF NOT EXISTS phd_hologram_hindex ON phd_hologram ( hologram_name, hologram_type );", new String[0])) {
            this.phd.getLogger().severe("Unable to create index for phd_hologram");
        }
    }

    public void createPlayerTableIfNotExists() {
        String indexQuery2;
        String indexQuery1;
        String query = "CREATE TABLE IF NOT EXISTS phd_player(player_UUID VARCHAR(36) NOT NULL, hologram_name VARCHAR(255) NOT NULL, hologram_type VARCHAR(16) NOT NULL, views INTEGER, PRIMARY KEY (player_UUID, hologram_name, hologram_type));";
        if (!this.executeUpdate(query, new String[0])) {
            this.phd.getLogger().severe("Unable to create table: phd_player");
        }
        if (!this.executeUpdate(indexQuery1 = "CREATE INDEX IF NOT EXISTS phd_player_pindex ON phd_player ( player_UUID );", new String[0])) {
            this.phd.getLogger().severe("Unable to create index (1) for phd_player");
        }
        if (!this.executeUpdate(indexQuery2 = "CREATE INDEX IF NOT EXISTS phd_player_hindex ON phd_player ( hologram_name, hologram_type );", new String[0])) {
            this.phd.getLogger().severe("Unable to create index (2) for phd_player");
        }
    }

    @Override
    public boolean hasData() {
        String holgorams = "SELECT name FROM sqlite_master WHERE type='table' AND name='phd_hologram';";
        String players = "SELECT name FROM sqlite_master WHERE type='table' AND name='phd_player';";
        SQLStorageBase.SQLResponse sr = this.executeQuery(holgorams, new String[0]);
        if (sr == null) {
            return false;
        }
        ResultSet rs = sr.getResultSet();
        try {
            if (!rs.next()) {
                return false;
            }
        }
        catch (SQLException e) {
            this.phd.getLogger().log(Level.WARNING, "Problem checking for existance of table (hologram table)", e);
        }
        sr.close();
        sr = this.executeQuery(players, new String[0]);
        if (sr == null) {
            return false;
        }
        rs = sr.getResultSet();
        try {
            if (!rs.next()) {
                return false;
            }
        }
        catch (SQLException e) {
            this.phd.getLogger().log(Level.WARNING, "Problem checking for existance of table (player table)", e);
        }
        sr.close();
        return true;
    }

    @Override
    public void clear() {
        this.phd.getScheduler().runTaskAsync(() -> {
            String delHologramTable = "DELETE FROM phd_hologram;";
            this.executeUpdate(delHologramTable, new String[0]);
            String delPlayerTable = "DELETE FROM phd_player;";
            this.executeUpdate(delPlayerTable, new String[0]);
        });
    }
}

