/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.holograms.perchunk;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HChunk {
    private static final Map<Integer, Map<Integer, HChunk>> CHUNKS = new HashMap<Integer, Map<Integer, HChunk>>();
    private final int x;
    private final int z;

    private HChunk(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.z);
    }

    public static HChunk of(int x, int z) {
        HChunk chunk;
        Map<Integer, HChunk> xChunks = CHUNKS.get(x);
        if (xChunks == null) {
            xChunks = new HashMap<Integer, HChunk>();
            CHUNKS.put(x, xChunks);
        }
        if ((chunk = xChunks.get(z)) == null) {
            chunk = new HChunk(x, z);
            xChunks.put(z, chunk);
        }
        return chunk;
    }

    public String toString() {
        return String.format("(%d,%d)", this.x, this.z);
    }
}

