/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.holograms;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.holograms.AlwaysHologram;
import me.ford.periodicholographicdisplays.holograms.FlashingHologram;
import me.ford.periodicholographicdisplays.holograms.IRLTimeHologram;
import me.ford.periodicholographicdisplays.holograms.IndividualHologramHandler;
import me.ford.periodicholographicdisplays.holograms.MCTimeHologram;
import me.ford.periodicholographicdisplays.holograms.NTimesHologram;
import me.ford.periodicholographicdisplays.holograms.PeriodicHologramBase;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.WorldHologramStorageBase;
import me.ford.periodicholographicdisplays.holograms.storage.HologramInfo;
import me.ford.periodicholographicdisplays.holograms.storage.Storage;
import me.ford.periodicholographicdisplays.holograms.storage.TypeInfo;
import me.ford.periodicholographicdisplays.holograms.wrap.WrappedHologram;
import me.ford.periodicholographicdisplays.hooks.NPCHook;
import org.apache.commons.lang.Validate;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginManager;

public class WorldHologramStorage
extends WorldHologramStorageBase {
    private final Storage storage;
    private final NPCHook hook;

    public WorldHologramStorage(IPeriodicHolographicDisplays plugin, PluginManager pm, World world, Storage storage) {
        super(plugin, pm, world);
        this.storage = storage;
        this.hook = plugin.getNPCHook();
    }

    public FlashingHologram getHologram(String name, PeriodicType type) {
        IndividualHologramHandler handler = this.getHandler(name);
        if (handler == null) {
            return null;
        }
        return handler.getHologram(type);
    }

    public List<FlashingHologram> getHolograms() {
        return this.getHolograms(false);
    }

    public List<FlashingHologram> getHolograms(boolean onlyLoaded) {
        ArrayList<FlashingHologram> holos = new ArrayList<FlashingHologram>();
        for (IndividualHologramHandler handler : this.getHandlers(onlyLoaded)) {
            holos.addAll(handler.getHolograms());
        }
        return holos;
    }

    public List<String> getHologramNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (IndividualHologramHandler handler : this.getHandlers(false)) {
            names.add(handler.getName());
        }
        return names;
    }

    public void loaded(WrappedHologram holo, Storage.HDHologramInfo info, boolean imported) {
        if (holo.getWorldIfLoaded() != this.getWorld()) {
            return;
        }
        IndividualHologramHandler handler = null;
        for (HologramInfo hInfo : info.getInfos()) {
            TypeInfo typeInfo = hInfo.getTypeInfo();
            double distance = hInfo.getActivationDistance();
            long seconds = hInfo.getShowTime();
            double flashOn = hInfo.getFlashOn();
            double flashOff = hInfo.getFlashOff();
            FlashingHologram hologram = switch (hInfo.getType()) {
                case PeriodicType.MCTIME -> new MCTimeHologram(this.getPlugin(), holo, info.getHoloName(), distance, seconds, ((TypeInfo.MCTimeTypeInfo)typeInfo).getAtTime(), false, hInfo.getPermissions(), flashOn, flashOff);
                case PeriodicType.IRLTIME -> new IRLTimeHologram(this.getPlugin(), holo, info.getHoloName(), distance, seconds, ((TypeInfo.IRLTimeTypeInfo)typeInfo).getAtTime(), false, hInfo.getPermissions(), flashOn, flashOff);
                case PeriodicType.NTIMES -> {
                    TypeInfo.NTimesTypeInfo ntimesInfo = (TypeInfo.NTimesTypeInfo)typeInfo;
                    NTimesHologram ntimes = new NTimesHologram(this.getPlugin(), holo, info.getHoloName(), distance, seconds, ntimesInfo.getShowTimes(), false, hInfo.getPermissions(), flashOn, flashOff);
                    ntimes.addAllShownTo(ntimesInfo.getShownToTimes());
                    yield ntimes;
                }
                case PeriodicType.ALWAYS -> new AlwaysHologram(this.getPlugin(), holo, info.getHoloName(), distance, seconds, false, hInfo.getPermissions(), flashOn, flashOff);
                default -> throw new IllegalArgumentException("Unexpected pHD type " + hInfo.getType());
            };
            if (handler == null) {
                handler = new IndividualHologramHandler(this.getPluginManager(), holo, hologram.getName());
            }
            handler.addHologram(hInfo.getType(), hologram, !imported);
        }
        if (handler == null) {
            this.getPlugin().getLogger().warning("Loaded hologram with no pHD types:" + info);
            return;
        }
        this.getPlugin().debug("Loaded pHD " + handler.getName() + " with types " + handler.getTypes() + " in " + this.getWorld().getName());
        if (handler != null) {
            this.addHandler(handler.getName(), handler);
        }
    }

    public void resetAlwaysHologramPermissions(Player player) {
        if (this.hook != null && this.hook.isNPC((Entity)player)) {
            return;
        }
        for (PeriodicHologramBase periodicHologramBase : this.getHolograms()) {
            if (!(periodicHologramBase instanceof AlwaysHologram)) continue;
            AlwaysHologram always = (AlwaysHologram)periodicHologramBase;
            if (!always.hasActivationDistance()) {
                if (always.canSee(player)) {
                    always.attemptToShow(player);
                    continue;
                }
                always.hideFrom(player);
                continue;
            }
            if (always.isBeingShownTo(player) && !always.canSee(player)) {
                always.hideFrom(player);
                continue;
            }
            if (always.isBeingShownTo(player) || !always.canSee(player)) continue;
            double dist2 = always.getSquareDistance();
            if (player.getWorld() != this.getWorld() || !(player.getLocation().distanceSquared(always.getLocation()) <= dist2)) continue;
            always.attemptToShow(player);
        }
    }

    @Override
    protected boolean saveHolograms(boolean inSync, WorldHologramStorageBase.HologramSaveReason reason) {
        HashSet<Storage.HDHologramInfo> infos = new HashSet<Storage.HDHologramInfo>();
        for (IndividualHologramHandler handler : this.getHandlers(false)) {
            if (!handler.needsSaved()) continue;
            infos.add(this.getInfo(handler));
            handler.markSaved();
        }
        if (infos.isEmpty()) {
            return false;
        }
        if (this.getPlugin().getSettings().onDebug()) {
            this.getPlugin().debug("in world " + this.getWorld().getName() + " for reason " + reason.name() + " saving:");
            for (Storage.HDHologramInfo info : infos) {
                this.getPlugin().debug("" + info);
            }
        }
        this.storage.saveHolograms(infos, inSync);
        return !infos.isEmpty();
    }

    Storage.HDHologramInfo getInfo(IndividualHologramHandler handler) {
        Storage.HDHologramInfo info = new Storage.HDHologramInfo(handler.getName());
        for (Map.Entry<PeriodicType, FlashingHologram> entry : handler.getToSave().entrySet()) {
            FlashingHologram holo;
            double distance = -1.0;
            long seconds = -1L;
            double flashOn = -1.0;
            double flashOff = -1.0;
            String perms = null;
            PeriodicType type = entry.getKey();
            TypeInfo typeInfo = TypeInfo.of(type, holo = entry.getValue());
            if (!(typeInfo instanceof TypeInfo.NullTypeInfo)) {
                distance = holo.getActivationDistance();
                seconds = holo.getShowTime();
                perms = holo.getPermissions();
                flashOn = holo.getFlashOn();
                flashOff = holo.getFlashOff();
            }
            HologramInfo hInfo = new HologramInfo(handler.getName(), type, distance, seconds, perms, typeInfo, flashOn, flashOff);
            info.addInfo(hInfo);
        }
        return info;
    }

    void addHologram(FlashingHologram hologram) {
        this.addHologram(hologram, false);
    }

    void addHologram(FlashingHologram hologram, boolean wasLoaded) {
        Validate.notNull((Object)hologram, (String)"Cannot add null hologram!");
        Validate.isTrue((hologram.getLocation().getWorld() == this.getWorld() ? 1 : 0) != 0, (String)"Cannot add holograms in a different world!");
        IndividualHologramHandler handler = this.getHandler(hologram.getName());
        if (handler == null) {
            handler = new IndividualHologramHandler(this.getPluginManager(), hologram.getHologram(), hologram.getName());
            this.addHandler(hologram.getName(), handler);
        }
        handler.addHologram(hologram.getType(), hologram, wasLoaded);
    }

    void removeHologram(FlashingHologram hologram) {
        this.removeHologram(hologram, true);
    }

    void removeHologram(FlashingHologram hologram, boolean markForRemoval) {
        Validate.notNull((Object)hologram, (String)"Cannot remove null hologram!");
        Validate.isTrue((hologram.getLocation().getWorld() == this.getWorld() ? 1 : 0) != 0, (String)"Cannot remove holograms in a different world!");
        IndividualHologramHandler handler = this.getHandler(hologram.getName());
        handler.removeHologram(hologram, markForRemoval);
        this.saveHolograms(false, WorldHologramStorageBase.HologramSaveReason.REMOVE);
        if (handler.isEmpty()) {
            this.removeHandler(hologram.getName());
        }
    }
}

