/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.holograms;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.holograms.FlashingHologram;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.wrap.WrappedHologram;
import org.bukkit.entity.Player;

public class NTimesHologram
extends FlashingHologram {
    private int timesToShow;
    private final Map<UUID, Integer> shownTo = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> toSave = new HashMap<UUID, Integer>();

    public NTimesHologram(IPeriodicHolographicDisplays phd, WrappedHologram hologram, String name, double activationDistance, long showTime, int timesToShow, boolean isNew, String perms, double flashOn, double flashOff) {
        this(phd, hologram, name, activationDistance, showTime, PeriodicType.NTIMES, timesToShow, isNew, perms, flashOn, flashOff);
    }

    NTimesHologram(IPeriodicHolographicDisplays phd, WrappedHologram hologram, String name, double activationDistance, long showTime, PeriodicType type, int timesToShow, boolean isNew, String perms, double flashOn, double flashOff) {
        super(phd, hologram, name, activationDistance, showTime, type, isNew, perms, flashOn, flashOff);
        this.timesToShow = timesToShow;
    }

    @Override
    public void attemptToShow(Player player) {
        if (!this.canSee(player)) {
            return;
        }
        if (this.isBeingShownTo(player)) {
            return;
        }
        UUID id = player.getUniqueId();
        Integer shown = this.shownTo.get(id);
        if (this.timesToShow == -1 || shown == null || shown < this.timesToShow) {
            if (shown == null) {
                shown = 0;
            }
            this.show(player);
            if (this.timesToShow > 0) {
                this.addShownTo(id, shown + 1);
            }
        }
    }

    public void setTimesToShow(int times) {
        this.timesToShow = times;
        this.markChanged();
    }

    public int getTimesToShow() {
        return this.timesToShow;
    }

    public Map<UUID, Integer> getShownTo() {
        return new HashMap<UUID, Integer>(this.shownTo);
    }

    public Map<UUID, Integer> getToSave() {
        return new HashMap<UUID, Integer>(this.toSave);
    }

    void addAllShownTo(Map<UUID, Integer> shownTo) {
        for (Map.Entry<UUID, Integer> entry : shownTo.entrySet()) {
            this.addShownTo(entry.getKey(), entry.getValue(), false);
        }
    }

    public void addShownTo(UUID id, int timesShown) {
        this.addShownTo(id, timesShown, true);
    }

    private void addShownTo(UUID id, int timesShown, boolean markChanged) {
        this.shownTo.put(id, timesShown);
        this.toSave.put(id, timesShown);
        if (markChanged) {
            this.markChanged();
        }
    }

    public void resetShownTo(UUID id) {
        this.shownTo.remove(id);
        this.toSave.put(id, 0);
        this.markChanged();
    }

    @Override
    public void markSaved() {
        super.markSaved();
        this.toSave.clear();
    }

    @Override
    protected boolean specialDisable() {
        return false;
    }
}

