/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.holograms;

import dev.ratas.slimedogcore.api.scheduler.SDCTask;
import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.holograms.FlashingHologram;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.wrap.WrappedHologram;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class MCTimeHologram
extends FlashingHologram {
    private static final long DELAY = 24000L;
    private final IPeriodicHolographicDisplays plugin;
    private final MCTimeHologramDisplayer displayer;
    private SDCTask task;
    private long atTime;
    private static final long TIME_FIX = 6000L;

    public MCTimeHologram(IPeriodicHolographicDisplays phd, WrappedHologram hologram, String name, double activationDistance, long showTime, long atTime, boolean isNew, String perms, double flashOn, double flashOff) {
        super(phd, hologram, name, activationDistance, showTime, PeriodicType.MCTIME, isNew, perms, flashOn, flashOff);
        this.atTime = atTime;
        this.plugin = phd;
        this.displayer = new MCTimeHologramDisplayer();
        this.schedule();
    }

    public long getTime() {
        return this.atTime;
    }

    public void timeChanged(long amount) {
        if (amount == 0L) {
            return;
        }
        this.schedule(amount);
    }

    private void schedule() {
        this.schedule(0L);
    }

    private void schedule(long amount) {
        if (this.task != null) {
            this.task.cancel();
        }
        long newTime = (this.getLocation().getWorld().getTime() + amount + 6000L) % 24000L;
        long curDelay = (this.atTime - newTime) % 24000L;
        this.plugin.getScheduler().runTaskTimer(task -> this.runDisplayer((SDCTask)task), curDelay, 24000L);
    }

    private void runDisplayer(SDCTask task) {
        if (this.task == null) {
            this.task = task;
        } else if (this.task != task) {
            task.cancel();
            return;
        }
        this.displayer.run();
    }

    public void setTime(long time) {
        this.atTime = time;
        this.schedule();
        this.markChanged();
    }

    @Override
    public void attemptToShow(Player player) {
    }

    private void showInRange() {
        World world = this.getLocation().getWorld();
        double dist = this.getActivationDistance();
        if (dist == -1.0) {
            dist = this.plugin.getSettings().getDefaultActivationDistance();
        }
        for (Entity entity : world.getNearbyEntities(this.getLocation(), dist, dist, dist, e -> e.getType() == EntityType.PLAYER)) {
            Player player = (Player)entity;
            this.show(player);
        }
    }

    @Override
    protected boolean specialDisable() {
        return false;
    }

    private class MCTimeHologramDisplayer
    implements Runnable {
        private MCTimeHologramDisplayer() {
        }

        @Override
        public void run() {
            MCTimeHologram.this.showInRange();
        }
    }
}

