/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.holograms;

import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.holograms.NTimesHologram;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.wrap.WrappedHologram;
import me.ford.periodicholographicdisplays.hooks.NPCHook;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class AlwaysHologram
extends NTimesHologram {
    public AlwaysHologram(IPeriodicHolographicDisplays phd, WrappedHologram hologram, String name, double activationDistance, long showTime, boolean isNew, String perms, double flashOn, double flashOff) {
        super(phd, hologram, name, activationDistance, showTime, PeriodicType.ALWAYS, -1, isNew, perms, flashOn, flashOff);
        this.checkWorldPlayers();
    }

    public boolean isShownWhileInArea() {
        return this.isForever() && this.hasActivationDistance();
    }

    public boolean isShownOnWorldJoin() {
        return !this.hasActivationDistance() && this.isForever();
    }

    public boolean isForever() {
        return -1L == this.getShowTime();
    }

    public void leftArea(Player player) {
        if (this.isBeingShownTo(player)) {
            this.hideFrom(player);
        }
    }

    private void checkWorldPlayers() {
        NPCHook hook = this.getPlugin().getNPCHook();
        for (Player player : this.getHologram().getBukkitLocation().getWorld().getEntitiesByClass(Player.class)) {
            if (hook != null && hook.isNPC((Entity)player)) continue;
            if (!this.canSee(player) && this.isBeingShownTo(player)) {
                this.hideFrom(player);
                continue;
            }
            this.attemptToShow(player);
        }
    }

    public boolean hasActivationDistance() {
        return this.getActivationDistance() != -1.0;
    }

    @Override
    protected boolean specialDisable() {
        return this.isShownOnWorldJoin() || this.isShownWhileInArea();
    }

    @Override
    public void resetVisibility() {
        super.resetVisibility();
        if (this.isShownOnWorldJoin()) {
            this.checkWorldPlayers();
        }
    }
}

