/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.commands.subcommands;

import dev.ratas.slimedogcore.api.commands.SDCCommandOptionSet;
import dev.ratas.slimedogcore.api.messaging.recipient.SDCRecipient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import me.ford.periodicholographicdisplays.Messages;
import me.ford.periodicholographicdisplays.Settings;
import me.ford.periodicholographicdisplays.commands.PHDSubCommand;
import me.ford.periodicholographicdisplays.holograms.FlashingHologram;
import me.ford.periodicholographicdisplays.holograms.HologramStorage;
import me.ford.periodicholographicdisplays.holograms.NTimesHologram;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.WorldHologramStorageBase;
import me.ford.periodicholographicdisplays.holograms.wrap.provider.HologramProvider;
import me.ford.periodicholographicdisplays.users.UserCache;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class UnsetSub
extends PHDSubCommand {
    private static final String PERMS = "phd.unset";
    private static final String USAGE = "/phd unset <hologram> <type> <options>";
    private final HologramStorage storage;
    private final Settings settings;
    private final Messages messages;
    private final UserCache userCache;
    private final List<String> optionList = Arrays.asList("seconds", "distance", "permission", "playercount", "flash");

    public UnsetSub(HologramProvider provider, HologramStorage storage, Settings settings, Messages messages, UserCache userCache) {
        super(provider, "unset", PERMS, USAGE);
        this.storage = storage;
        this.settings = settings;
        this.messages = messages;
        this.userCache = userCache;
    }

    @Override
    public List<String> onTabComplete(SDCRecipient sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        switch (args.length) {
            case 1: {
                return (List)StringUtil.copyPartialMatches((String)args[0], this.storage.getNames(), list);
            }
            case 2: {
                ArrayList<String> typeNames = new ArrayList<String>();
                for (PeriodicType type : this.storage.getAvailableTypes(args[0])) {
                    typeNames.add(type.name());
                }
                return (List)StringUtil.copyPartialMatches((String)args[1], typeNames, list);
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                PeriodicType type;
                ArrayList<String> options = new ArrayList<String>(this.optionList);
                try {
                    type = PeriodicType.valueOf(args[1].toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return list;
                }
                if (type == PeriodicType.NTIMES && args[args.length - 2].equalsIgnoreCase("playercount")) {
                    if (args[args.length - 1].length() < 2) {
                        return null;
                    }
                    return this.userCache.getNamesStartingWith(args[args.length - 1]);
                }
                FlashingHologram hologram = this.storage.getHologram(args[0], type);
                if (hologram == null) {
                    return list;
                }
                if (!hologram.hasPermissions()) {
                    options.remove("permission");
                }
                if (hologram.getActivationDistance() == -1.0) {
                    options.remove("distance");
                }
                if (hologram.getShowTime() == -1L) {
                    options.remove("seconds");
                }
                if (type != PeriodicType.NTIMES) {
                    options.remove("playercount");
                }
                if (!hologram.flashes()) {
                    options.remove("flash");
                }
                for (String prevArg : Arrays.copyOfRange(args, 2, args.length - 1)) {
                    options.remove(prevArg);
                }
                return (List)StringUtil.copyPartialMatches((String)args[args.length - 1], options, list);
            }
        }
        return list;
    }

    @Override
    public boolean onOptionedCommand(SDCRecipient sender, String[] args, SDCCommandOptionSet options) {
        PeriodicType type;
        if (args.length < 3) {
            return false;
        }
        try {
            type = PeriodicType.valueOf(args[1].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(this.messages.getTypeNotRecognizedMessage().createWith(args[1]));
            return true;
        }
        FlashingHologram hologram = this.storage.getHologram(args[0], type);
        if (hologram == null) {
            sender.sendMessage(this.messages.getHologramNotFoundMessage().createWith(args[0], type));
            return true;
        }
        String[] opts = Arrays.copyOfRange(args, 2, args.length);
        ArrayList<String> usedOptions = new ArrayList<String>(Arrays.asList(opts));
        String prevOpt = "";
        boolean unsetPlayerCount = false;
        boolean unsetFlash = false;
        String[] stringArray = opts;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String opt;
            switch (opt = stringArray[i]) {
                case "distance": {
                    if (hologram.getActivationDistance() == -1.0) {
                        sender.sendMessage(this.messages.getOptionNotSetMessage().createWith(opt));
                        usedOptions.remove(opt);
                        break;
                    }
                    hologram.defaultDistance(this.settings);
                    break;
                }
                case "seconds": {
                    if (hologram.getShowTime() == -1L) {
                        sender.sendMessage(this.messages.getOptionNotSetMessage().createWith(opt));
                        usedOptions.remove(opt);
                        break;
                    }
                    hologram.defaultShowtime(this.settings);
                    break;
                }
                case "permission": {
                    if (hologram.getPermissions() == null) {
                        sender.sendMessage(this.messages.getOptionNotSetMessage().createWith(opt));
                        usedOptions.remove(opt);
                        break;
                    }
                    hologram.setPermissions(null);
                    break;
                }
                case "flash": {
                    if (!hologram.flashes()) {
                        sender.sendMessage(this.messages.getOptionNotSetMessage().createWith(opt));
                        usedOptions.remove(opt);
                        break;
                    }
                    hologram.setNoFlash();
                    usedOptions.remove(opt);
                    sender.sendMessage(this.messages.getUnsetFlashMessage().getMessage());
                    unsetFlash = true;
                    break;
                }
                case "playercount": {
                    if (hologram.getType() != PeriodicType.NTIMES) {
                        sender.sendMessage(this.messages.getNoSuchOptionMessage().createWith(type, opt));
                        return true;
                    }
                    NTimesHologram ntimes = (NTimesHologram)hologram;
                    int optAt = 0;
                    for (String copt : opts) {
                        if (opt == copt) break;
                        ++optAt;
                    }
                    if (opts.length < optAt + 2) {
                        sender.sendMessage(this.messages.getNeedCountAfterPlayercount().getMessage());
                        return true;
                    }
                    String playerName = opts[optAt + 1];
                    Player player = Bukkit.getPlayer((String)playerName);
                    if (player == null) {
                        UUID id = this.userCache.getUuid(playerName);
                        if (id != null) {
                            player = Bukkit.getOfflinePlayer((UUID)id);
                        }
                        if (player == null || !player.hasPlayedBefore()) {
                            sender.sendMessage(this.messages.getPlayerNotFoundMessage().createWith(playerName));
                            return true;
                        }
                    }
                    if (ntimes.getShownTo().get(player.getUniqueId()) == null) {
                        sender.sendMessage(this.messages.getOptionNotSetMessage().createWith(String.format("%s (for %s)", opt, player.getName())));
                        usedOptions.remove(opt);
                        break;
                    }
                    ntimes.resetShownTo(player.getUniqueId());
                    unsetPlayerCount = true;
                    usedOptions.remove(opt);
                    sender.sendMessage(this.messages.getUnsetPlayerCountMessage().createWith((OfflinePlayer)player));
                    break;
                }
                case "time": {
                    if (type == PeriodicType.MCTIME || type == PeriodicType.IRLTIME) {
                        sender.sendMessage(this.messages.getCannotUnSetRequiredMessage().createWith(opt, type));
                        usedOptions.remove(opt);
                        break;
                    }
                }
                case "times": {
                    if (type == PeriodicType.NTIMES) {
                        sender.sendMessage(this.messages.getCannotUnSetRequiredMessage().createWith(opt, type));
                        usedOptions.remove(opt);
                        break;
                    }
                }
                default: {
                    if (!prevOpt.equalsIgnoreCase("playercount")) {
                        sender.sendMessage(this.messages.getNoSuchOptionMessage().createWith(type, opt));
                    }
                    usedOptions.remove(opt);
                }
            }
            prevOpt = opt;
        }
        if (usedOptions.isEmpty()) {
            if (!unsetPlayerCount && !unsetFlash) {
                sender.sendMessage(this.messages.getNothingToUnsetMessage().getMessage());
            } else {
                hologram.resetVisibility();
                this.storage.save(WorldHologramStorageBase.HologramSaveReason.CHANGE, false);
            }
            return true;
        }
        sender.sendMessage(this.messages.getUnsetOptionsMessage().createWith(usedOptions));
        hologram.resetVisibility();
        this.storage.save(WorldHologramStorageBase.HologramSaveReason.CHANGE, false);
        return true;
    }
}

