/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.commands.subcommands;

import dev.ratas.slimedogcore.api.commands.SDCCommandOptionSet;
import dev.ratas.slimedogcore.api.messaging.recipient.SDCRecipient;
import java.util.ArrayList;
import java.util.List;
import me.ford.periodicholographicdisplays.Messages;
import me.ford.periodicholographicdisplays.commands.PHDSubCommand;
import me.ford.periodicholographicdisplays.holograms.FlashingHologram;
import me.ford.periodicholographicdisplays.holograms.HologramStorage;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.storage.HologramInfo;
import me.ford.periodicholographicdisplays.holograms.storage.Storage;
import me.ford.periodicholographicdisplays.holograms.wrap.provider.HologramProvider;
import org.bukkit.util.StringUtil;

public class UnmanageSub
extends PHDSubCommand {
    private static final String PERMS = "phd.unmanage";
    private static final String USAGE = "/phd unmanage <hologram> <type>";
    private final HologramStorage storage;
    private final Messages messages;

    public UnmanageSub(HologramProvider provider, HologramStorage storage, Messages messages) {
        super(provider, "unmanage", PERMS, USAGE);
        this.storage = storage;
        this.messages = messages;
    }

    @Override
    public List<String> onTabComplete(SDCRecipient sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        switch (args.length) {
            case 1: {
                return (List)StringUtil.copyPartialMatches((String)args[0], this.storage.getNames(true), list);
            }
            case 2: {
                ArrayList<String> typeNames = new ArrayList<String>();
                for (PeriodicType type : this.storage.getAvailableTypes(args[0], true)) {
                    typeNames.add(type.name());
                }
                return (List)StringUtil.copyPartialMatches((String)args[1], typeNames, list);
            }
        }
        return list;
    }

    @Override
    public boolean onOptionedCommand(SDCRecipient sender, String[] args, SDCCommandOptionSet options) {
        PeriodicType type;
        if (args.length < 2) {
            return false;
        }
        try {
            type = PeriodicType.valueOf(args[1].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(this.messages.getTypeNotRecognizedMessage().createWith(args[1]));
            return true;
        }
        FlashingHologram holo = this.storage.getHologram(args[0], type);
        HologramInfo zombie = null;
        if (holo == null) {
            block2: for (Storage.HDHologramInfo info : this.storage.getZombies()) {
                if (!info.getHoloName().equalsIgnoreCase(args[0])) continue;
                for (HologramInfo hInfo : info.getInfos()) {
                    if (hInfo.getType() != type) continue;
                    zombie = hInfo;
                    break block2;
                }
            }
            if (zombie == null) {
                sender.sendMessage(this.messages.getHologramNotFoundMessage().createWith(args[0], type));
                return true;
            }
        }
        if (holo != null) {
            this.storage.removeHologram(holo);
            sender.sendMessage(this.messages.getUnmanagedHologramMessage().createWith(holo.getName(), type));
        } else {
            this.storage.removeZombie(zombie);
            sender.sendMessage(this.messages.getUnmanagedHologramMessage().createWith(zombie.getName(), type));
        }
        return true;
    }
}

