/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.commands.subcommands;

import dev.ratas.slimedogcore.api.commands.SDCCommandOptionSet;
import dev.ratas.slimedogcore.api.messaging.SDCMessage;
import dev.ratas.slimedogcore.api.messaging.context.SDCSingleContext;
import dev.ratas.slimedogcore.api.messaging.recipient.SDCRecipient;
import java.util.ArrayList;
import java.util.List;
import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.Messages;
import me.ford.periodicholographicdisplays.PeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.commands.PHDSubCommand;
import org.bukkit.entity.Player;

public class ReloadSub
extends PHDSubCommand {
    private static final String PERMS = "phd.reload";
    private static final String USAGE = "/phd reload";
    private final IPeriodicHolographicDisplays phd;
    private final Messages messages;

    public ReloadSub(IPeriodicHolographicDisplays phd) {
        super(phd.getHologramProvider(), "reload", PERMS, USAGE);
        this.phd = phd;
        this.messages = phd.getMessages();
    }

    @Override
    public List<String> onTabComplete(SDCRecipient sender, String[] args) {
        return new ArrayList<String>();
    }

    @Override
    public boolean onOptionedCommand(SDCRecipient sender, String[] args, SDCCommandOptionSet options) {
        List<PeriodicHolographicDisplays.ReloadIssue> issues = this.phd.reload();
        if (issues.isEmpty()) {
            if (this.phd.getSettings().useDatabase() && sender instanceof Player) {
                sender.sendMessage(this.messages.getSqlConnectionMessage().getMessage());
            }
            sender.sendMessage(this.messages.getConfigReloadedMessage().getMessage());
            SDCMessage<SDCSingleContext<Boolean>> typeMessage = this.messages.getActiveStorageMessage().createWith(this.phd.getSettings().useDatabase());
            sender.sendMessage(typeMessage);
            if (sender instanceof Player) {
                this.phd.getLogger().info(typeMessage.getFilled());
            }
            if (this.phd.getConfig().isSet("debug")) {
                String debug = "DEBUG is " + this.phd.getSettings().onDebug();
                sender.sendRawMessage(debug);
                if (sender instanceof Player) {
                    this.phd.getLogger().info(debug);
                }
            }
        } else {
            SDCMessage<SDCSingleContext<List<PeriodicHolographicDisplays.ReloadIssue>>> msg = this.messages.getProblemsReloadingConfigMessage().createWith(issues);
            this.phd.getLogger().severe(msg.getFilled());
            if (sender instanceof Player) {
                sender.sendMessage(msg);
                boolean isBeingDisabled = false;
                for (PeriodicHolographicDisplays.ReloadIssue issue : issues) {
                    if (issue == PeriodicHolographicDisplays.DefaultReloadIssue.NO_CONFIG || issue == PeriodicHolographicDisplays.DefaultReloadIssue.NO_FOLDER || issue == PeriodicHolographicDisplays.DefaultReloadIssue.NO_MESSAGES) continue;
                    isBeingDisabled = true;
                    break;
                }
                if (isBeingDisabled) {
                    sender.sendMessage(this.messages.getDisablingMessage().getMessage());
                }
            }
        }
        return true;
    }
}

