/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.commands.subcommands;

import dev.ratas.slimedogcore.api.messaging.recipient.SDCRecipient;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import me.ford.periodicholographicdisplays.commands.PHDSubCommand;
import me.ford.periodicholographicdisplays.holograms.FlashingHologram;
import me.ford.periodicholographicdisplays.holograms.IRLTimeHologram;
import me.ford.periodicholographicdisplays.holograms.MCTimeHologram;
import me.ford.periodicholographicdisplays.holograms.NTimesHologram;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.wrap.provider.HologramProvider;
import me.ford.periodicholographicdisplays.util.TimeUtils;

public abstract class OptionPairSetSub
extends PHDSubCommand {
    protected OptionPairSetSub(HologramProvider provider, String name, String perms, String usage) {
        super(provider, name, perms, usage);
    }

    protected Map<String, String> getOptionPairs(String[] args) {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("Expected an even number of arguments!");
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        boolean isKey = true;
        String curKey = "";
        String curValue = "";
        for (String arg : args) {
            if (isKey) {
                curKey = arg.toLowerCase();
            } else {
                curValue = arg;
            }
            if (!isKey) {
                map.put(curKey, curValue);
            }
            isKey = !isKey;
        }
        if (map.containsKey("flashon") && map.containsKey("flashoff")) {
            map.put("flashoff", (String)map.remove("flashoff"));
        }
        return map;
    }

    protected void setAll(SDCRecipient sender, FlashingHologram holo, Map<String, String> options, boolean doSpecial) throws OptionPairException {
        HashSet invalidOptions = new HashSet();
        block30: for (Map.Entry<String, String> entry : options.entrySet()) {
            String result = entry.getValue();
            if (holo.getType() == PeriodicType.NTIMES && entry.getKey().equalsIgnoreCase("times")) {
                int times;
                try {
                    times = Integer.parseInt(result);
                }
                catch (NumberFormatException e) {
                    throw new OptionPairException(OptionPairExceptionType.NEED_AN_INTEGER, result);
                }
                if (times <= 0) {
                    throw new OptionPairException(OptionPairExceptionType.TIMES_TOO_SMALL, result);
                }
                ((NTimesHologram)holo).setTimesToShow(times);
                continue;
            }
            if ((holo.getType() == PeriodicType.MCTIME || holo.getType() == PeriodicType.IRLTIME) && entry.getKey().equalsIgnoreCase("time")) {
                long time;
                boolean mcTime = holo.getType() == PeriodicType.MCTIME;
                try {
                    time = mcTime ? TimeUtils.parseMCTime(result) : TimeUtils.parseHoursAndMinutesToSeconds(result);
                }
                catch (IllegalArgumentException e) {
                    throw new OptionPairException(OptionPairExceptionType.INCORRECT_TIME, result);
                }
                if (mcTime) {
                    ((MCTimeHologram)holo).setTime(time);
                    continue;
                }
                ((IRLTimeHologram)holo).setTime(time);
                continue;
            }
            switch (entry.getKey()) {
                case "distance": {
                    double distance;
                    try {
                        distance = Double.parseDouble(result);
                    }
                    catch (NumberFormatException e) {
                        throw new OptionPairException(OptionPairExceptionType.NEED_A_NUMBER, result);
                    }
                    if (distance < 1.0) {
                        throw new OptionPairException(OptionPairExceptionType.DISTANCE_NEGATIVE, result);
                    }
                    holo.setActivationDistance(distance);
                    continue block30;
                }
                case "seconds": {
                    int time;
                    try {
                        time = Integer.parseInt(result);
                    }
                    catch (NumberFormatException e) {
                        throw new OptionPairException(OptionPairExceptionType.NEED_AN_INTEGER, result);
                    }
                    if (time < 1) {
                        throw new OptionPairException(OptionPairExceptionType.SECONDS_NEGATIVE, result);
                    }
                    holo.setShowTime(time);
                    continue block30;
                }
                case "permission": {
                    holo.setPermissions(result);
                    continue block30;
                }
                case "flash": {
                    double flashTime;
                    try {
                        flashTime = Double.parseDouble(result);
                    }
                    catch (NumberFormatException e) {
                        throw new OptionPairException(OptionPairExceptionType.NEED_A_NUMBER, result);
                    }
                    if (flashTime < 1.0) {
                        throw new OptionPairException(OptionPairExceptionType.FLASH_TOO_SMALL, result);
                    }
                    holo.setFlashOnOff(flashTime);
                    continue block30;
                }
                case "flashon": {
                    double flashOn;
                    if (!holo.flashes() && !options.containsKey("flashoff")) {
                        throw new OptionPairException(OptionPairExceptionType.FLASH_ONLY_ONE, "flashon");
                    }
                    if (options.containsKey("flash")) {
                        throw new OptionPairException(OptionPairExceptionType.FLASH_ONLY_ONE, "flash");
                    }
                    try {
                        flashOn = Double.parseDouble(result);
                    }
                    catch (NumberFormatException e) {
                        throw new OptionPairException(OptionPairExceptionType.NEED_A_NUMBER, result);
                    }
                    if (flashOn < 1.0) {
                        throw new OptionPairException(OptionPairExceptionType.FLASH_TOO_SMALL, result);
                    }
                    holo.setFlashOnOff(flashOn, holo.getFlashOff());
                    continue block30;
                }
                case "flashoff": {
                    double flashOff;
                    if (!holo.flashes() && !options.containsKey("flashon")) {
                        throw new OptionPairException(OptionPairExceptionType.FLASH_ONLY_ONE, "flashon");
                    }
                    if (options.containsKey("flash")) {
                        throw new OptionPairException(OptionPairExceptionType.FLASH_ONLY_ONE, "flash");
                    }
                    try {
                        flashOff = Double.parseDouble(result);
                    }
                    catch (NumberFormatException e) {
                        throw new OptionPairException(OptionPairExceptionType.NEED_A_NUMBER, result);
                    }
                    if (flashOff < 1.0) {
                        throw new OptionPairException(OptionPairExceptionType.FLASH_TOO_SMALL, result);
                    }
                    holo.setFlashOnOff(holo.getFlashOn(), flashOff);
                    continue block30;
                }
            }
            throw new OptionPairException(OptionPairExceptionType.NO_SUCH_OPTION, entry.getKey());
        }
        for (String opt : invalidOptions) {
            options.remove(opt);
        }
    }

    public class OptionPairException
    extends IllegalArgumentException {
        private final OptionPairExceptionType type;
        private final String extra;
        private static final long serialVersionUID = -2328560427573907651L;

        public OptionPairException(OptionPairExceptionType type, String extra) {
            super(type.name());
            this.type = type;
            this.extra = extra;
        }

        public OptionPairExceptionType getType() {
            return this.type;
        }

        public String getExtra() {
            return this.extra;
        }
    }

    public static enum OptionPairExceptionType {
        NEED_A_NUMBER,
        NEED_AN_INTEGER,
        INCORRECT_TIME,
        NO_SUCH_OPTION,
        DISTANCE_NEGATIVE,
        SECONDS_NEGATIVE,
        FLASH_ONLY_ONE,
        FLASH_TOO_SMALL,
        TIMES_TOO_SMALL;

    }
}

