/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.commands.subcommands;

import dev.ratas.slimedogcore.api.commands.SDCCommandOptionSet;
import dev.ratas.slimedogcore.api.messaging.recipient.SDCRecipient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.Messages;
import me.ford.periodicholographicdisplays.commands.subcommands.OptionPairSetSub;
import me.ford.periodicholographicdisplays.holograms.AlwaysHologram;
import me.ford.periodicholographicdisplays.holograms.FlashingHologram;
import me.ford.periodicholographicdisplays.holograms.HologramStorage;
import me.ford.periodicholographicdisplays.holograms.IRLTimeHologram;
import me.ford.periodicholographicdisplays.holograms.MCTimeHologram;
import me.ford.periodicholographicdisplays.holograms.NTimesHologram;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.WorldHologramStorage;
import me.ford.periodicholographicdisplays.holograms.wrap.WrappedHologram;
import me.ford.periodicholographicdisplays.hooks.LuckPermsHook;
import me.ford.periodicholographicdisplays.util.TimeUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class ManageSub
extends OptionPairSetSub {
    private static final String PERMS = "phd.manage";
    private static final String USAGE_1 = "/phd manage <hologram> <type> times <integer> time <hh:mm> [<options...>]";
    private static final String USAGE;
    private final IPeriodicHolographicDisplays phd;
    private final HologramStorage storage;
    private final LuckPermsHook hook;
    private final Messages messages;
    private final List<String> settables = Arrays.asList("times", "time", "seconds", "distance", "permission", "flash", "flashOn", "flashOff");

    public static String getUsage(PeriodicType type) {
        String msg = USAGE_1.replace("<type>", type.name());
        switch (type) {
            case ALWAYS: {
                msg = msg.replace("time <hh:mm> ", "");
            }
            case IRLTIME: 
            case MCTIME: {
                msg = msg.replace("times <integer> ", "");
                break;
            }
            case NTIMES: {
                msg = msg.replace("time <hh:mm> ", "");
                break;
            }
        }
        return msg;
    }

    public ManageSub(IPeriodicHolographicDisplays phd) {
        super(phd.getHologramProvider(), "manage", PERMS, USAGE);
        this.phd = phd;
        this.storage = phd.getHolograms();
        this.hook = phd.getLuckPermsHook();
        this.messages = phd.getMessages();
    }

    @Override
    public List<String> onTabComplete(SDCRecipient sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        switch (args.length) {
            case 1: {
                return (List)StringUtil.copyPartialMatches((String)args[0], this.getNamedHolograms(), list);
            }
            case 2: {
                List<String> typeNames = PeriodicType.names();
                for (PeriodicType type : this.storage.getAvailableTypes(args[0])) {
                    typeNames.remove(type.name());
                }
                return (List)StringUtil.copyPartialMatches((String)args[1], typeNames, list);
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                PeriodicType type;
                ArrayList<String> options = new ArrayList<String>(this.settables);
                try {
                    type = PeriodicType.valueOf(args[1].toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return list;
                }
                if (type != PeriodicType.MCTIME && type != PeriodicType.IRLTIME) {
                    options.remove("time");
                }
                if (type != PeriodicType.NTIMES) {
                    options.remove("times");
                }
                for (int i = 2; i < args.length - 2; i += 2) {
                    options.remove(args[i]);
                }
                for (String arg : args) {
                    if (arg.equalsIgnoreCase("flash")) {
                        options.remove("flashOn");
                        options.remove("flashOff");
                        continue;
                    }
                    if (!arg.equalsIgnoreCase("flashOn") && !arg.equalsIgnoreCase("flashOff")) continue;
                    options.remove("flash");
                }
                return (List)StringUtil.copyPartialMatches((String)args[args.length - 1], options, list);
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                if (!args[args.length - 2].equalsIgnoreCase("permission")) break;
                if (this.hook == null) {
                    return list;
                }
                return this.hook.tabCompletePermissions((CommandSender)sender, args[args.length - 1]);
            }
        }
        return list;
    }

    @Override
    public boolean onOptionedCommand(SDCRecipient sender, String[] args, SDCCommandOptionSet options) {
        HashMap<String, String> optionPairs;
        boolean defaultedAlways;
        PeriodicType type;
        if (args.length < 1) {
            return false;
        }
        WrappedHologram holo = this.provider.getByName(args[0]);
        if (holo == null) {
            sender.sendMessage(this.messages.getHDHologramNotFoundMessage().createWith(args[0]));
            return true;
        }
        if (args.length < 2) {
            return false;
        }
        try {
            type = PeriodicType.valueOf(args[1].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(this.messages.getTypeNotRecognizedMessage().createWith(args[1]));
            return true;
        }
        boolean bl = defaultedAlways = args.length == 2 && type == PeriodicType.ALWAYS;
        if (args.length < 4 && !defaultedAlways) {
            return false;
        }
        if (defaultedAlways) {
            optionPairs = new HashMap();
        } else {
            try {
                optionPairs = this.getOptionPairs(Arrays.copyOfRange(args, 2, args.length));
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage(this.messages.getNeedPairedOptionsMessage().getMessage());
                return true;
            }
        }
        WorldHologramStorage worldStorage = this.storage.getHolograms(holo.getBukkitLocation().getWorld());
        FlashingHologram existing = worldStorage.getHologram(holo.getName(), type);
        if (existing != null) {
            sender.sendMessage(this.messages.getHologramAlreadyManagedMessage().createWith(holo.getName(), type));
            return true;
        }
        existing = this.adoptHologram(sender, holo, type, optionPairs);
        if (existing == null) {
            return true;
        }
        if (!defaultedAlways) {
            try {
                this.setAll(sender, existing, optionPairs, false);
            }
            catch (OptionPairSetSub.OptionPairException e) {
                switch (e.getType()) {
                    case NEED_A_NUMBER: {
                        sender.sendMessage(this.messages.getNeedANumberMessage().createWith(e.getExtra()));
                        break;
                    }
                    case NEED_AN_INTEGER: {
                        sender.sendMessage(this.messages.getNeedAnIntegerMessage().createWith(e.getExtra()));
                        break;
                    }
                    case INCORRECT_TIME: {
                        sender.sendMessage(this.messages.getIncorrectTimeMessage().createWith(e.getExtra()));
                        break;
                    }
                    case NO_SUCH_OPTION: {
                        sender.sendMessage(this.messages.getNoSuchOptionMessage().createWith(type, e.getExtra()));
                        break;
                    }
                    case DISTANCE_NEGATIVE: {
                        sender.sendMessage(this.messages.getDistanceTooSmallMessage().createWith(e.getExtra()));
                        break;
                    }
                    case SECONDS_NEGATIVE: {
                        sender.sendMessage(this.messages.getSecondsTooSmallMessage().createWith(e.getExtra()));
                        break;
                    }
                    case FLASH_ONLY_ONE: {
                        sender.sendMessage(this.messages.getFlashMustHaveBothMessage().createWith(e.getExtra()));
                        break;
                    }
                    case FLASH_TOO_SMALL: {
                        sender.sendMessage(this.messages.getFlashTimeTooSmallMessage().createWith(e.getExtra()));
                        break;
                    }
                    case TIMES_TOO_SMALL: {
                        sender.sendMessage(this.messages.getNegativeTimesMessage().createWith(e.getExtra()));
                        break;
                    }
                    default: {
                        sender.sendRawMessage("Unusual problem: " + e);
                    }
                }
                if (worldStorage.getHologram(holo.getName(), type) == null) {
                    existing.markRemoved();
                }
                return true;
            }
        }
        this.storage.addHologram(existing);
        sender.sendMessage(this.messages.getStartedManagingMessage().createWith(holo.getName(), type, optionPairs));
        return true;
    }

    private FlashingHologram adoptHologram(SDCRecipient sender, WrappedHologram holo, PeriodicType type, Map<String, String> optionPairs) {
        FlashingHologram existing;
        double defaultDistance = -1.0;
        int showTime = -1;
        String perms = null;
        double flashOn = -1.0;
        double flashOff = -1.0;
        if (optionPairs.containsKey("flash")) {
            try {
                double flash;
                flashOn = flash = Double.parseDouble(optionPairs.get("flash"));
                flashOff = flash;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (optionPairs.containsKey("flashon")) {
            try {
                flashOn = Double.parseDouble(optionPairs.get("flashon"));
            }
            catch (NumberFormatException flash) {
                // empty catch block
            }
        }
        if (optionPairs.containsKey("flashoff")) {
            try {
                flashOff = Double.parseDouble(optionPairs.get("flashoff"));
            }
            catch (NumberFormatException flash) {
                // empty catch block
            }
        }
        switch (type) {
            case IRLTIME: {
                long time;
                String tResult = optionPairs.get("time");
                if (tResult == null) {
                    sender.sendMessage(this.messages.getOptionMissingMessage().createWith(type, "time"));
                    return null;
                }
                try {
                    time = TimeUtils.parseHoursAndMinutesToSeconds(tResult);
                }
                catch (IllegalArgumentException e) {
                    sender.sendMessage(this.messages.getIncorrectTimeMessage().createWith(tResult));
                    return null;
                }
                existing = new IRLTimeHologram(this.phd, holo, holo.getName(), defaultDistance, (long)showTime, time, true, perms, flashOn, flashOff);
                break;
            }
            case MCTIME: {
                long timeAt;
                String timeResult = optionPairs.get("time");
                if (timeResult == null) {
                    sender.sendMessage(this.messages.getOptionMissingMessage().createWith(type, "time"));
                    return null;
                }
                try {
                    timeAt = TimeUtils.parseMCTime(timeResult);
                }
                catch (IllegalArgumentException e) {
                    sender.sendMessage(this.messages.getIncorrectTimeMessage().createWith(timeResult));
                    return null;
                }
                existing = new MCTimeHologram(this.phd, holo, holo.getName(), defaultDistance, (long)showTime, timeAt, true, perms, flashOn, flashOff);
                break;
            }
            case ALWAYS: {
                existing = new AlwaysHologram(this.phd, holo, holo.getName(), defaultDistance, showTime, true, perms, flashOn, flashOff);
                break;
            }
            default: {
                int timesToShow = 1;
                String timesResult = optionPairs.get("times");
                if (timesResult != null) {
                    try {
                        timesToShow = Integer.parseInt(timesResult);
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(this.messages.getNeedAnIntegerMessage().createWith(timesResult));
                        return null;
                    }
                } else {
                    sender.sendMessage(this.messages.getOptionMissingMessage().createWith(type, "times"));
                    return null;
                }
                existing = new NTimesHologram(this.phd, holo, holo.getName(), defaultDistance, (long)showTime, timesToShow, true, perms, flashOn, flashOff);
            }
        }
        return existing;
    }

    static {
        ArrayList<String> lines = new ArrayList<String>();
        for (PeriodicType type : PeriodicType.values()) {
            lines.add(ManageSub.getUsage(type));
        }
        USAGE = String.join((CharSequence)"\n", lines);
    }
}

