/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.commands.subcommands;

import dev.ratas.slimedogcore.api.commands.SDCCommandOptionSet;
import dev.ratas.slimedogcore.api.messaging.recipient.SDCRecipient;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.Messages;
import me.ford.periodicholographicdisplays.commands.PHDSubCommand;
import me.ford.periodicholographicdisplays.holograms.storage.SQLStorage;
import me.ford.periodicholographicdisplays.holograms.storage.Storage;
import me.ford.periodicholographicdisplays.holograms.storage.YAMLStorage;
import me.ford.periodicholographicdisplays.holograms.storage.storageimport.StorageConverter;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.plugin.PluginManager;
import org.bukkit.util.StringUtil;

public class ConvertSub
extends PHDSubCommand {
    private static final String SQLITE = "SQLITE";
    private static final String YAML = "YAML";
    private static final String PERMS = "phd.convert";
    private static final String USAGE = "/phd convert <sourceStorageType> <targetStorageType>";
    private final IPeriodicHolographicDisplays phd;
    private final PluginManager pm;
    private final Messages messages;
    private SQLStorage sqlStorage = null;
    private final List<String> storageTypes = Arrays.asList("SQLITE", "YAML");

    public ConvertSub(IPeriodicHolographicDisplays phd, PluginManager pm) {
        super(phd.getHologramProvider(), "convert", PERMS, USAGE);
        this.phd = phd;
        this.pm = pm;
        this.messages = phd.getMessages();
    }

    @Override
    public List<String> onTabComplete(SDCRecipient sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], this.storageTypes, list);
        }
        if (args.length == 2) {
            ArrayList<String> types = new ArrayList<String>(this.storageTypes);
            types.remove(args[0]);
            return (List)StringUtil.copyPartialMatches((String)args[1], types, list);
        }
        return list;
    }

    @Override
    public boolean onOptionedCommand(SDCRecipient sender, String[] args, SDCCommandOptionSet options) {
        Storage targetStorage;
        Storage sourceStorage;
        YAMLStorage yamlStorage;
        ConvertTypes type;
        if (args.length < 2) {
            return false;
        }
        String from = args[0];
        String to = args[1];
        if (from.equalsIgnoreCase(to)) {
            sender.sendMessage(this.messages.getCannotConvertSameMessage().createWith(from));
            return true;
        }
        if (from.equalsIgnoreCase(SQLITE) && to.equalsIgnoreCase(YAML)) {
            type = ConvertTypes.SQLITE_TO_YAML;
        } else if (from.equalsIgnoreCase(YAML) && to.equalsIgnoreCase(SQLITE)) {
            type = ConvertTypes.YAML_TO_SQLITE;
        } else {
            sender.sendMessage(this.messages.getUnrecognizedStorageTypeMessage().createWith(from, to));
            return true;
        }
        File sourceFile = new File(this.phd.getDataFolder(), type == ConvertTypes.SQLITE_TO_YAML ? "database.db" : "database.yml");
        if (!sourceFile.exists()) {
            sender.sendMessage(this.messages.getStorageTypeDoesNotExistMessage().createWith(from));
            return true;
        }
        if (this.phd.getSettings().useDatabase()) {
            if (this.sqlStorage == null) {
                this.sqlStorage = (SQLStorage)this.phd.getHolograms().getStorage();
            }
            try {
                yamlStorage = new YAMLStorage(this.phd, this.pm);
            }
            catch (InvalidConfigurationException e) {
                sender.sendRawMessage("Unable to create YAML storage");
                e.printStackTrace();
                return true;
            }
        } else {
            if (this.sqlStorage == null) {
                this.sqlStorage = new SQLStorage(this.phd, this.pm);
            }
            yamlStorage = (YAMLStorage)this.phd.getHolograms().getStorage();
        }
        switch (type) {
            case YAML_TO_SQLITE: {
                sourceStorage = yamlStorage;
                targetStorage = this.sqlStorage;
                break;
            }
            case SQLITE_TO_YAML: {
                sourceStorage = this.sqlStorage;
                targetStorage = yamlStorage;
                break;
            }
            default: {
                sender.sendMessage(this.messages.getUnrecognizedStorageTypeMessage().createWith(from, to));
                return true;
            }
        }
        boolean hasData = targetStorage.hasData();
        if (hasData) {
            sender.sendMessage(this.messages.getAlreadyHasDataMessage().createWith(to, targetStorage instanceof SQLStorage));
            return true;
        }
        WhenDone whenDone = new WhenDone(sender, from, to);
        StorageConverter<YAMLStorage, Storage> converter = new StorageConverter<YAMLStorage, Storage>((YAMLStorage)sourceStorage, targetStorage, whenDone);
        converter.startConvert();
        sender.sendMessage(this.messages.getStartedConvertingMessage().createWith(from, to));
        return true;
    }

    private void closeSqlite(String from, String to) {
        if (this.phd.getSettings().useDatabase()) {
            return;
        }
        if (to.equals(SQLITE)) {
            this.phd.getScheduler().runTaskLater(() -> this.closeSqlite(from, "..."), 40L);
            return;
        }
        if (this.sqlStorage == null) {
            return;
        }
        this.phd.debug("Closing SQLite after convert");
        this.sqlStorage.close();
    }

    public SQLStorage getSqlStorage() {
        return this.sqlStorage;
    }

    private static enum ConvertTypes {
        SQLITE_TO_YAML,
        YAML_TO_SQLITE;

    }

    private final class WhenDone
    implements Runnable {
        private final SDCRecipient sender;
        private final String from;
        private final String to;

        private WhenDone(SDCRecipient sender, String from, String to) {
            this.sender = sender;
            this.from = from;
            this.to = to;
        }

        @Override
        public void run() {
            ConvertSub.this.phd.getScheduler().runTask(() -> this.sender.sendMessage(ConvertSub.this.messages.getDoneConvertingMessage().createWith(this.from, this.to)));
            ConvertSub.this.closeSqlite(this.from, this.to);
        }
    }
}

