/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays;

import java.util.HashMap;
import java.util.Map;
import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;

public class Settings {
    private final IPeriodicHolographicDisplays phd;
    private boolean useDatabase;
    private double defaultActivationDistance;
    private int defaultShowTime;
    private long saveDelay;
    private boolean enableMetrics;
    private boolean checkForUpdates;
    private boolean onDebug;

    public Settings(IPeriodicHolographicDisplays plugin) {
        this.phd = plugin;
        this.reload();
    }

    public Map<SettingIssue, String> reload() {
        HashMap<SettingIssue, String> issues = new HashMap<SettingIssue, String>();
        for (SettingIssue issue : SettingIssue.values()) {
            String val = this.phd.getConfig().getString(issue.getPath());
            if (issue.fits(val)) continue;
            issues.put(issue, val);
        }
        this.defaultActivationDistance = this.getDefaultActivationDistance_();
        this.defaultShowTime = this.getDefaultShowTime_();
        this.saveDelay = this.getSaveDelay_();
        this.useDatabase = this.useDatabase_();
        this.enableMetrics = this.enableMetrics_();
        this.checkForUpdates = this.checkForUpdates_();
        this.onDebug = this.onDebug_();
        return issues;
    }

    public double getDefaultActivationDistance() {
        return this.defaultActivationDistance;
    }

    public int getDefaultShowTime() {
        return this.defaultShowTime;
    }

    public long getSaveDelay() {
        return this.saveDelay;
    }

    public boolean useDatabase() {
        return this.useDatabase;
    }

    public boolean enableMetrics() {
        return this.enableMetrics;
    }

    public boolean checkForUpdates() {
        return this.checkForUpdates;
    }

    public boolean onDebug() {
        return this.onDebug;
    }

    private double getDefaultActivationDistance_() {
        return this.phd.getConfig().getDouble("defaults.activation-distance", 20.0);
    }

    private int getDefaultShowTime_() {
        return this.phd.getConfig().getInt("defaults.show-time", 10);
    }

    private long getSaveDelay_() {
        return this.phd.getConfig().getLong("save-frequency", 60L);
    }

    private boolean useDatabase_() {
        String type;
        switch (type = this.phd.getConfig().getString("storage-type", "SQLITE")) {
            case "YAML": {
                return false;
            }
        }
        return true;
    }

    void setDefaultDatabaseInternal() {
        this.useDatabase = true;
    }

    private boolean enableMetrics_() {
        return this.phd.getConfig().getBoolean("enable-metrics", true);
    }

    private boolean checkForUpdates_() {
        return this.phd.getConfig().getBoolean("check-for-updates", true);
    }

    private boolean onDebug_() {
        return this.phd.getConfig().getBoolean("debug", false);
    }

    public static enum SettingIssue {
        ACTIVATION_DISTANCE("defaults.activation-distance", SettingType.DOUBLE_PLUS),
        SHOW_TIME("defaults.show-time", SettingType.INTEGER_PLUS),
        SAVE_DELAY("save-frequency", SettingType.LONG_PLUS),
        ENABLE_METRICS("enable-metrics", SettingType.BOOLEAN),
        CHECK_FOR_UPDATES("check-for-updates", SettingType.BOOLEAN),
        STORAGE("storage-type", SettingType.STORAGE);

        private final String path;
        private final SettingType type;

        private SettingIssue(String path, SettingType type) {
            this.path = path;
            this.type = type;
        }

        public String getPath() {
            return this.path;
        }

        public SettingType getType() {
            return this.type;
        }

        public boolean fits(String val) {
            if (val == null) {
                return false;
            }
            switch (this.type) {
                case DOUBLE: 
                case DOUBLE_PLUS: {
                    try {
                        double d = Double.parseDouble(val);
                        return this.type == SettingType.DOUBLE_PLUS ? d > 0.0 : true;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                case INTEGER: 
                case INTEGER_PLUS: {
                    try {
                        int i = Integer.parseInt(val);
                        return this.type == SettingType.INTEGER_PLUS ? i > 0 : true;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                case LONG: 
                case LONG_PLUS: {
                    try {
                        long l = Long.parseLong(val);
                        return this.type == SettingType.LONG_PLUS ? l > 0L : true;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                case BOOLEAN: {
                    try {
                        Boolean.parseBoolean(val);
                        return true;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                case STORAGE: {
                    return val.equalsIgnoreCase("YAML") || val.equalsIgnoreCase("SQLITE");
                }
            }
            throw new IllegalArgumentException("Unrecognized type!" + this.type);
        }
    }

    public static enum SettingType {
        DOUBLE("DOUBLE"),
        DOUBLE_PLUS("DOUBLE > 0.0"),
        INTEGER("INT"),
        INTEGER_PLUS("INT > 0"),
        LONG("LONG"),
        LONG_PLUS("LONG > 0"),
        BOOLEAN("BOOL"),
        STORAGE("STORAGE");

        private final String name;

        private SettingType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class StorageTypeException
    extends IllegalStateException {
        private static final long serialVersionUID = -1888165138957133828L;
        private final String type;

        public StorageTypeException(String type) {
            super("Only 'YAML' or 'SQLITE' allowed as database type,  got " + type);
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

