/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays;

import dev.ratas.slimedogcore.impl.utils.UpdateChecker;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import me.ford.metrics.bukkit.Metrics;
import me.ford.periodicholographicdisplays.AbstractPeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.Messages;
import me.ford.periodicholographicdisplays.Settings;
import me.ford.periodicholographicdisplays.commands.PHDCommand;
import me.ford.periodicholographicdisplays.holograms.HologramStorage;
import me.ford.periodicholographicdisplays.holograms.Zombificator;
import me.ford.periodicholographicdisplays.holograms.wrap.platform.HologramPlatform;
import me.ford.periodicholographicdisplays.holograms.wrap.platform.NoPlatformException;
import me.ford.periodicholographicdisplays.holograms.wrap.platform.PlatformProvider;
import me.ford.periodicholographicdisplays.holograms.wrap.provider.HologramProvider;
import me.ford.periodicholographicdisplays.hooks.DummyNPCHook;
import me.ford.periodicholographicdisplays.hooks.LuckPermsHook;
import me.ford.periodicholographicdisplays.hooks.NPCHook;
import me.ford.periodicholographicdisplays.hooks.SimpleCitizensHook;
import me.ford.periodicholographicdisplays.listeners.HologramListener;
import me.ford.periodicholographicdisplays.listeners.JoinLeaveListener;
import me.ford.periodicholographicdisplays.listeners.SimpleWorldTimeListener;
import me.ford.periodicholographicdisplays.listeners.WorldListener;
import me.ford.periodicholographicdisplays.listeners.WorldTimeListener;
import me.ford.periodicholographicdisplays.listeners.legacy.LegacyWorldTimeListener;
import me.ford.periodicholographicdisplays.storage.yaml.CustomConfigHandler;
import me.ford.periodicholographicdisplays.users.SimpleUserCache;
import me.ford.periodicholographicdisplays.users.UserCache;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class PeriodicHolographicDisplays
extends AbstractPeriodicHolographicDisplays {
    private static final int SPIGOT_RESOURCE_ID = 77631;
    private static final String HANGAR_AUTHOR = "SlimeDog";
    private static final String HANGAR_SLUG = "pHD";
    private HologramPlatform platform;
    private HologramStorage holograms;
    private Settings settings;
    private Messages messages;
    private LuckPermsHook lpHook;
    private NPCHook citizensHook = null;
    private UserCache userCache;
    private PHDCommand command;
    private CustomConfigHandler config;

    @Override
    public void pluginEnabled() {
        WorldTimeListener worldTimeListener;
        ArrayList<ReloadIssue> issues = new ArrayList<ReloadIssue>();
        try {
            this.config = new CustomConfigHandler(this, "config.yml");
        }
        catch (InvalidConfigurationException e1) {
            issues.add(DefaultReloadIssue.INVALID_CONFIGURATION);
            this.disableMe(issues);
            return;
        }
        try {
            this.messages = new Messages(this);
        }
        catch (InvalidConfigurationException e1) {
            issues.add(DefaultReloadIssue.INVALID_MESSAGES);
            this.disableMe(issues);
            return;
        }
        this.settings = new Settings(this);
        issues.addAll(this.getSettingIssues());
        if (!issues.isEmpty()) {
            this.disableMe(issues);
            return;
        }
        try {
            this.platform = new PlatformProvider(this).getHologramProvider();
        }
        catch (NoPlatformException e) {
            issues.add(DefaultReloadIssue.NO_PLATFORM);
            this.disableMe(issues);
            return;
        }
        this.getLogger().info("Hologram provider: " + this.platform.getName());
        try {
            this.holograms = new HologramStorage(this, this.getServer().getPluginManager());
        }
        catch (InvalidConfigurationException e1) {
            issues.add(DefaultReloadIssue.INVALID_HOLOGRAMS);
            this.disableMe(issues);
            return;
        }
        this.saveDefaultConfig();
        this.userCache = new SimpleUserCache(this);
        try {
            this.messages.reloadConfig();
        }
        catch (IllegalStateException e) {
            this.getLogger().severe(this.messages.getDisablingMessage().getMessage().getFilled());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            this.lpHook = new LuckPermsHook(this);
        }
        catch (IllegalStateException | NoClassDefFoundError e) {
            this.getLogger().warning(this.messages.getNoLPMessage().getMessage().getFilled());
        }
        try {
            this.citizensHook = new SimpleCitizensHook();
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            this.citizensHook = new DummyNPCHook();
        }
        this.getServer().getPluginManager().registerEvents((Listener)new HologramListener(this.holograms, this.citizensHook), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinLeaveListener(this, this.holograms), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(this.holograms), (Plugin)this);
        String version = this.getServer().getBukkitVersion();
        if (version.contains("1.15") || version.contains("1.16") || version.contains("1.17") || version.contains("1.18") || version.contains("1.19") || version.contains("1.20") || version.contains("1.21") || version.contains("1.22")) {
            worldTimeListener = new SimpleWorldTimeListener(this.holograms);
        } else {
            this.getLogger().warning(this.messages.getLegacyMessage().getMessage().getFilled());
            worldTimeListener = new LegacyWorldTimeListener(this.holograms);
        }
        this.getServer().getPluginManager().registerEvents((Listener)worldTimeListener, (Plugin)this);
        if (this.settings.enableMetrics()) {
            Metrics metrics = new Metrics((Plugin)this, 7234);
            metrics.addCustomChart(new Metrics.SimplePie("hologram_provider", () -> this.platform.getName()));
        }
        this.command = new PHDCommand(this, this.getServer().getPluginManager());
        this.getCommand("phd").setExecutor((CommandExecutor)this.command);
        new Zombificator(this);
        if (this.settings.checkForUpdates()) {
            String source = this.getDefaultConfig().getConfig().getString("update-source", "Hangar");
            BiConsumer<UpdateChecker.VersionResponse, String> consumer = (response, ver) -> {
                switch (response) {
                    case LATEST: {
                        this.getLogger().info("Using latest version of pHD");
                        break;
                    }
                    case FOUND_NEW: {
                        this.getLogger().info("A new version of pHD is available: " + ver);
                        break;
                    }
                    case UNAVAILABLE: {
                        this.getLogger().info("Version information currently unavailable");
                    }
                }
            };
            UpdateChecker checker = source.equalsIgnoreCase("Hangar") ? UpdateChecker.forHangar(this, consumer, HANGAR_AUTHOR, HANGAR_SLUG) : UpdateChecker.forSpigot(this, consumer, 77631);
            checker.check();
        }
        this.getLogger().info(this.messages.getActiveStorageMessage().createWith(this.getSettings().useDatabase()).getFilled());
    }

    @Override
    public void pluginDisabled() {
    }

    private void disableMe(List<ReloadIssue> issues) {
        boolean canMessage = false;
        if (this.messages == null) {
            try {
                this.messages = new Messages(this);
                canMessage = true;
            }
            catch (InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }
        if (canMessage) {
            this.getLogger().severe(this.messages.getProblemsReloadingConfigMessage().createWith(issues).getFilled());
            this.getLogger().severe(this.messages.getDisablingMessage().getMessage().getFilled());
        } else {
            this.getLogger().severe("Disabling plugins. Problems: " + issues);
        }
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
    }

    @Override
    public File getWorldContainer() {
        return this.getServer().getWorldContainer();
    }

    @Override
    public UserCache getUserCache() {
        return this.userCache;
    }

    @Override
    public NPCHook getNPCHook() {
        return this.citizensHook;
    }

    @Override
    public LuckPermsHook getLuckPermsHook() {
        return this.lpHook;
    }

    @Override
    public List<ReloadIssue> reload() {
        File configFile;
        ArrayList<ReloadIssue> issues = new ArrayList<ReloadIssue>();
        File df = this.getDataFolder();
        if (!df.exists() || !df.canRead()) {
            this.getLogger().warning(this.messages.getNoPluginFolderMessage().getMessage().getFilled());
            boolean wasCreated = df.mkdir();
            DefaultReloadIssue dri = DefaultReloadIssue.NO_FOLDER;
            dri.setExtra(String.valueOf(wasCreated));
            issues.add(dri);
        }
        if (!(configFile = new File(this.getDataFolder(), "config.yml")).exists()) {
            issues.add(DefaultReloadIssue.NO_CONFIG);
            this.saveDefaultConfig();
        }
        this.messages.getConfigReloadedMessage();
        File messagesFile = this.messages.getFile();
        if (!messagesFile.exists()) {
            this.messages.saveDefaultConfig();
            issues.add(DefaultReloadIssue.NO_MESSAGES);
        }
        boolean disablePlugin = false;
        this.messages.reloadConfig();
        List<ReloadIssue> settingIssues = this.getSettingIssues();
        issues.addAll(settingIssues);
        if (!settingIssues.isEmpty()) {
            disablePlugin = true;
        }
        try {
            this.holograms.reload();
        }
        catch (InvalidConfigurationException e) {
            issues.add(DefaultReloadIssue.INVALID_HOLOGRAMS);
            disablePlugin = true;
        }
        if (disablePlugin) {
            this.getServer().getScheduler().runTask((Plugin)this, () -> this.disableMe(issues));
        }
        this.command.reload();
        return issues;
    }

    private List<ReloadIssue> getSettingIssues() {
        ArrayList<ReloadIssue> issues = new ArrayList<ReloadIssue>();
        try {
            issues.addAll(this.reloadMyConfig());
        }
        catch (Settings.StorageTypeException e) {
            DefaultReloadIssue issue = DefaultReloadIssue.ILLEGA_STORAGE_TYPE;
            issue.setExtra(e.getType());
            issues.add(issue);
            this.settings.setDefaultDatabaseInternal();
        }
        return issues;
    }

    @Override
    public List<ReloadIssue> reloadMyConfig() {
        HashMap<Settings.SettingIssue, String> settingIssues = new HashMap<Settings.SettingIssue, String>();
        ArrayList<ReloadIssue> issues = new ArrayList<ReloadIssue>();
        try {
            this.config.reloadConfig();
        }
        catch (InvalidConfigurationException e) {
            issues.add(DefaultReloadIssue.INVALID_CONFIGURATION);
        }
        if (this.settings != null) {
            settingIssues.putAll(this.settings.reload());
        }
        if (settingIssues != null && !settingIssues.isEmpty()) {
            for (Map.Entry entry : settingIssues.entrySet()) {
                if (entry.getKey() == Settings.SettingIssue.STORAGE) {
                    DefaultReloadIssue issue = DefaultReloadIssue.ILLEGA_STORAGE_TYPE;
                    issue.setExtra((String)entry.getValue());
                    issues.add(issue);
                    continue;
                }
                issues.add(new SimpleReloadIssue(this.messages.getProblemWithConfigMessage().createWith((Settings.SettingIssue)((Object)entry.getKey()), (String)entry.getValue()).getFilled(), null));
            }
        }
        return issues;
    }

    @Override
    public void onDisable() {
        if (this.holograms != null) {
            this.holograms.save(true);
        }
    }

    @Override
    public HologramStorage getHolograms() {
        return this.holograms;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public Messages getMessages() {
        return this.messages;
    }

    @Override
    public void debug(String message) {
        if (this.settings.onDebug()) {
            this.getLogger().info("[DEBUG] " + message);
        }
    }

    @Override
    public FileConfiguration getConfig() {
        return this.config.getConfig();
    }

    @Override
    public HologramProvider getHologramProvider() {
        return this.platform.getHologramProvider();
    }

    @Override
    public HologramPlatform getHologramPlatform() {
        return this.platform;
    }

    public static enum DefaultReloadIssue implements ReloadIssue
    {
        NONE(null),
        NO_FOLDER("folder had to be recreated!"),
        NO_CONFIG("the config had to be recreated"),
        NO_MESSAGES("the messages file had to be recreated"),
        ILLEGA_STORAGE_TYPE("storage type not understood"),
        INVALID_CONFIGURATION("config.yml was incorrectly formatted"),
        INVALID_MESSAGES("messages.yml was incorrectly formatted"),
        INVALID_HOLOGRAMS("database.yml was incorrectly formatted"),
        NO_PLATFORM("no holgoram platform found. Currently supported:" + PlatformProvider.getSupportedPlatformNames());

        private final String issue;
        private String extra = null;

        private DefaultReloadIssue(String issue) {
            this.issue = issue;
        }

        @Override
        public String getIssue() {
            return this.issue;
        }

        @Override
        public String getExtra() {
            return this.extra;
        }

        public void setExtra(String extra) {
            this.extra = extra;
        }
    }

    public static class SimpleReloadIssue
    implements ReloadIssue {
        private final String issue;
        private final String extra;

        public SimpleReloadIssue(String issue, String extra) {
            this.issue = issue;
            this.extra = extra;
        }

        @Override
        public String getIssue() {
            return this.issue;
        }

        @Override
        public String getExtra() {
            return this.extra;
        }
    }

    public static interface ReloadIssue {
        public String getIssue();

        public String getExtra();
    }
}

