/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays;

import dev.ratas.slimedogcore.api.messaging.SDCMessage;
import dev.ratas.slimedogcore.api.messaging.context.SDCQuadrupleContext;
import dev.ratas.slimedogcore.api.messaging.context.SDCTripleContext;
import dev.ratas.slimedogcore.api.messaging.delivery.MessageTarget;
import dev.ratas.slimedogcore.api.messaging.factory.SDCDoubleContextMessageFactory;
import dev.ratas.slimedogcore.api.messaging.factory.SDCSingleContextMessageFactory;
import dev.ratas.slimedogcore.api.messaging.factory.SDCTripleContextMessageFactory;
import dev.ratas.slimedogcore.api.messaging.factory.SDCVoidContextMessageFactory;
import dev.ratas.slimedogcore.impl.messaging.MessagesBase;
import dev.ratas.slimedogcore.impl.messaging.context.factory.SingleContextFactory;
import dev.ratas.slimedogcore.impl.messaging.context.factory.delegating.DelegatingDoubleContextFactory;
import dev.ratas.slimedogcore.impl.messaging.context.factory.delegating.DelegatingMultipleToOneContextFactory;
import dev.ratas.slimedogcore.impl.messaging.context.factory.delegating.DelegatingQuadrupleContextFactory;
import dev.ratas.slimedogcore.impl.messaging.context.factory.delegating.DelegatingTripleContextFactory;
import dev.ratas.slimedogcore.impl.messaging.factory.DoubleContextMessageFactory;
import dev.ratas.slimedogcore.impl.messaging.factory.MsgUtil;
import dev.ratas.slimedogcore.impl.messaging.factory.QuadrupleContextMessageFactory;
import dev.ratas.slimedogcore.impl.messaging.factory.TripleContextMessageFactory;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.PeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.Settings;
import me.ford.periodicholographicdisplays.holograms.AlwaysHologram;
import me.ford.periodicholographicdisplays.holograms.FlashingHologram;
import me.ford.periodicholographicdisplays.holograms.IRLTimeHologram;
import me.ford.periodicholographicdisplays.holograms.MCTimeHologram;
import me.ford.periodicholographicdisplays.holograms.NTimesHologram;
import me.ford.periodicholographicdisplays.holograms.PeriodicHologramBase;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.storage.HologramInfo;
import me.ford.periodicholographicdisplays.holograms.storage.Storage;
import me.ford.periodicholographicdisplays.util.PageUtils;
import me.ford.periodicholographicdisplays.util.TimeUtils;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;

public class Messages
extends MessagesBase {
    private static final String FILE_NAME = "messages.yml";
    private final IPeriodicHolographicDisplays phd;
    private SDCSingleContextMessageFactory<Player> addedToCache;
    private SDCSingleContextMessageFactory<String> optionNotSet;
    private SDCSingleContextMessageFactory<String> negativeTimes;
    private SDCSingleContextMessageFactory<String> needTypeOrPage;
    private SDCSingleContextMessageFactory<String> flashTimeTooSmall;
    private SDCSingleContextMessageFactory<String> flashMustHaveBoth;
    private SDCSingleContextMessageFactory<Boolean> storageType;
    private SDCVoidContextMessageFactory incorrectMessages;
    private SDCVoidContextMessageFactory disabling;
    private SDCSingleContextMessageFactory<String> nextpageHint;
    private SDCSingleContextMessageFactory<Integer> invalidPage;
    private SDCDoubleContextMessageFactory<String, Collection<PeriodicType>> availableTypes;
    private SDCVoidContextMessageFactory configRecreated;
    private SDCVoidContextMessageFactory messagesRecreated;
    private SDCVoidContextMessageFactory pluginFolderRecreated;
    private SDCVoidContextMessageFactory problemRecreatingPluginFolder;
    private SDCVoidContextMessageFactory noPluginFolder;
    private SDCVoidContextMessageFactory noLuckPerms;
    private SDCVoidContextMessageFactory legacy;
    private SDCSingleContextMessageFactory<String> illegalStorage;
    private SDCSingleContextMessageFactory<String> secondsTooSmall;
    private SDCSingleContextMessageFactory<String> distanceTooSmall;
    private SDCVoidContextMessageFactory nothingToUnset;
    private SDCDoubleContextMessageFactory<String, PeriodicType> cannotUnSetRequired;
    private SDCSingleContextMessageFactory<String> storageTypeDoesNotExist;
    private SDCDoubleContextMessageFactory<String, Boolean> alreadyHasData;
    private SDCDoubleContextMessageFactory<String, String> startedConverting;
    private SDCDoubleContextMessageFactory<String, String> doneConverting;
    private SDCDoubleContextMessageFactory<String, String> unrecognizedConversion;
    private SDCSingleContextMessageFactory<String> cannotConvertSame;
    private SDCDoubleContextMessageFactory<String, PeriodicType> hologramNotTracked;
    private SDCDoubleContextMessageFactory<String, PeriodicType> hologramAlreadyManaged;
    private SDCTripleContextMessageFactory<String, PeriodicType, Map<String, String>> startedManaging;
    private SDCSingleContextMessageFactory<String> hdHologramNotFound;
    private SDCSingleContextMessageFactory<String> hologramNotManaged;
    private SDCDoubleContextMessageFactory<String, PeriodicType> hologramNotFound;
    private SDCSingleContextMessageFactory<String> typeNotRecognized;
    private SDCSingleContextMessageFactory<String> needAnInteger;
    private SDCSingleContextMessageFactory<String> needANumber;
    private SDCSingleContextMessageFactory<String> illegalTime;
    private SDCDoubleContextMessageFactory<String, PeriodicType> unmanagedHologram;
    private SDCDoubleContextMessageFactory<PeriodicType, String> noSuchOption;
    private SDCVoidContextMessageFactory needPairedOptions;
    private SDCDoubleContextMessageFactory<PeriodicType, String> optionMissing;
    private SDCSingleContextMessageFactory<String> incorrectTime;
    private SDCVoidContextMessageFactory needCountAfterPlayercount;
    private SDCSingleContextMessageFactory<String> playerNotFound;
    private SDCVoidContextMessageFactory unsetFlash;
    private SDCSingleContextMessageFactory<OfflinePlayer> unsetPlayerCount;
    private SDCSingleContextMessageFactory<List<String>> unsetOptions;
    private SDCDoubleContextMessageFactory<Settings.SettingIssue, String> problemWithConfig;
    private SDCVoidContextMessageFactory configReloaded;
    private SDCVoidContextMessageFactory sqlConnection;
    private SDCSingleContextMessageFactory<List<PeriodicHolographicDisplays.ReloadIssue>> reloadIssues;
    private SDCTripleContextMessageFactory<String, PeriodicType, Map<String, String>> setNewOptions;
    private SDCSingleContextMessageFactory<Long> lowFrequency;
    private static String timesString = "%s %d/%d";

    public Messages(IPeriodicHolographicDisplays phd) throws InvalidConfigurationException {
        super(phd.getCustomConfigManager().getConfig(FILE_NAME));
        this.getConfig().saveDefaultConfig();
        this.phd = phd;
        this.loadMessages();
    }

    Messages(IPeriodicHolographicDisplays phd, String name) throws InvalidConfigurationException {
        super(phd.getCustomConfigManager().getConfig(name));
        this.phd = phd;
        this.loadMessages();
    }

    private void loadMessages() {
        this.addedToCache = MsgUtil.twoToOneContextDelegator("{name}", player -> player.getName(), "{uuid}", player -> player.getUniqueId().toString(), this.getRawMessage("added-to-cache", "Adding player {name} UUID {uuid} to cache"));
        this.optionNotSet = MsgUtil.singleContext("{option}", option -> option, this.getRawMessage("option-not-set", "No change, {option} was not set"));
        this.negativeTimes = MsgUtil.singleContext("{times}", cur -> cur, this.getRawMessage("times-too-small", "Minimum times value is 1, got {times}"));
        this.needTypeOrPage = MsgUtil.singleContext("{msg}", cur -> cur, this.getRawMessage("need-to-specify-type-or-page", "Need to specify either a hologram type or a page number, got {msg}"));
        this.flashTimeTooSmall = MsgUtil.singleContext("{time}", time -> time, this.getRawMessage("flash-time-too-small", "Minimum flash time is 1.0, got {time}"));
        this.flashMustHaveBoth = MsgUtil.singleContext("#unused#", specified -> specified, this.getRawMessage("flash-must-have-both", "Need to specify both 'flashOn' and 'flashOff'; alternatively use 'flash' to set both at once"));
        this.storageType = MsgUtil.singleContext("{storage}", useDatabase -> useDatabase != false ? "SQLITE" : "YAML", this.getRawMessage("active-storage", "Active storage-type is {storage}"));
        this.incorrectMessages = MsgUtil.voidContext(this.getRawMessage("incorrect-messages", "Messages.yml is incorrectly formatted"));
        this.disabling = MsgUtil.voidContext(this.getRawMessage("disabling-plugin", "Disabling plugin!"));
        this.nextpageHint = MsgUtil.singleContext("{command}", cmd -> cmd, this.getRawMessage("next-page-hint", "TIP: See the next page with &n{command}&r"));
        this.invalidPage = MsgUtil.singleContext("{max-page}", maxPage -> String.valueOf(maxPage), this.getRawMessage("invalid-page", "Page needs to be between 1 and {max-page}"));
        this.availableTypes = MsgUtil.doubleContext("{hologram}", name -> name, "{types}", availableTypes -> {
            ArrayList<String> types = new ArrayList<String>();
            for (PeriodicType type : availableTypes) {
                types.add(type.name());
            }
            return String.join((CharSequence)", ", types);
        }, this.getRawMessage("available-types", "Types available for {hologram}: {types}"));
        this.configRecreated = MsgUtil.voidContext(this.getRawMessage("config-recreated", "The config.yml file did not exist and was recreated"));
        this.messagesRecreated = MsgUtil.voidContext(this.getRawMessage("messages-recreated", "The messages.yml file did not exist and was recreated"));
        this.pluginFolderRecreated = MsgUtil.voidContext(this.getRawMessage("plugin-folder-recreated", "Plugin folder was recreated"));
        this.problemRecreatingPluginFolder = MsgUtil.voidContext(this.getRawMessage("problem-recreated-plugin-folder", "Problem recreating plugin folder"));
        this.noPluginFolder = MsgUtil.voidContext(this.getRawMessage("plugin-folder-removed", "Plugin folder does not exist or is unreadable at reload; attempting to recreate"));
        this.noLuckPerms = MsgUtil.voidContext(this.getRawMessage("no-luckperms", "LuckPerms not found - unable to readjust permissions on the fly or tab-complete permissions"));
        this.legacy = MsgUtil.voidContext(this.getRawMessage("legacy-version-mctime", "MCTIME holograms can behave unpredictably because of the use of a legacy version of MC"));
        this.illegalStorage = MsgUtil.singleContext("{type}", type -> type, this.getRawMessage("illegal-storage-type", "Illegal storage type {type} - only YAML and SQLITE are supported"));
        this.secondsTooSmall = MsgUtil.singleContext("{seconds}", seconds -> seconds, this.getRawMessage("seconds-too-small", "Minimum seconds value is 1, got {seconds}"));
        this.distanceTooSmall = MsgUtil.singleContext("{distance}", dist -> dist, this.getRawMessage("distance-too-small", "Minimum distance value is 1.0, got {distance}"));
        this.nothingToUnset = MsgUtil.voidContext(this.getRawMessage("nothing-to-unset", "Did not find a suitable option, nothing was unset"));
        this.cannotUnSetRequired = MsgUtil.doubleContext("{option}", option -> option, "{type}", type -> type.name(), this.getRawMessage("cannot-unset-required-option", "Cannot unset required option {option} for type {type}; use /phd unmanage instead"));
        this.storageTypeDoesNotExist = MsgUtil.singleContext("{tyoe}", type -> type, this.getRawMessage("source-storage-does-not-exist", "{type} source storage type does not exist; no data will be converted"));
        this.alreadyHasData = MsgUtil.doubleContext("{type}", type -> type, "{file}", isDatabase -> "database." + (isDatabase != false ? "db" : "yml"), this.getRawMessage("target-storage-has-data", "The target storage type {type} already has data\nMove or remove the file ({file}) before proceeding"));
        this.startedConverting = MsgUtil.doubleContext("{from}", from -> from, "{to}", to -> to, this.getRawMessage("started-converting", "Started converting from {from} to {to}"));
        this.doneConverting = MsgUtil.doubleContext("{from}", from -> from, "{to}", to -> to, this.getRawMessage("done-converting", "Done converting from {from} to {to}"));
        this.unrecognizedConversion = MsgUtil.doubleContext("{from}", from -> from, "{to}", to -> to, this.getRawMessage("unrecognized-conversion", "Cannot convert from {from} to {to} - unrecognized storage types"));
        this.cannotConvertSame = MsgUtil.singleContext("{type}", type -> type, this.getRawMessage("cannot-convert-from-same", "Cannot convert from the same storage type ({type})"));
        this.hologramNotTracked = MsgUtil.doubleContext("{name}", name -> name, "{type}", type -> type.name(), this.getRawMessage("hologram-not-managed", "Hologram {name} of type {type} is not managed by pHD"));
        this.hologramAlreadyManaged = MsgUtil.doubleContext("{name}", name -> name, "{type}", type -> type.name(), this.getRawMessage("hologram-already-managed", "Hologram {name} of type {type} is already managed by pHD"));
        this.startedManaging = MsgUtil.tripleContext("{name}", name -> name, "{type}", type -> type.name(), "{options}", options -> {
            ArrayList<String> opts = new ArrayList<String>();
            for (Map.Entry entry : options.entrySet()) {
                opts.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
            }
            return String.join((CharSequence)", ", opts);
        }, this.getRawMessage("started-managing-hologram", "Started managing hologram {name} of type {type}: {options}"));
        this.hdHologramNotFound = MsgUtil.singleContext("{name}", name -> name, this.getRawMessage("hd-hologram-not-found", "HolographicDisplays hologram {name} was not found"));
        this.hologramNotManaged = MsgUtil.singleContext("{name}", name -> name, this.getRawMessage("hologram-not-tracked", "Hologram not managed: {name}"));
        this.hologramNotManaged = MsgUtil.singleContext("{name}", name -> name, this.getRawMessage("hologram-not-tracked", "Hologram not managed: {name}"));
        this.hologramNotManaged = MsgUtil.singleContext("{name}", name -> name, this.getRawMessage("hologram-not-tracked", "Hologram not managed: {name}"));
        this.hologramNotManaged = MsgUtil.singleContext("{name}", name -> name, this.getRawMessage("hologram-not-tracked", "Hologram not managed: {name}"));
        this.hologramNotFound = MsgUtil.doubleContext("{name}", name -> name, "{type}", type -> type.name(), this.getRawMessage("hologram-not-found", "Hologram not found: {name} of type {type}"));
        this.typeNotRecognized = MsgUtil.singleContext("{type}", type -> type, this.getRawMessage("type-not-recognized", "Hologram type {type} is not recognized"));
        this.needAnInteger = MsgUtil.singleContext("{msg}", msg -> msg, this.getRawMessage("need-an-integer", "Value must be an integer, got {msg}"));
        this.needANumber = MsgUtil.singleContext("{msg}", msg -> msg, this.getRawMessage("need-a-number", "Value must be a number, got {msg}"));
        this.illegalTime = MsgUtil.singleContext("{msg}", msg -> msg, this.getRawMessage("illega-time", "Time must be specified as e.g '1d' or '10h30m'. Available units: y, mo, d, h, m, s. Got {msg} instead"));
        this.unmanagedHologram = MsgUtil.doubleContext("{name}", name -> name, "{type}", type -> type.name(), this.getRawMessage("unmanaged-hologram", "Unmanaged hologram {name} of type {type}"));
        this.noSuchOption = MsgUtil.doubleContext("{type}", type -> type.name(), "{option}", option -> option, this.getRawMessage("no-such-option", "{type} holograms have no {option} option"));
        this.needPairedOptions = MsgUtil.voidContext(this.getRawMessage("incorrect-set-options", "Need a set of key-value pairs to set, got an odd number of arguments"));
        this.optionMissing = MsgUtil.doubleContext("{type}", type -> type.name(), "{option}", option -> option, this.getRawMessage("option-missing", "Need to set {option} for a {type} hologram"));
        this.incorrectTime = MsgUtil.singleContext("{time}", time -> time, this.getRawMessage("incorrect-time", "Time format is hh:mm (24-hour), got {time}"));
        this.needCountAfterPlayercount = MsgUtil.voidContext(this.getRawMessage("need-player-after-playercount", "Need to specify a player after 'playercount'"));
        this.playerNotFound = MsgUtil.singleContext("{player}", name -> name, this.getRawMessage("player-not-found", "Player not found: {player}"));
        this.unsetFlash = MsgUtil.voidContext(this.getRawMessage("unset-flash", "Unset flash"));
        this.unsetPlayerCount = MsgUtil.singleContext("{player}", player -> player.getName(), this.getRawMessage("unset-playercount", "Unset playercount of {player}; now 0"));
        this.unsetOptions = MsgUtil.singleContext("{options}", options -> String.join((CharSequence)", ", options), this.getRawMessage("unset-options", "Unset {options}; now using default"));
        DelegatingDoubleContextFactory problemWithConfigContextFactory = new DelegatingDoubleContextFactory(new DelegatingMultipleToOneContextFactory(new SingleContextFactory<Settings.SettingIssue>("{key}", issue -> issue.getPath()), new SingleContextFactory<Settings.SettingIssue>("{type}", issue -> issue.getType().getName())), new SingleContextFactory<String>("{value}", value -> value));
        this.problemWithConfig = new DoubleContextMessageFactory(problemWithConfigContextFactory, this.getRawMessage("problem-in-config", "Problem in config for {key}; expected {type}, got {value}"), MessageTarget.TEXT);
        this.configReloaded = MsgUtil.voidContext(this.getRawMessage("config-reloaded", "Successfully reloaded configuration, messages, and data"));
        this.sqlConnection = MsgUtil.voidContext(this.getRawMessage("sqlite-connection-established", "Connection to SQLite has been established"));
        this.reloadIssues = MsgUtil.singleContext("{problems}", issues -> {
            StringBuilder problems = new StringBuilder();
            for (PeriodicHolographicDisplays.ReloadIssue issue : issues) {
                String desc = null;
                problems.append("\n");
                if (issue instanceof PeriodicHolographicDisplays.DefaultReloadIssue) {
                    PeriodicHolographicDisplays.DefaultReloadIssue dri = (PeriodicHolographicDisplays.DefaultReloadIssue)issue;
                    switch (dri) {
                        case NO_FOLDER: {
                            desc = this.getNoPluginFolderMessage().getMessage().getFilled();
                            problems.append(desc);
                            problems.append("\n");
                            desc = Boolean.valueOf(dri.getExtra()) != false ? this.getPluginFolderRecreatedMessage().getMessage().getFilled() : this.getProblemRecreatingPluginFolder().getMessage().getFilled();
                            break;
                        }
                        case ILLEGA_STORAGE_TYPE: {
                            desc = this.getIllegalStorageMessage().createWith(dri.getExtra()).getFilled();
                            break;
                        }
                        case NO_CONFIG: {
                            desc = this.getConfigRecreatedMessage().getMessage().getFilled();
                            break;
                        }
                        case NO_MESSAGES: {
                            desc = this.getMessagesRecreatedMessage().getMessage().getFilled();
                            break;
                        }
                    }
                }
                if (desc == null) {
                    desc = issue.getExtra() == null ? issue.getIssue() : String.format("%s: %s", issue.getIssue(), issue.getExtra());
                }
                problems.append(desc);
            }
            return problems.toString();
        }, this.getRawMessage("problems-reloading-config", "Problems reloading config: {problems}"));
        this.setNewOptions = MsgUtil.tripleContext("{name}", name -> name, "{type}", type -> type.name(), "{options}", options -> {
            ArrayList<String> opts = new ArrayList<String>();
            for (Map.Entry entry : options.entrySet()) {
                opts.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
            }
            return String.join((CharSequence)", ", opts);
        }, this.getRawMessage("set-new-values", "Set new values for hologram {name} of type {type}: {options}"));
        this.lowFrequency = MsgUtil.singleContext("{value}", seconds -> String.valueOf(seconds), this.getRawMessage("save-frequency-low", "Configuration save-frequency set to {value} seconds may result in decreased performance"));
    }

    public SDCSingleContextMessageFactory<Player> getAddedToCacheMessage() {
        return this.addedToCache;
    }

    public SDCSingleContextMessageFactory<String> getOptionNotSetMessage() {
        return this.optionNotSet;
    }

    public SDCSingleContextMessageFactory<String> getNegativeTimesMessage() {
        return this.negativeTimes;
    }

    public SDCSingleContextMessageFactory<String> getNeedTypeOrPageMessage() {
        return this.needTypeOrPage;
    }

    public SDCSingleContextMessageFactory<String> getFlashTimeTooSmallMessage() {
        return this.flashTimeTooSmall;
    }

    public SDCSingleContextMessageFactory<String> getFlashMustHaveBothMessage() {
        return this.flashMustHaveBoth;
    }

    public SDCSingleContextMessageFactory<Boolean> getActiveStorageMessage() {
        return this.storageType;
    }

    public SDCVoidContextMessageFactory getIncorrectMessages() {
        return this.incorrectMessages;
    }

    public SDCVoidContextMessageFactory getDisablingMessage() {
        return this.disabling;
    }

    public SDCSingleContextMessageFactory<String> getNextPageHint() {
        return this.nextpageHint;
    }

    public SDCSingleContextMessageFactory<Integer> getInvalidPageMessage() {
        return this.invalidPage;
    }

    public SDCDoubleContextMessageFactory<String, Collection<PeriodicType>> getAvailableTypesMessage() {
        return this.availableTypes;
    }

    public SDCVoidContextMessageFactory getConfigRecreatedMessage() {
        return this.configRecreated;
    }

    public SDCVoidContextMessageFactory getMessagesRecreatedMessage() {
        return this.messagesRecreated;
    }

    public SDCVoidContextMessageFactory getPluginFolderRecreatedMessage() {
        return this.pluginFolderRecreated;
    }

    public SDCVoidContextMessageFactory getProblemRecreatingPluginFolder() {
        return this.problemRecreatingPluginFolder;
    }

    public SDCVoidContextMessageFactory getNoPluginFolderMessage() {
        return this.noPluginFolder;
    }

    public SDCVoidContextMessageFactory getNoLPMessage() {
        return this.noLuckPerms;
    }

    public SDCVoidContextMessageFactory getLegacyMessage() {
        return this.legacy;
    }

    public SDCSingleContextMessageFactory<String> getIllegalStorageMessage() {
        return this.illegalStorage;
    }

    public SDCSingleContextMessageFactory<String> getSecondsTooSmallMessage() {
        return this.secondsTooSmall;
    }

    public SDCSingleContextMessageFactory<String> getDistanceTooSmallMessage() {
        return this.distanceTooSmall;
    }

    public SDCVoidContextMessageFactory getNothingToUnsetMessage() {
        return this.nothingToUnset;
    }

    public SDCDoubleContextMessageFactory<String, PeriodicType> getCannotUnSetRequiredMessage() {
        return this.cannotUnSetRequired;
    }

    public SDCSingleContextMessageFactory<String> getStorageTypeDoesNotExistMessage() {
        return this.storageTypeDoesNotExist;
    }

    public SDCDoubleContextMessageFactory<String, Boolean> getAlreadyHasDataMessage() {
        return this.alreadyHasData;
    }

    public SDCDoubleContextMessageFactory<String, String> getStartedConvertingMessage() {
        return this.startedConverting;
    }

    public SDCDoubleContextMessageFactory<String, String> getDoneConvertingMessage() {
        return this.doneConverting;
    }

    public SDCDoubleContextMessageFactory<String, String> getUnrecognizedStorageTypeMessage() {
        return this.unrecognizedConversion;
    }

    public SDCSingleContextMessageFactory<String> getCannotConvertSameMessage() {
        return this.cannotConvertSame;
    }

    public SDCDoubleContextMessageFactory<String, PeriodicType> getHologramNotTrackedMessage() {
        return this.hologramNotTracked;
    }

    public SDCDoubleContextMessageFactory<String, PeriodicType> getHologramAlreadyManagedMessage() {
        return this.hologramAlreadyManaged;
    }

    public SDCTripleContextMessageFactory<String, PeriodicType, Map<String, String>> getStartedManagingMessage() {
        return this.startedManaging;
    }

    public SDCSingleContextMessageFactory<String> getHDHologramNotFoundMessage() {
        return this.hdHologramNotFound;
    }

    public SDCSingleContextMessageFactory<String> getHologramNotManagedMessage() {
        return this.hologramNotManaged;
    }

    public SDCDoubleContextMessageFactory<String, PeriodicType> getHologramNotFoundMessage() {
        return this.hologramNotFound;
    }

    public SDCSingleContextMessageFactory<String> getTypeNotRecognizedMessage() {
        return this.typeNotRecognized;
    }

    public SDCSingleContextMessageFactory<String> getNeedAnIntegerMessage() {
        return this.needAnInteger;
    }

    public SDCSingleContextMessageFactory<String> getNeedANumberMessage() {
        return this.needANumber;
    }

    public SDCSingleContextMessageFactory<String> getIllegalTimeMessage() {
        return this.illegalTime;
    }

    public SDCMessage<SDCTripleContext<Set<Storage.HDHologramInfo>, Integer, Boolean>> getZombieListMessage(Set<Storage.HDHologramInfo> holograms, int page, boolean doPages) {
        ZombiesHelper tuple = new ZombiesHelper(holograms, page, doPages);
        SingleContextFactory<Set> delegate01 = new SingleContextFactory<Set>("{max-pages}", fake -> tuple.maxPageRepl);
        SingleContextFactory<Set> delegate02 = new SingleContextFactory<Set>("{holograms}", fake -> tuple.hologramsRepl);
        SingleContextFactory<Set> delegate03 = new SingleContextFactory<Set>("{page}", fake -> tuple.pageRepl);
        DelegatingMultipleToOneContextFactory delegate1 = new DelegatingMultipleToOneContextFactory(delegate01, delegate02, delegate03);
        SingleContextFactory<Integer> delegate2 = new SingleContextFactory<Integer>("{numbers}", fake -> tuple.numbersRepl);
        SingleContextFactory<Boolean> delegate3 = new SingleContextFactory<Boolean>(", page 1/1", fake -> tuple.page1Repl);
        DelegatingTripleContextFactory contextFactory = new DelegatingTripleContextFactory(delegate1, delegate2, delegate3);
        return new TripleContextMessageFactory(contextFactory, this.getRawMessage("hologram-list", "Holograms (holograms {numbers}, page {page}/{max-pages}): \n{holograms}"), MessageTarget.TEXT).createWith(holograms, page, doPages);
    }

    public SDCMessage<SDCTripleContext<Map<String, String>, Integer, Boolean>> getHologramListMessage(Map<String, String> holograms, int page, boolean doPages) {
        HologramsHelper tuple = new HologramsHelper(holograms, page, doPages);
        SingleContextFactory<Map> delegate01 = new SingleContextFactory<Map>("{max-pages}", fake -> tuple.maxPageRepl);
        SingleContextFactory<Map> delegate02 = new SingleContextFactory<Map>("{holograms}", fake -> tuple.hologramsRepl);
        SingleContextFactory<Map> delegate03 = new SingleContextFactory<Map>("{page}", fake -> tuple.pageRepl);
        DelegatingMultipleToOneContextFactory delegate1 = new DelegatingMultipleToOneContextFactory(delegate01, delegate02, delegate03);
        SingleContextFactory<Integer> delegate2 = new SingleContextFactory<Integer>("{numbers}", fake -> tuple.numbersRepl);
        SingleContextFactory<Boolean> delegate3 = new SingleContextFactory<Boolean>(", page 1/1", fake -> tuple.page1Repl);
        DelegatingTripleContextFactory contextFactory = new DelegatingTripleContextFactory(delegate1, delegate2, delegate3);
        return new TripleContextMessageFactory(contextFactory, this.getRawMessage("hologram-list", "Holograms (holograms {numbers}, page {page}/{max-pages}): \n{holograms}"), MessageTarget.TEXT).createWith(holograms, page, doPages);
    }

    public SDCDoubleContextMessageFactory<String, PeriodicType> getUnmanagedHologramMessage() {
        return this.unmanagedHologram;
    }

    public SDCDoubleContextMessageFactory<PeriodicType, String> getNoSuchOptionMessage() {
        return this.noSuchOption;
    }

    public SDCVoidContextMessageFactory getNeedPairedOptionsMessage() {
        return this.needPairedOptions;
    }

    public SDCDoubleContextMessageFactory<PeriodicType, String> getOptionMissingMessage() {
        return this.optionMissing;
    }

    public SDCSingleContextMessageFactory<String> getIncorrectTimeMessage() {
        return this.incorrectTime;
    }

    public SDCVoidContextMessageFactory getNeedCountAfterPlayercount() {
        return this.needCountAfterPlayercount;
    }

    public SDCSingleContextMessageFactory<String> getPlayerNotFoundMessage() {
        return this.playerNotFound;
    }

    public SDCVoidContextMessageFactory getUnsetFlashMessage() {
        return this.unsetFlash;
    }

    public SDCSingleContextMessageFactory<OfflinePlayer> getUnsetPlayerCountMessage() {
        return this.unsetPlayerCount;
    }

    public SDCSingleContextMessageFactory<List<String>> getUnsetOptionsMessage() {
        return this.unsetOptions;
    }

    public SDCDoubleContextMessageFactory<Settings.SettingIssue, String> getProblemWithConfigMessage() {
        return this.problemWithConfig;
    }

    public SDCVoidContextMessageFactory getConfigReloadedMessage() {
        return this.configReloaded;
    }

    public SDCVoidContextMessageFactory getSqlConnectionMessage() {
        return this.sqlConnection;
    }

    public SDCSingleContextMessageFactory<List<PeriodicHolographicDisplays.ReloadIssue>> getProblemsReloadingConfigMessage() {
        return this.reloadIssues;
    }

    public SDCTripleContextMessageFactory<String, PeriodicType, Map<String, String>> getSetNewOptionsMessage() {
        return this.setNewOptions;
    }

    public SDCMessage<SDCQuadrupleContext<OfflinePlayer, List<NTimesHologram>, Integer, Boolean>> getNtimesReportMessage(OfflinePlayer player, List<NTimesHologram> holograms, int page, boolean doPages) {
        NTimesReportHelper helper = new NTimesReportHelper(player, holograms, page, doPages);
        SingleContextFactory<OfflinePlayer> delegate1 = new SingleContextFactory<OfflinePlayer>("{player}", fake -> helper.playerRepl);
        SingleContextFactory<List> delegate2 = new SingleContextFactory<List>("{holograms}", fake -> helper.hologramsRepl);
        DelegatingMultipleToOneContextFactory delegate3 = new DelegatingMultipleToOneContextFactory(new SingleContextFactory<Integer>("{page}", fake -> helper.pageRepl), new SingleContextFactory<Integer>("{max-pages}", fake -> helper.maxPageRepl), new SingleContextFactory<Integer>(", page 1/1", fake -> helper.page1Repl));
        SingleContextFactory<Boolean> delegate4 = new SingleContextFactory<Boolean>("{times}", fake -> helper.timesRepl);
        DelegatingQuadrupleContextFactory contextFactory = new DelegatingQuadrupleContextFactory(delegate1, delegate2, delegate3, delegate4);
        QuadrupleContextMessageFactory factory = new QuadrupleContextMessageFactory(contextFactory, this.getRawMessage("ntimes-report", "{player} has seen the following NTIMES holograms (holograms {holograms}, page {page}/{max-pages}):\n{times}"), MessageTarget.TEXT);
        return factory.createWith(player, holograms, page, doPages);
    }

    public SDCMessage<SDCTripleContext<FlashingHologram, Integer, Boolean>> getHologramInfoMessage(FlashingHologram hologram, int page, boolean doPages) {
        HologramInfoHelper helper = new HologramInfoHelper(hologram, page, doPages);
        DelegatingMultipleToOneContextFactory delegate1 = new DelegatingMultipleToOneContextFactory(new SingleContextFactory<FlashingHologram>("{name}", fake -> helper.nameRepl), new SingleContextFactory<FlashingHologram>("{world}", fake -> helper.worldRepl), new SingleContextFactory<FlashingHologram>("{type}", fake -> helper.typeRepl), new SingleContextFactory<FlashingHologram>("{typeinfo}", fake -> helper.typeInfoRepl), new SingleContextFactory<FlashingHologram>("{time}", fake -> helper.timeRepl), new SingleContextFactory<FlashingHologram>("{location}", fake -> helper.locationRepl), new SingleContextFactory<FlashingHologram>("{perms}", fake -> helper.permsRepl));
        SingleContextFactory<Integer> delegate2 = new SingleContextFactory<Integer>("{distance}", fake -> helper.distanceRepl);
        SingleContextFactory<Boolean> delegate3 = new SingleContextFactory<Boolean>("{flash}", fake -> helper.flashRepl);
        DelegatingTripleContextFactory contextFactory = new DelegatingTripleContextFactory(delegate1, delegate2, delegate3);
        return new TripleContextMessageFactory(contextFactory, this.getRawMessage("hologram-info", "Hologram {name}:\nWorld: {world}\nLocation: {location}\nType: {type}\nShowTime: {time}\nFlash: {flash}\nActivationDistance: {distance}\nPermission: {perms}\nTypeInfo: {typeinfo}"), MessageTarget.TEXT).createWith(hologram, page, doPages);
    }

    private String getShowTimeString(PeriodicHologramBase hologram) {
        boolean isSpecialAlways;
        long showTime = hologram.getShowTime();
        boolean bl = isSpecialAlways = hologram.getType() == PeriodicType.ALWAYS;
        if (isSpecialAlways) {
            AlwaysHologram always = (AlwaysHologram)hologram;
            boolean bl2 = isSpecialAlways = always.isShownOnWorldJoin() || always.isShownWhileInArea();
        }
        Object time = isSpecialAlways ? "Always" : (showTime == -1L ? String.valueOf(this.phd.getSettings().getDefaultShowTime()) + " (default)" : String.valueOf(showTime));
        return time;
    }

    private String getDistanceString(PeriodicHologramBase hologram) {
        boolean isSpecialAlways;
        double dist = hologram.getActivationDistance();
        boolean bl = isSpecialAlways = hologram.getType() == PeriodicType.ALWAYS;
        if (isSpecialAlways) {
            AlwaysHologram always = (AlwaysHologram)hologram;
            isSpecialAlways = always.isShownOnWorldJoin();
        }
        String distance = isSpecialAlways ? "InWorld" : (dist == -1.0 ? String.format("%3.2f (default)", this.phd.getSettings().getDefaultActivationDistance()) : String.format("%3.2f", dist));
        return distance;
    }

    public String getTypeInfo(PeriodicHologramBase hologram, int page, boolean doPages) {
        String typeinfo;
        switch (hologram.getType()) {
            case MCTIME: {
                typeinfo = this.getMCTimeTypeInfo((MCTimeHologram)hologram);
                break;
            }
            case IRLTIME: {
                typeinfo = this.getIRLTimeTypeInfo((IRLTimeHologram)hologram);
                break;
            }
            case NTIMES: {
                NTimesHologram nth = (NTimesHologram)hologram;
                typeinfo = this.getNTimesTypeInfo(nth, nth.getTimesToShow() < 0, page, doPages);
                break;
            }
            case ALWAYS: {
                typeinfo = this.getNTimesTypeInfo((NTimesHologram)hologram, true, page, doPages);
                break;
            }
            default: {
                typeinfo = "N/A";
                this.phd.getLogger().warning("Unable to get info for hologram of type " + hologram.getType() + " - " + hologram);
            }
        }
        return typeinfo;
    }

    private String getIRLTimeTypeInfo(IRLTimeHologram hologram) {
        return this.getRawMessage("typeinfo.IRLTIME", "Shown at: {time}").replace("{time}", TimeUtils.toIRLTime(hologram.getTime()));
    }

    private String getMCTimeTypeInfo(MCTimeHologram hologram) {
        return this.getRawMessage("typeinfo.MCTIME", "Shown at: {time}").replace("{time}", TimeUtils.toMCTime(hologram.getTime()));
    }

    public String getNTimesTypeInfo(NTimesHologram hologram, boolean always, int page, boolean doPages) {
        String msg = this.getRawMessage(always ? "typeinfo.ALWAYS" : "typeinfo.NTIMES", always ? "Always shown" : "Show times: {times}; Shown to (players {players}, page {page}/{max-pages}): {players:times}");
        if (!always) {
            msg = msg.replace("{times}", String.valueOf(hologram.getTimesToShow()));
            int nrOfPlayers = hologram.getShownTo().size();
            PageUtils.PageInfo pageInfo = PageUtils.getPageInfo(nrOfPlayers, 8, page, doPages);
            int startNr = pageInfo.getStartNumber();
            int endNr = pageInfo.getEndNumber();
            String numbers = endNr <= startNr && startNr == 1 ? String.valueOf(endNr) : String.format("%d-%d", startNr, endNr);
            msg = msg.replace("{players}", numbers);
            msg = msg.replace("{page}", String.valueOf(page)).replace("{max-pages}", String.valueOf(pageInfo.getNumberOfPages()));
            ArrayList<CallSite> playersAndTimes = new ArrayList<CallSite>();
            int i = 1;
            for (Map.Entry<UUID, Integer> entry : hologram.getShownTo().entrySet()) {
                if (i < pageInfo.getStartNumber() || i > pageInfo.getEndNumber()) {
                    ++i;
                    continue;
                }
                OfflinePlayer player = this.phd.getOfflinePlayer(entry.getKey());
                String playerName = player == null || !player.hasPlayedBefore() && !player.isOnline() ? "UNKNOWNPLAYER" : player.getName();
                playersAndTimes.add((CallSite)((Object)(playerName + ": " + entry.getValue())));
                ++i;
            }
            msg = playersAndTimes.isEmpty() ? msg.replace("{players:times}", "none") : msg.replace("{players:times}", "\n" + String.join((CharSequence)"\n", playersAndTimes));
        }
        if (!doPages) {
            msg = msg.replace(", page 1/1", "");
        }
        return msg;
    }

    public SDCSingleContextMessageFactory<Long> getLowSaveDelayMessage() {
        return this.lowFrequency;
    }

    @Override
    public void reloadConfig() {
        super.reloadConfig();
        this.loadMessages();
    }

    public File getFile() {
        return this.getConfig().getFile();
    }

    public void saveDefaultConfig() {
        this.getConfig().saveDefaultConfig();
    }

    private static final class ZombiesHelper {
        private final Set<Storage.HDHologramInfo> holograms;
        private final int page;
        private final boolean doPages;
        private String hologramsRepl;
        private String numbersRepl;
        private String pageRepl;
        private String maxPageRepl;
        private String page1Repl;

        private ZombiesHelper(Set<Storage.HDHologramInfo> holograms, int page, boolean doPages) {
            this.holograms = holograms;
            this.page = page;
            this.doPages = doPages;
            this.calculate();
        }

        private void calculate() {
            PageUtils.PageInfo pageInfo = PageUtils.getPageInfo(this.holograms.size(), 8, this.page, this.doPages);
            int i = 0;
            int startNr = pageInfo.getStartNumber();
            int endNr = pageInfo.getEndNumber();
            ArrayList<String> lines = new ArrayList<String>();
            for (Storage.HDHologramInfo zombie : this.holograms) {
                if (++i < startNr || i > endNr) continue;
                ArrayList<String> types = new ArrayList<String>();
                for (HologramInfo info : zombie.getInfos()) {
                    types.add(info.getType().name());
                }
                lines.add(String.format("%s %s", zombie.getHoloName(), String.join((CharSequence)", ", types)));
            }
            String numbers = endNr <= startNr && startNr == 1 ? String.valueOf(endNr) : String.format("%d-%d", startNr, endNr);
            this.numbersRepl = numbers;
            this.pageRepl = String.valueOf(this.page);
            this.maxPageRepl = String.valueOf(pageInfo.getNumberOfPages());
            this.page1Repl = !this.doPages ? "" : ", page 1/1";
            this.hologramsRepl = String.join((CharSequence)"\n", lines);
        }
    }

    private static final class HologramsHelper {
        private final Map<String, String> holograms;
        private final int page;
        private final boolean doPages;
        private String hologramsRepl;
        private String numbersRepl;
        private String pageRepl;
        private String maxPageRepl;
        private String page1Repl;

        private HologramsHelper(Map<String, String> holograms, int page, boolean doPages) {
            this.holograms = holograms;
            this.page = page;
            this.doPages = doPages;
            this.calculate();
        }

        private void calculate() {
            PageUtils.PageInfo pageInfo = PageUtils.getPageInfo(this.holograms.size(), 8, this.page, this.doPages);
            int i = 1;
            int startNr = pageInfo.getStartNumber();
            int endNr = pageInfo.getEndNumber();
            ArrayList<CallSite> lines = new ArrayList<CallSite>();
            for (Map.Entry<String, String> entry : this.holograms.entrySet()) {
                if (i < pageInfo.getStartNumber() || i > pageInfo.getEndNumber()) {
                    ++i;
                    continue;
                }
                lines.add((CallSite)((Object)(entry.getKey() + " " + entry.getValue())));
                ++i;
            }
            String numbers = endNr <= startNr && startNr == 1 ? String.valueOf(endNr) : String.format("%d-%d", startNr, endNr);
            this.numbersRepl = numbers;
            this.pageRepl = String.valueOf(this.page);
            this.maxPageRepl = String.valueOf(pageInfo.getNumberOfPages());
            this.page1Repl = !this.doPages ? "" : ", page 1/1";
            this.hologramsRepl = String.join((CharSequence)"\n", lines);
        }
    }

    private static final class NTimesReportHelper {
        private final OfflinePlayer player;
        private final List<NTimesHologram> holograms;
        private final int page;
        private final boolean doPages;
        private String playerRepl;
        private String hologramsRepl;
        private String pageRepl;
        private String maxPageRepl;
        private String page1Repl;
        private String timesRepl;

        public NTimesReportHelper(OfflinePlayer player, List<NTimesHologram> holograms, int page, boolean doPages) {
            this.player = player;
            this.holograms = holograms;
            this.page = page;
            this.doPages = doPages;
            this.calculate();
        }

        private void calculate() {
            this.playerRepl = this.player.getName();
            PageUtils.PageInfo pageInfo = PageUtils.getPageInfo(this.holograms.size(), 8, this.page, this.doPages);
            int startNr = pageInfo.getStartNumber();
            int endNr = pageInfo.getEndNumber();
            String numbers = endNr <= startNr && startNr == 1 ? String.valueOf(endNr) : String.format("%d-%d", startNr, endNr);
            this.hologramsRepl = numbers;
            this.pageRepl = String.valueOf(this.page);
            this.maxPageRepl = String.valueOf(pageInfo.getNumberOfPages());
            StringBuilder builder = new StringBuilder();
            int i = 0;
            for (NTimesHologram hologram : this.holograms) {
                if (++i < pageInfo.getStartNumber() || i > pageInfo.getEndNumber()) continue;
                Integer amount = hologram.getShownTo().get(this.player.getUniqueId());
                if (amount == null) {
                    amount = 0;
                }
                if (builder.length() != 0) {
                    builder.append("\n");
                }
                builder.append(String.format(timesString, hologram.getName(), amount, hologram.getTimesToShow()));
            }
            if (builder.length() == 0) {
                builder.append("None");
            }
            this.page1Repl = !this.doPages ? "" : ", page 1/1";
            this.timesRepl = builder.toString();
        }
    }

    private final class HologramInfoHelper {
        private final FlashingHologram hologram;
        private final int page;
        private final boolean doPages;
        private String nameRepl;
        private String worldRepl;
        private String typeRepl;
        private String timeRepl;
        private String typeInfoRepl;
        private String distanceRepl;
        private String flashRepl;
        private String locationRepl;
        private String permsRepl;

        private HologramInfoHelper(FlashingHologram hologram, int page, boolean doPages) {
            this.hologram = hologram;
            this.page = page;
            this.doPages = doPages;
            this.calculate();
        }

        public void calculate() {
            this.nameRepl = this.hologram.getName();
            this.worldRepl = this.hologram.getLocation().getWorld().getName();
            this.typeRepl = this.hologram.getType() == PeriodicType.NTIMES && ((NTimesHologram)this.hologram).getTimesToShow() < 0 ? PeriodicType.ALWAYS.name() : this.hologram.getType().name();
            this.timeRepl = Messages.this.getShowTimeString(this.hologram);
            this.typeInfoRepl = Messages.this.getTypeInfo(this.hologram, this.page, this.doPages);
            this.distanceRepl = Messages.this.getDistanceString(this.hologram);
            this.flashRepl = this.hologram.flashes() ? String.format("%3.2f/%3.2f", this.hologram.getFlashOn(), this.hologram.getFlashOff()) : "None";
            Location loc = this.hologram.getLocation();
            this.locationRepl = String.format("%.1f %.1f %.1f", loc.getX(), loc.getY(), loc.getZ());
            this.permsRepl = this.hologram.hasPermissions() ? this.hologram.getPermissions() : "";
        }
    }
}

