/*
 * Decompiled with CFR 0.152.
 */
package dev.ratas.slimedogcore.impl.utils.logging;

import dev.ratas.slimedogcore.api.utils.logger.SDCSpamStrategy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DisallowWithinTimeStrategy
implements SDCSpamStrategy {
    final Map<String, Long> nextSendTimes = new ConcurrentHashMap<String, Long>();
    private final long blockForMs;
    private final long clearCacheMs;
    private long nextClear;

    public DisallowWithinTimeStrategy(long blockForMs, long clearCacheMs) {
        this.blockForMs = blockForMs;
        this.clearCacheMs = clearCacheMs;
        this.nextClear = System.currentTimeMillis() + clearCacheMs;
    }

    private void tickClearing(long current) {
        if (current > this.nextClear) {
            this.clearCache(current);
            this.nextClear = current + this.clearCacheMs;
        }
    }

    private void clearCache(long current) {
        this.nextSendTimes.values().removeIf(nextShow -> nextShow < current);
    }

    private boolean shouldBlock(long current, String msg) {
        Long nextSendTime = this.nextSendTimes.get(msg);
        long futureNext = current + this.blockForMs;
        boolean shouldBlock = nextSendTime != null && nextSendTime >= current;
        this.nextSendTimes.put(msg, futureNext);
        return shouldBlock;
    }

    @Override
    public boolean shouldSend(String msg) {
        long current = System.currentTimeMillis();
        this.tickClearing(current);
        return !this.shouldBlock(current, msg);
    }
}

