/*
 * Decompiled with CFR 0.152.
 */
package dev.ratas.slimedogcore.impl.scheduler;

import dev.ratas.slimedogcore.api.scheduler.SDCScheduler;
import dev.ratas.slimedogcore.api.scheduler.SDCTask;
import dev.ratas.slimedogcore.impl.SlimeDogCore;
import dev.ratas.slimedogcore.impl.scheduler.TaskWrapper;
import java.util.function.Consumer;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

public class Scheduler
implements SDCScheduler {
    private final SlimeDogCore plugin;

    public Scheduler(SlimeDogCore plugin) {
        this.plugin = plugin;
    }

    private BukkitScheduler getScheduler() {
        return this.plugin.getServer().getScheduler();
    }

    @Override
    public void runTask(Runnable runnable) {
        this.getScheduler().runTask((Plugin)this.plugin, runnable);
    }

    @Override
    public void runTaskAsync(Runnable runnable) {
        this.getScheduler().runTaskAsynchronously((Plugin)this.plugin, runnable);
    }

    @Override
    public void runTaskLater(Runnable runnable, long delayTicks) {
        this.getScheduler().runTaskLater((Plugin)this.plugin, runnable, delayTicks);
    }

    @Override
    public void runTaskLaterAsync(Runnable runnable, long delayTicks) {
        this.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, runnable, delayTicks);
    }

    @Override
    public void runTaskTimer(Runnable runnable, long delay, long period) {
        this.getScheduler().runTaskTimer((Plugin)this.plugin, runnable, delay, period);
    }

    @Override
    public void runTaskTimerAsync(Runnable runnable, long delay, long period) {
        this.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, runnable, delay, period);
    }

    private Consumer<BukkitTask> convert(Consumer<SDCTask> consumer) {
        return t -> consumer.accept(new TaskWrapper(this.plugin, (BukkitTask)t));
    }

    @Override
    public void runTask(Consumer<SDCTask> consumer) {
        this.getScheduler().runTask((Plugin)this.plugin, this.convert(consumer));
    }

    @Override
    public void runTaskAsync(Consumer<SDCTask> consumer) {
        this.getScheduler().runTaskAsynchronously((Plugin)this.plugin, this.convert(consumer));
    }

    @Override
    public void runTaskLater(Consumer<SDCTask> consumer, long delayTicks) {
        this.getScheduler().runTaskLater((Plugin)this.plugin, this.convert(consumer), delayTicks);
    }

    @Override
    public void runTaskLaterAsync(Consumer<SDCTask> consumer, long delayTicks) {
        this.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, this.convert(consumer), delayTicks);
    }

    @Override
    public void runTaskTimer(Consumer<SDCTask> consumer, long delay, long period) {
        this.getScheduler().runTaskTimer((Plugin)this.plugin, this.convert(consumer), delay, period);
    }

    @Override
    public void runTaskTimerAsync(Consumer<SDCTask> consumer, long delay, long period) {
        this.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this.convert(consumer), delay, period);
    }
}

