/*
 * Decompiled with CFR 0.152.
 */
package dev.ratas.slimedogcore.impl;

import dev.ratas.slimedogcore.api.SlimeDogPlugin;
import dev.ratas.slimedogcore.api.config.SDCCustomConfigManager;
import dev.ratas.slimedogcore.api.config.settings.SDCBaseSettings;
import dev.ratas.slimedogcore.api.messaging.recipient.SDCRecipient;
import dev.ratas.slimedogcore.api.reload.SDCReloadManager;
import dev.ratas.slimedogcore.api.scheduler.SDCScheduler;
import dev.ratas.slimedogcore.api.utils.logger.SDCDebugLogger;
import dev.ratas.slimedogcore.api.wrappers.SDCOnlinePlayerProvider;
import dev.ratas.slimedogcore.api.wrappers.SDCPluginInformation;
import dev.ratas.slimedogcore.api.wrappers.SDCPluginManager;
import dev.ratas.slimedogcore.api.wrappers.SDCResourceProvider;
import dev.ratas.slimedogcore.api.wrappers.SDCWorldProvider;
import dev.ratas.slimedogcore.impl.config.BaseSettings;
import dev.ratas.slimedogcore.impl.config.ConfigManager;
import dev.ratas.slimedogcore.impl.messaging.recipient.MessageRecipient;
import dev.ratas.slimedogcore.impl.reload.ReloadManager;
import dev.ratas.slimedogcore.impl.scheduler.Scheduler;
import dev.ratas.slimedogcore.impl.utils.logging.DebugLogger;
import dev.ratas.slimedogcore.impl.utils.logging.DisallowWithinTimeStrategy;
import dev.ratas.slimedogcore.impl.wrappers.OnlinePlayerProvider;
import dev.ratas.slimedogcore.impl.wrappers.PluginInformation;
import dev.ratas.slimedogcore.impl.wrappers.PluginManager;
import dev.ratas.slimedogcore.impl.wrappers.ResourceProvider;
import dev.ratas.slimedogcore.impl.wrappers.WorldProvider;
import dev.ratas.slimedogcore.shade.kyori.adventure.platform.bukkit.BukkitAudiences;
import java.io.File;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;

public abstract class SlimeDogCore
extends JavaPlugin
implements SlimeDogPlugin {
    private static final long BLOCK_IDENTICAL_DEBUG_MSG_MS = 10000L;
    private static final long CLEAR_DEBUG_LOGGER_CACHE_MS = 600000L;
    private final ConfigManager configManager = new ConfigManager(this);
    private final ResourceProvider resourceProvider = new ResourceProvider(this);
    private final PluginManager pluginManager = new PluginManager(this);
    private final WorldProvider worldProvider = new WorldProvider(this);
    private final Scheduler scheduler = new Scheduler(this);
    private final PluginInformation pluginInformation = new PluginInformation(this);
    private final DebugLogger debugLogger = new DebugLogger(this.getLogger(), () -> this.getBaseSettings().isDebugModeEnabled(), new DisallowWithinTimeStrategy(10000L, 600000L));
    private final BaseSettings baseSettings = new BaseSettings(() -> this.getDefaultConfig());
    private final SDCRecipient console = new MessageRecipient((CommandSender)this.getServer().getConsoleSender());
    private final SDCOnlinePlayerProvider onlinePlayerProvider = new OnlinePlayerProvider(this);
    private final SDCReloadManager reloadManager = new ReloadManager();
    private BukkitAudiences audience;

    public SlimeDogCore(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
    }

    public SlimeDogCore() {
        this.registerDefaultReloadables();
    }

    private void registerDefaultReloadables() {
        this.reloadManager.register(this.getDefaultConfig());
    }

    public void onEnable() {
        this.pluginEnabled();
        this.audience = BukkitAudiences.create((Plugin)this);
    }

    public BukkitAudiences getAudiences() {
        return this.audience;
    }

    public void onDisable() {
        this.pluginDisabled();
    }

    @Override
    public File getWorldFolder() {
        return this.getServer().getWorldContainer();
    }

    @Override
    public SDCScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public SDCPluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    public SDCWorldProvider getWorldProvider() {
        return this.worldProvider;
    }

    @Override
    public SDCResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    @Override
    public SDCCustomConfigManager getCustomConfigManager() {
        return this.configManager;
    }

    @Override
    public SDCPluginInformation getPluginInformation() {
        return this.pluginInformation;
    }

    @Override
    public SDCDebugLogger getDebugLogger() {
        return this.debugLogger;
    }

    @Override
    public SDCBaseSettings getBaseSettings() {
        return this.baseSettings;
    }

    @Override
    public SDCRecipient getConsoleRecipient() {
        return this.console;
    }

    @Override
    public SDCOnlinePlayerProvider getOnlinePlayerProvider() {
        return this.onlinePlayerProvider;
    }

    @Override
    public SDCReloadManager getReloadManager() {
        return this.reloadManager;
    }
}

