/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.noendcrystals.tools;

import lol.hyper.noendcrystals.NoEndCrystals;
import lol.hyper.noendcrystals.adventure.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class EndCrystalChecker
implements Listener {
    private final NoEndCrystals noEndCrystals;

    public EndCrystalChecker(NoEndCrystals noEndCrystals) {
        this.noEndCrystals = noEndCrystals;
    }

    private boolean allow(World world) {
        boolean allow = this.noEndCrystals.config.getStringList("worlds").contains(world.getName());
        return this.noEndCrystals.config.getBoolean("whitelist", true) == allow;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (Action.RIGHT_CLICK_BLOCK == event.getAction()) {
            if (event.getMaterial() != Material.END_CRYSTAL) {
                return;
            }
            if (event.getClickedBlock() == null) {
                return;
            }
            if (!(event.getClickedBlock().getType() != Material.OBSIDIAN && event.getClickedBlock().getType() != Material.BEDROCK || this.allow(player.getWorld()))) {
                event.setCancelled(true);
                String message = this.noEndCrystals.config.getString("message");
                if (message == null || message.isEmpty()) {
                    return;
                }
                this.noEndCrystals.getAdventure().player(player).sendMessage((Component)this.noEndCrystals.miniMessage.deserialize(message));
            }
        }
    }
}

