/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.noendcrystals.adventure.adventure.text.minimessage;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import lol.hyper.noendcrystals.adventure.adventure.text.Component;
import lol.hyper.noendcrystals.adventure.adventure.text.minimessage.ArgumentQueueImpl;
import lol.hyper.noendcrystals.adventure.adventure.text.minimessage.Context;
import lol.hyper.noendcrystals.adventure.adventure.text.minimessage.MiniMessage;
import lol.hyper.noendcrystals.adventure.adventure.text.minimessage.MiniMessageImpl;
import lol.hyper.noendcrystals.adventure.adventure.text.minimessage.ParsingException;
import lol.hyper.noendcrystals.adventure.adventure.text.minimessage.internal.parser.ParsingExceptionImpl;
import lol.hyper.noendcrystals.adventure.adventure.text.minimessage.internal.parser.Token;
import lol.hyper.noendcrystals.adventure.adventure.text.minimessage.internal.parser.node.TagPart;
import lol.hyper.noendcrystals.adventure.adventure.text.minimessage.tag.Tag;
import lol.hyper.noendcrystals.adventure.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import lol.hyper.noendcrystals.adventure.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ContextImpl
implements Context {
    private static final Token[] EMPTY_TOKEN_ARRAY = new Token[0];
    private final boolean strict;
    private final Consumer<String> debugOutput;
    private String message;
    private final MiniMessage miniMessage;
    private final TagResolver tagResolver;
    private final UnaryOperator<String> preProcessor;
    private final UnaryOperator<Component> postProcessor;

    ContextImpl(boolean strict, Consumer<String> debugOutput, String message, MiniMessage miniMessage, @NotNull TagResolver extraTags, UnaryOperator<String> preProcessor, UnaryOperator<Component> postProcessor) {
        this.strict = strict;
        this.debugOutput = debugOutput;
        this.message = message;
        this.miniMessage = miniMessage;
        this.tagResolver = extraTags;
        this.preProcessor = preProcessor == null ? UnaryOperator.identity() : preProcessor;
        this.postProcessor = postProcessor == null ? UnaryOperator.identity() : postProcessor;
    }

    static ContextImpl of(boolean strict, Consumer<String> debugOutput, String input, MiniMessageImpl miniMessage, TagResolver extraTags, UnaryOperator<String> preProcessor, UnaryOperator<Component> postProcessor) {
        return new ContextImpl(strict, debugOutput, input, miniMessage, extraTags, preProcessor, postProcessor);
    }

    public boolean strict() {
        return this.strict;
    }

    public Consumer<String> debugOutput() {
        return this.debugOutput;
    }

    @NotNull
    public String message() {
        return this.message;
    }

    void message(@NotNull String message) {
        this.message = message;
    }

    @NotNull
    public TagResolver extraTags() {
        return this.tagResolver;
    }

    public UnaryOperator<Component> postProcessor() {
        return this.postProcessor;
    }

    public UnaryOperator<String> preProcessor() {
        return this.preProcessor;
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull String message) {
        return this.miniMessage.deserialize(Objects.requireNonNull(message, "message"), this.tagResolver);
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull String message, @NotNull TagResolver resolver) {
        return this.miniMessage.deserialize(Objects.requireNonNull(message, "message"), TagResolver.builder().resolver(this.tagResolver).resolver(Objects.requireNonNull(resolver, "resolver")).build());
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull String message, TagResolver ... resolvers) {
        return this.miniMessage.deserialize(Objects.requireNonNull(message, "message"), TagResolver.builder().resolver(this.tagResolver).resolvers(Objects.requireNonNull(resolvers, "resolvers")).build());
    }

    @Override
    @NotNull
    public ParsingException newException(@NotNull String message) {
        return new ParsingExceptionImpl(message, this.message, null, false, EMPTY_TOKEN_ARRAY);
    }

    @Override
    @NotNull
    public ParsingException newException(@NotNull String message, @NotNull ArgumentQueue tags) {
        return new ParsingExceptionImpl(message, this.message, null, false, ContextImpl.tagsToTokens(((ArgumentQueueImpl)tags).args));
    }

    @Override
    @NotNull
    public ParsingException newException(@NotNull String message, @Nullable Throwable cause, @NotNull ArgumentQueue tags) {
        return new ParsingExceptionImpl(message, this.message, cause, false, ContextImpl.tagsToTokens(((ArgumentQueueImpl)tags).args));
    }

    private static Token[] tagsToTokens(List<? extends Tag.Argument> tags) {
        Token[] tokens = new Token[tags.size()];
        int length = tokens.length;
        for (int i = 0; i < length; ++i) {
            tokens[i] = ((TagPart)tags.get(i)).token();
        }
        return tokens;
    }
}

