/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.noendcrystals;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import lol.hyper.githubreleaseapi.GitHubRelease;
import lol.hyper.githubreleaseapi.GitHubReleaseAPI;
import lol.hyper.noendcrystals.CommandMain;
import lol.hyper.noendcrystals.adventure.adventure.platform.bukkit.BukkitAudiences;
import lol.hyper.noendcrystals.adventure.adventure.text.minimessage.MiniMessage;
import lol.hyper.noendcrystals.bstats.bukkit.Metrics;
import lol.hyper.noendcrystals.tools.EndCrystalChecker;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class NoEndCrystals
extends JavaPlugin
implements Listener {
    public FileConfiguration config;
    public final File configFile = new File(this.getDataFolder(), "config.yml");
    public final Logger logger = this.getLogger();
    public CommandMain commandReload;
    public EndCrystalChecker endCrystalChecker;
    public final MiniMessage miniMessage = MiniMessage.miniMessage();
    private BukkitAudiences adventure;

    public void onEnable() {
        this.adventure = BukkitAudiences.create((Plugin)this);
        this.commandReload = new CommandMain(this);
        this.endCrystalChecker = new EndCrystalChecker(this);
        if (!this.configFile.exists()) {
            this.saveResource("config.yml", true);
        }
        this.loadConfig(this.configFile);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this.endCrystalChecker, (Plugin)this);
        this.getCommand("noendcrystals").setExecutor((CommandExecutor)this.commandReload);
        new Metrics(this, 7230);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, this::checkForUpdates);
    }

    public void loadConfig(File file) {
        this.config = YamlConfiguration.loadConfiguration((File)file);
        int CONFIG_VERSION = 1;
        if (this.config.getInt("config-version") != CONFIG_VERSION) {
            this.logger.warning("Your config file is outdated! Please regenerate the config.");
        }
    }

    public void checkForUpdates() {
        GitHubReleaseAPI api;
        try {
            api = new GitHubReleaseAPI("NoEndCrystals", "hyperdefined");
        }
        catch (IOException e) {
            this.logger.warning("Unable to check updates!");
            e.printStackTrace();
            return;
        }
        GitHubRelease current = api.getReleaseByTag(this.getDescription().getVersion());
        GitHubRelease latest = api.getLatestVersion();
        if (current == null) {
            this.logger.warning("You are running a version that does not exist on GitHub. If you are in a dev environment, you can ignore this. Otherwise, this is a bug!");
            return;
        }
        int buildsBehind = api.getBuildsBehind(current);
        if (buildsBehind == 0) {
            this.logger.info("You are running the latest version.");
        } else {
            this.logger.warning("A new version is available (" + latest.getTagVersion() + ")! You are running version " + current.getTagVersion() + ". You are " + buildsBehind + " version(s) behind.");
        }
    }

    public BukkitAudiences getAdventure() {
        if (this.adventure == null) {
            throw new IllegalStateException("Tried to access Adventure when the plugin was disabled!");
        }
        return this.adventure;
    }
}

