/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.noendcrystals;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import lol.hyper.noendcrystals.NoEndCrystals;
import lol.hyper.noendcrystals.adventure.adventure.platform.bukkit.BukkitAudiences;
import lol.hyper.noendcrystals.adventure.adventure.text.Component;
import lol.hyper.noendcrystals.adventure.adventure.text.format.NamedTextColor;
import lol.hyper.noendcrystals.adventure.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabExecutor;
import org.jetbrains.annotations.NotNull;

public class CommandMain
implements TabExecutor {
    private final NoEndCrystals noEndCrystals;
    private final BukkitAudiences audiences;
    private final MiniMessage miniMessage;

    public CommandMain(NoEndCrystals noEndCrystals) {
        this.noEndCrystals = noEndCrystals;
        this.audiences = noEndCrystals.getAdventure();
        this.miniMessage = noEndCrystals.miniMessage;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (args.length == 0 || sender instanceof ConsoleCommandSender) {
            this.audiences.sender(sender).sendMessage((Component)this.miniMessage.deserialize("<green>NoEndCrystals version " + this.noEndCrystals.getDescription().getVersion() + ". Created by hyperdefined.</green>"));
            return true;
        }
        block12 : switch (args[0]) {
            case "reload": {
                this.noEndCrystals.loadConfig(this.noEndCrystals.configFile);
                this.audiences.sender(sender).sendMessage(Component.text("Configuration reloaded!").color(NamedTextColor.GREEN));
                break;
            }
            case "worlds": {
                List worlds = this.noEndCrystals.config.getStringList("worlds");
                if (worlds.isEmpty()) {
                    this.audiences.sender(sender).sendMessage(Component.text("The worlds list is currently empty.").color(NamedTextColor.RED));
                    break;
                }
                boolean mode = this.noEndCrystals.config.getBoolean("whitelist");
                this.audiences.sender(sender).sendMessage(Component.text("-----------------NoEndCrystals-----------------").color(NamedTextColor.GOLD));
                if (mode) {
                    this.audiences.sender(sender).sendMessage(Component.text("End Crystals will only work in these specified world(s):").color(NamedTextColor.YELLOW));
                } else {
                    this.audiences.sender(sender).sendMessage(Component.text("End Crystals cannot be placed in these world(s):").color(NamedTextColor.YELLOW));
                }
                this.audiences.sender(sender).sendMessage(Component.text(String.join((CharSequence)", ", worlds)).color(NamedTextColor.YELLOW));
                this.audiences.sender(sender).sendMessage(Component.text("--------------------------------------------").color(NamedTextColor.GOLD));
                break;
            }
            case "help": {
                this.audiences.sender(sender).sendMessage(Component.text("-----------------NoEndCrystals-----------------").color(NamedTextColor.GOLD));
                this.audiences.sender(sender).sendMessage((Component)this.miniMessage.deserialize("<gold>/noendcrystals help</gold> <yellow>- Shows this menu.</yellow>"));
                this.audiences.sender(sender).sendMessage((Component)this.miniMessage.deserialize("<gold>/noendcrystals worlds</gold> <yellow>- Shows which worlds are enabled/disabled.</yellow>"));
                this.audiences.sender(sender).sendMessage((Component)this.miniMessage.deserialize("<gold>/noendcrystals add</gold> <yellow>- Adds a world to the list.</yellow>"));
                this.audiences.sender(sender).sendMessage((Component)this.miniMessage.deserialize("<gold>/noendcrystals remove</gold> <yellow>- Removes a world from the list.</yellow>"));
                this.audiences.sender(sender).sendMessage((Component)this.miniMessage.deserialize("<gold>/noendcrystals mode</gold> <yellow>- Change which mode to use.</yellow>"));
                this.audiences.sender(sender).sendMessage((Component)this.miniMessage.deserialize("<gold>/noendcrystals reload</gold> <yellow>- Reloads the configuration.</yellow>"));
                this.audiences.sender(sender).sendMessage(Component.text("--------------------------------------------").color(NamedTextColor.GOLD));
                break;
            }
            case "add": {
                if (args.length == 2) {
                    String world = args[1].toLowerCase(Locale.ROOT);
                    List worlds = this.noEndCrystals.config.getStringList("worlds");
                    if (worlds.contains(world.toLowerCase(Locale.ROOT))) {
                        this.audiences.sender(sender).sendMessage(Component.text("This world is already on the list.").color(NamedTextColor.RED));
                        break;
                    }
                    worlds.add(world);
                    this.noEndCrystals.config.set("worlds", (Object)worlds);
                    try {
                        this.noEndCrystals.config.save(this.noEndCrystals.configFile);
                    }
                    catch (IOException e) {
                        this.noEndCrystals.logger.severe("Unable to save config!");
                        e.printStackTrace();
                    }
                    this.audiences.sender(sender).sendMessage(Component.text(world + " has been added.").color(NamedTextColor.GREEN));
                    break;
                }
                this.audiences.sender(sender).sendMessage(Component.text("You must specify which world.").color(NamedTextColor.RED));
                break;
            }
            case "remove": {
                if (args.length == 2) {
                    String world = args[1].toLowerCase(Locale.ROOT);
                    List worlds = this.noEndCrystals.config.getStringList("worlds");
                    if (!worlds.contains(world.toLowerCase(Locale.ROOT))) {
                        this.audiences.sender(sender).sendMessage(Component.text("This world is not on the list.").color(NamedTextColor.RED));
                        break;
                    }
                    worlds.remove(world);
                    this.noEndCrystals.config.set("worlds", (Object)worlds);
                    try {
                        this.noEndCrystals.config.save(this.noEndCrystals.configFile);
                    }
                    catch (IOException e) {
                        this.noEndCrystals.logger.severe("Unable to save config!");
                        e.printStackTrace();
                    }
                    this.audiences.sender(sender).sendMessage(Component.text(world + " has been removed.").color(NamedTextColor.GREEN));
                    break;
                }
                this.audiences.sender(sender).sendMessage(Component.text("You must specify which world.").color(NamedTextColor.RED));
                break;
            }
            case "mode": {
                if (args.length == 2) {
                    switch (args[1]) {
                        case "whitelist": {
                            this.noEndCrystals.config.set("whitelist", (Object)true);
                            try {
                                this.noEndCrystals.config.save(this.noEndCrystals.configFile);
                            }
                            catch (IOException e) {
                                this.noEndCrystals.logger.severe("Unable to save config!");
                                e.printStackTrace();
                            }
                            this.audiences.sender(sender).sendMessage(Component.text("Mode has been changed to whitelist.").color(NamedTextColor.GREEN));
                            break block12;
                        }
                        case "blacklist": {
                            this.noEndCrystals.config.set("whitelist", (Object)false);
                            try {
                                this.noEndCrystals.config.save(this.noEndCrystals.configFile);
                            }
                            catch (IOException e) {
                                this.noEndCrystals.logger.severe("Unable to save config!");
                                e.printStackTrace();
                            }
                            this.audiences.sender(sender).sendMessage(Component.text("Mode has been changed to blacklist.").color(NamedTextColor.GREEN));
                            break block12;
                        }
                    }
                    this.audiences.sender(sender).sendMessage(Component.text("Invalid mode.").color(NamedTextColor.RED));
                    break;
                }
                String mode = this.noEndCrystals.config.getBoolean("whitelist") ? "whitelist" : "blacklist";
                this.audiences.sender(sender).sendMessage(Component.text("-----------------NoEndCrystals-----------------").color(NamedTextColor.GOLD));
                this.audiences.sender(sender).sendMessage(Component.text("Mode is currently set to " + mode + ".").color(NamedTextColor.YELLOW));
                if (mode.equals("whitelist")) {
                    this.audiences.sender(sender).sendMessage(Component.text("End Crystals will only work in the specified worlds (see /noendcrystals /worlds).").color(NamedTextColor.YELLOW));
                } else {
                    this.audiences.sender(sender).sendMessage(Component.text("End Crystals will work in all worlds besides the one(s) on the list (see /noendcrystals /worlds).").color(NamedTextColor.YELLOW));
                }
                this.audiences.sender(sender).sendMessage(Component.text("If you want to change the mode, simply do /noendcrystals mode <whitelist/blacklist>").color(NamedTextColor.YELLOW));
                this.audiences.sender(sender).sendMessage(Component.text("--------------------------------------------").color(NamedTextColor.GOLD));
                break;
            }
            default: {
                this.audiences.sender(sender).sendMessage(Component.text("Unknown option. Please see /noendcrystals help for all valid options.").color(NamedTextColor.RED));
            }
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length >= 1) {
            String arg = args[0];
            if (arg.equalsIgnoreCase("remove")) {
                return this.noEndCrystals.config.getStringList("worlds");
            }
            if (arg.equalsIgnoreCase("mode")) {
                return Arrays.asList("whitelist", "blacklist");
            }
            if (arg.equalsIgnoreCase("add") || arg.equalsIgnoreCase("help") || arg.equalsIgnoreCase("reload") || arg.equalsIgnoreCase("worlds")) {
                return null;
            }
        }
        return Arrays.asList("reload", "worlds", "add", "remove", "help", "mode");
    }
}

