/*
 * Decompiled with CFR 0.152.
 */
package NL.ThijsSmeel.Blocks;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ItemStorageMelt {
    private int countItem;
    private int countBlock;
    private final Material materialItem;
    private final Material materialBlock;

    public ItemStorageMelt(Material item, Material block, Player player) {
        this.materialItem = item;
        this.materialBlock = block;
        if (this.hasNonPermission(player)) {
            return;
        }
        for (ItemStack itemstack : player.getInventory().getContents()) {
            if (itemstack == null) continue;
            if (itemstack.getType() == item) {
                this.countItem += itemstack.getAmount();
            }
            if (itemstack.getType() != block) continue;
            this.countBlock += itemstack.getAmount();
        }
        if (this.canConvert()) {
            player.getInventory().remove(this.materialItem);
            player.getInventory().remove(this.materialBlock);
        }
    }

    boolean hasNonPermission(Player player) {
        return !player.hasPermission("blocks.melt." + this.materialItem.name().toLowerCase());
    }

    boolean canConvert() {
        return this.countItem > 0;
    }

    void replaceBack(Inventory inv) {
        if (!this.canConvert()) {
            return;
        }
        inv.addItem(new ItemStack[]{new ItemStack(this.materialBlock, this.countItem + this.countBlock)});
    }
}

