/*
 * Decompiled with CFR 0.152.
 */
package NL.ThijsSmeel.Blocks;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ItemStorage {
    private int countItem = 0;
    private int countBlock = 0;
    private final Material materialItem;
    private final Material materialBlock;
    boolean toBlock;

    public ItemStorage(Material item, Material block, Player player, boolean toBlock) {
        this.toBlock = toBlock;
        this.materialItem = item;
        this.materialBlock = block;
        if (this.hasNonPermission(player)) {
            return;
        }
        for (ItemStack itemstack : player.getInventory().getContents()) {
            if (itemstack == null) continue;
            if (itemstack.getType() == item) {
                this.countItem += itemstack.getAmount();
            }
            if (itemstack.getType() != block) continue;
            this.countBlock += itemstack.getAmount();
        }
        player.getInventory().remove(this.materialItem);
        player.getInventory().remove(this.materialBlock);
    }

    boolean hasNonPermission(Player player) {
        if (this.toBlock) {
            return !player.hasPermission("blocks.blocks." + this.materialItem.name().toLowerCase());
        }
        return !player.hasPermission("blocks.unblocks." + this.materialItem.name().toLowerCase());
    }

    boolean canConvert() {
        if (this.toBlock && this.countItem < 9) {
            return false;
        }
        return this.toBlock || this.countBlock != 0;
    }

    int getInvSpace() {
        int craftAmount;
        int n = craftAmount = this.materialItem == Material.QUARTZ ? 4 : 9;
        if (this.toBlock) {
            return this.getInvSpace(this.countItem % craftAmount) + this.getInvSpace(this.countItem / craftAmount + this.countBlock);
        }
        return this.getInvSpace(this.countBlock * craftAmount + this.countItem);
    }

    void replaceBack(Inventory inv) {
        inv.addItem(new ItemStack[]{new ItemStack(this.materialItem, this.countItem)});
        inv.addItem(new ItemStack[]{new ItemStack(this.materialBlock, this.countBlock)});
    }

    void replaceBackProcessed(Inventory inv) {
        int craftAmount;
        int n = craftAmount = this.materialItem == Material.QUARTZ ? 4 : 9;
        if (this.toBlock) {
            inv.addItem(new ItemStack[]{new ItemStack(this.materialItem, this.countItem % craftAmount)});
            inv.addItem(new ItemStack[]{new ItemStack(this.materialBlock, this.countItem / craftAmount + this.countBlock)});
            return;
        }
        inv.addItem(new ItemStack[]{new ItemStack(this.materialItem, this.countBlock * craftAmount + this.countItem)});
    }

    private int getInvSpace(int number) {
        if (number == 0) {
            return 0;
        }
        int out = number / 64;
        if (number % 64 != 0) {
            ++out;
        }
        return out;
    }
}

