/*
 * Decompiled with CFR 0.152.
 */
package NL.ThijsSmeel.Blocks;

import NL.ThijsSmeel.Blocks.ItemStorage;
import NL.ThijsSmeel.Blocks.ItemStorageMelt;
import NL.ThijsSmeel.Blocks.Main;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CommandHandler
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            if (args.length >= 1 && args[0].equalsIgnoreCase("reload")) {
                Main.get().reloadConfig();
                sender.sendMessage("Config has been reloaded.");
            } else {
                sender.sendMessage("Command can not be executed from the console");
            }
            return true;
        }
        Player player = (Player)sender;
        switch (cmd.getName().toLowerCase()) {
            case "blocks": {
                if (args.length >= 1 && args[0].equalsIgnoreCase("reload") && player.hasPermission("blocks.reload")) {
                    Main.get().reloadConfig();
                    this.sendToPlayer(player, "messages.reloadconfig");
                    return true;
                }
                int result = this.replace(this.createNewLittleList(player), player);
                int result2 = this.replace(this.createNewBigList(player, true), player);
                if (result == 1 || result2 == 1) {
                    this.sendToPlayer(player, "messages.succesfull_toblocks");
                    player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_LAND, 0.5f, 1.7f);
                    break;
                }
                if (result == -1 || result2 == -1) {
                    this.sendToPlayer(player, "messages.unsuccesfull_toblocks");
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.5f, 0.8f);
                    break;
                }
                if (result == -2 || result2 == -2) {
                    this.sendToPlayer(player, "messages.nopermission_toblocks");
                    break;
                }
                this.sendToPlayer(player, "messages.noblocks_toblocks");
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.5f, 1.2f);
                break;
            }
            case "unblocks": {
                int result2 = this.replace(this.createNewBigList(player, false), player);
                if (result2 == 1) {
                    this.sendToPlayer(player, "messages.succesfull_toitems");
                    player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_LAND, 0.5f, 1.7f);
                    break;
                }
                if (result2 == -1) {
                    this.sendToPlayer(player, "messages.unsuccesfull_toitems");
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.5f, 0.8f);
                    break;
                }
                if (result2 == -2) {
                    this.sendToPlayer(player, "messages.nopermission_toitems");
                    break;
                }
                this.sendToPlayer(player, "messages.noitems_toitems");
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.5f, 1.2f);
                break;
            }
            case "melt": {
                int result = this.melt(this.createNewMeltList(player), player);
                if (result == 1) {
                    this.sendToPlayer(player, "messages.succesfull_melt");
                    player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_LAND, 0.5f, 1.7f);
                    break;
                }
                if (result == -1) {
                    this.sendToPlayer(player, "messages.unsuccesfull_melt");
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.5f, 0.8f);
                    break;
                }
                if (result == -2) {
                    this.sendToPlayer(player, "messages.nopermission_melt");
                    break;
                }
                if (result != 0) break;
                this.sendToPlayer(player, "messages.noitems_melt");
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.5f, 1.2f);
                break;
            }
        }
        return true;
    }

    int melt(List<ItemStorageMelt> itemCounters, Player player) {
        boolean hasPerm = false;
        for (ItemStorageMelt itemCounter : itemCounters) {
            if (itemCounter.hasNonPermission(player)) continue;
            hasPerm = true;
        }
        if (!hasPerm) {
            return -2;
        }
        boolean canConvert = false;
        for (ItemStorageMelt itemCounter : itemCounters) {
            if (!itemCounter.canConvert()) continue;
            canConvert = true;
        }
        if (!canConvert) {
            return 0;
        }
        itemCounters.forEach(x -> x.replaceBack((Inventory)player.getInventory()));
        return 1;
    }

    int replace(List<ItemStorage> itemCounters, Player player) {
        boolean bl;
        boolean hasPerm = false;
        for (ItemStorage itemStorage : itemCounters) {
            if (itemStorage.hasNonPermission(player)) continue;
            hasPerm = true;
        }
        if (!hasPerm) {
            return -2;
        }
        int totalSpaceNeeded = 0;
        for (ItemStorage itemCounter : itemCounters) {
            totalSpaceNeeded += itemCounter.getInvSpace();
        }
        boolean bl2 = false;
        for (ItemStorage itemCounter : itemCounters) {
            if (!itemCounter.canConvert()) continue;
            bl = true;
        }
        if (!bl) {
            itemCounters.forEach(x -> x.replaceBack((Inventory)player.getInventory()));
            return 0;
        }
        if (this.getAmountEmpty((Inventory)player.getInventory()) < totalSpaceNeeded) {
            itemCounters.forEach(x -> x.replaceBack((Inventory)player.getInventory()));
            return -1;
        }
        itemCounters.forEach(x -> x.replaceBackProcessed((Inventory)player.getInventory()));
        return 1;
    }

    List<ItemStorage> createNewBigList(Player player, Boolean toBlock) {
        ArrayList<ItemStorage> itemCounters = new ArrayList<ItemStorage>();
        itemCounters.add(new ItemStorage(Material.DIAMOND, Material.DIAMOND_BLOCK, player, toBlock));
        itemCounters.add(new ItemStorage(Material.EMERALD, Material.EMERALD_BLOCK, player, toBlock));
        itemCounters.add(new ItemStorage(Material.IRON_INGOT, Material.IRON_BLOCK, player, toBlock));
        itemCounters.add(new ItemStorage(Material.GOLD_INGOT, Material.GOLD_BLOCK, player, toBlock));
        itemCounters.add(new ItemStorage(Material.LAPIS_LAZULI, Material.LAPIS_BLOCK, player, toBlock));
        itemCounters.add(new ItemStorage(Material.REDSTONE, Material.REDSTONE_BLOCK, player, toBlock));
        itemCounters.add(new ItemStorage(Material.COAL, Material.COAL_BLOCK, player, toBlock));
        itemCounters.add(new ItemStorage(Material.QUARTZ, Material.QUARTZ_BLOCK, player, toBlock));
        itemCounters.add(new ItemStorage(Material.SLIME_BALL, Material.SLIME_BLOCK, player, toBlock));
        itemCounters.add(new ItemStorage(Material.DRIED_KELP, Material.DRIED_KELP_BLOCK, player, toBlock));
        return itemCounters;
    }

    List<ItemStorage> createNewLittleList(Player player) {
        ArrayList<ItemStorage> itemCounters = new ArrayList<ItemStorage>();
        itemCounters.add(new ItemStorage(Material.IRON_NUGGET, Material.IRON_INGOT, player, true));
        itemCounters.add(new ItemStorage(Material.GOLD_NUGGET, Material.GOLD_INGOT, player, true));
        return itemCounters;
    }

    List<ItemStorageMelt> createNewMeltList(Player player) {
        ArrayList<ItemStorageMelt> itemCounters = new ArrayList<ItemStorageMelt>();
        itemCounters.add(new ItemStorageMelt(Material.IRON_ORE, Material.IRON_INGOT, player));
        itemCounters.add(new ItemStorageMelt(Material.GOLD_ORE, Material.GOLD_INGOT, player));
        itemCounters.add(new ItemStorageMelt(Material.DIAMOND_ORE, Material.DIAMOND, player));
        itemCounters.add(new ItemStorageMelt(Material.EMERALD_ORE, Material.EMERALD, player));
        itemCounters.add(new ItemStorageMelt(Material.LAPIS_ORE, Material.LAPIS_LAZULI, player));
        itemCounters.add(new ItemStorageMelt(Material.REDSTONE_ORE, Material.REDSTONE, player));
        itemCounters.add(new ItemStorageMelt(Material.COAL_ORE, Material.COAL, player));
        itemCounters.add(new ItemStorageMelt(Material.NETHER_QUARTZ_ORE, Material.QUARTZ, player));
        itemCounters.add(new ItemStorageMelt(Material.COBBLESTONE, Material.STONE, player));
        itemCounters.add(new ItemStorageMelt(Material.CLAY, Material.BRICK, player));
        itemCounters.add(new ItemStorageMelt(Material.WET_SPONGE, Material.SPONGE, player));
        itemCounters.add(new ItemStorageMelt(Material.PORKCHOP, Material.COOKED_PORKCHOP, player));
        itemCounters.add(new ItemStorageMelt(Material.BEEF, Material.COOKED_BEEF, player));
        itemCounters.add(new ItemStorageMelt(Material.CHICKEN, Material.COOKED_CHICKEN, player));
        itemCounters.add(new ItemStorageMelt(Material.COD, Material.COOKED_COD, player));
        itemCounters.add(new ItemStorageMelt(Material.SALMON, Material.COOKED_SALMON, player));
        itemCounters.add(new ItemStorageMelt(Material.POTATO, Material.BAKED_POTATO, player));
        itemCounters.add(new ItemStorageMelt(Material.MUTTON, Material.COOKED_MUTTON, player));
        itemCounters.add(new ItemStorageMelt(Material.RABBIT, Material.COOKED_RABBIT, player));
        itemCounters.add(new ItemStorageMelt(Material.KELP, Material.DRIED_KELP, player));
        itemCounters.add(new ItemStorageMelt(Material.SAND, Material.GLASS, player));
        itemCounters.add(new ItemStorageMelt(Material.RED_SAND, Material.GLASS, player));
        return itemCounters;
    }

    int getAmountEmpty(Inventory inventory) {
        int counterEmpty = 0;
        for (int i = 0; i < inventory.getContents().length - 5; ++i) {
            ItemStack itemstack = inventory.getItem(i);
            if (itemstack != null) continue;
            ++counterEmpty;
        }
        return counterEmpty;
    }

    void sendToPlayer(Player player, String message) {
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(Main.get().getConfig().getString(message, "&c" + message + " Not Set"))));
    }
}

