/*
 * Decompiled with CFR 0.152.
 */
package com.elikill58.ipmanager.handler;

import com.elikill58.ipmanager.IpManager;
import com.elikill58.ipmanager.handler.IP;
import com.elikill58.ipmanager.handler.IpPlayerAbstract;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class IpPlayer
extends IpPlayerAbstract {
    private static final HashMap<UUID, IpPlayer> IP_PLAYERS = new HashMap();
    private final Player p;
    private IP ip = null;
    private String basicIP;
    private String bungeeIP;
    private String faiIP;
    private final long connectionTime;

    public IpPlayer(Player p) {
        this.p = p;
        this.connectionTime = System.currentTimeMillis();
        IpManager im = IpManager.getInstance();
        String uuid = p.getUniqueId().toString();
        this.basicIP = im.getIPConfig().getString(String.valueOf(uuid) + ".ip");
        this.bungeeIP = im.getIPConfig().getString(String.valueOf(uuid) + ".proxy");
        this.faiIP = im.getIPConfig().getString(String.valueOf(uuid) + ".fai");
    }

    public Player getPlayer() {
        return this.p;
    }

    public boolean isIP(String checkIp) {
        return this.basicIP.equalsIgnoreCase(checkIp);
    }

    public IP getIP() {
        return this.ip;
    }

    public void setIp(IP ip) {
        this.ip = ip;
    }

    @Override
    public String getBasicIP() {
        return this.basicIP;
    }

    public void setBasicIP(String ip) {
        this.basicIP = ip;
    }

    @Override
    public String getBungeeIP() {
        return this.bungeeIP;
    }

    public void setBungeeIP(String ip) {
        this.bungeeIP = ip;
    }

    @Override
    public String getFaiIP() {
        return this.faiIP;
    }

    public void setFaiIP(String ip) {
        this.faiIP = ip;
    }

    public long getConnectionTime() {
        return this.connectionTime;
    }

    public long getOnlineTime() {
        return System.currentTimeMillis() - this.connectionTime;
    }

    public void remove() {
        this.save();
        IP_PLAYERS.remove(this.getPlayer().getUniqueId());
    }

    public void save() {
        IpManager im = IpManager.getInstance();
        String uuid = this.p.getUniqueId().toString();
        im.getIPConfig().set(String.valueOf(uuid) + ".name", (Object)this.p.getName());
        im.getIPConfig().set(String.valueOf(uuid) + ".ip", (Object)this.basicIP);
        im.getIPConfig().set(String.valueOf(uuid) + ".proxy", (Object)this.bungeeIP);
        im.getIPConfig().set(String.valueOf(uuid) + ".fai", (Object)this.faiIP);
        List list = im.getIPConfig().getLongList(String.valueOf(uuid) + ".connection");
        list.add(this.connectionTime);
        im.getIPConfig().set(String.valueOf(uuid) + ".connection", (Object)list);
        im.saveIPConfig();
    }

    public static List<IpPlayer> getPlayersOnIP(String ip) {
        return IP_PLAYERS.values().stream().filter(ipp -> ipp.isIP(ip)).collect(Collectors.toList());
    }

    public static IpPlayer getIpPlayer(Player p) {
        return IP_PLAYERS.computeIfAbsent(p.getUniqueId(), uuid -> new IpPlayer(p));
    }
}

