/*
 * Decompiled with CFR 0.152.
 */
package com.elikill58.ipmanager.handler;

import com.elikill58.ipmanager.IpManager;
import com.elikill58.ipmanager.handler.IpPlayerAbstract;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.OfflinePlayer;

public class IpOfflinePlayer
extends IpPlayerAbstract {
    private static final HashMap<UUID, IpOfflinePlayer> IP_PLAYERS = new HashMap();
    private final OfflinePlayer p;
    private final String basicIP;
    private final String bungeeIP;
    private final String faiIP;

    public IpOfflinePlayer(OfflinePlayer p) {
        this.p = p;
        IpManager im = IpManager.getInstance();
        String uuid = p.getUniqueId().toString();
        this.basicIP = im.getIPConfig().getString(String.valueOf(uuid) + ".ip");
        this.bungeeIP = im.getIPConfig().getString(String.valueOf(uuid) + ".proxy");
        this.faiIP = im.getIPConfig().getString(String.valueOf(uuid) + ".fai");
        IP_PLAYERS.put(p.getUniqueId(), this);
    }

    @Override
    public OfflinePlayer getPlayer() {
        return this.p;
    }

    @Override
    public String getBasicIP() {
        return this.basicIP;
    }

    @Override
    public String getBungeeIP() {
        return this.bungeeIP;
    }

    @Override
    public String getFaiIP() {
        return this.faiIP;
    }

    public static IpOfflinePlayer getIpPlayer(OfflinePlayer p) {
        if (IP_PLAYERS.containsKey(p.getUniqueId())) {
            return IP_PLAYERS.get(p.getUniqueId());
        }
        return new IpOfflinePlayer(p);
    }
}

