/*
 * Decompiled with CFR 0.152.
 */
package com.elikill58.ipmanager.handler;

import com.elikill58.ipmanager.IpManager;
import com.elikill58.ipmanager.Utils;
import com.elikill58.ipmanager.exception.NotLoadedException;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class IP {
    private static final HashMap<String, IP> IPS = new HashMap();
    private final String ip;
    private String allIpJsonInfos;
    private HashMap<IpInfos, String> ipInfos = new HashMap();
    private boolean isVPN = false;
    private boolean isProxy = false;
    private boolean isHosting = false;

    public IP(String ip) {
        this.ip = ip;
        if (Bukkit.isPrimaryThread()) {
            IpManager pl = IpManager.getInstance();
            pl.getLogger().severe("Cannot load IP " + ip + " sync ... Loading it async but few error can appear.");
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)pl, this::loadContent);
        } else {
            this.loadContent();
        }
    }

    private void loadContent() {
        block11: {
            block10: {
                try {
                    String checkingVpn = Utils.getContentFromUrl(String.valueOf(Utils.getServerURL()) + "ipmanager.php?ip=" + this.ip);
                    Object data = new JSONParser().parse(checkingVpn);
                    if (data instanceof JSONObject) {
                        JSONObject json = (JSONObject)data;
                        Object status = json.get((Object)"status");
                        if (status.toString().equalsIgnoreCase("ok")) {
                            JSONObject result = (JSONObject)json.get((Object)"result");
                            this.isVPN = result.get((Object)"vpn") == "true";
                            this.isProxy = result.get((Object)"proxy") == "true";
                            this.isHosting = result.get((Object)"hosting") == "true";
                        } else {
                            IpManager.getInstance().getLogger().severe("Error while loading VPN data for " + this.ip + ": " + status.toString());
                        }
                        break block10;
                    }
                    throw new NoSuchFieldException("Cannot found JSON vpn data for '" + this.allIpJsonInfos + "' string.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.allIpJsonInfos = Utils.getContentFromUrl("https://ipapi.co/" + this.ip + "/json/");
            try {
                Object data = new JSONParser().parse(this.allIpJsonInfos);
                if (data instanceof JSONObject) {
                    JSONObject json = (JSONObject)data;
                    IpInfos[] ipInfosArray = IpInfos.values();
                    int n = ipInfosArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IpInfos ii = ipInfosArray[n2];
                        if (!ii.equals((Object)IpInfos.UNSET)) {
                            this.ipInfos.put(ii, json.getOrDefault((Object)ii.name().toLowerCase(), (Object)"unknow").toString());
                        }
                        ++n2;
                    }
                    break block11;
                }
                throw new NoSuchFieldException("Cannot found JSON data for '" + this.allIpJsonInfos + "' string.");
            }
            catch (Exception e) {
                this.ipInfos.put(IpInfos.UNSET, "Error while getting IP information : " + e.getMessage() + ".");
            }
        }
    }

    public String getStringIP() {
        return this.ip;
    }

    public HashMap<IpInfos, String> getAllIpInfos() {
        return this.ipInfos;
    }

    public boolean isVPN() {
        return this.isVPN;
    }

    public boolean isProxy() {
        return this.isProxy;
    }

    public boolean isHosting() {
        return this.isHosting;
    }

    public String getIpInfos(IpInfos i) {
        if (this.ipInfos.isEmpty()) {
            try {
                throw new NotLoadedException("IP informations are not currently loaded. Please wait ...");
            }
            catch (NotLoadedException e) {
                e.printStackTrace();
            }
        }
        return this.ipInfos.getOrDefault((Object)i, "");
    }

    public static IP getIP(String ip) {
        return IPS.computeIfAbsent(ip, ipp -> new IP((String)ipp));
    }

    public static enum IpInfos {
        CITY,
        REGION,
        REGION_CODE,
        COUNTRY_CODE,
        COUNTRY_NAME,
        CONTINENT_CODE,
        IN_EU,
        TIMEZONE,
        LANGUAGUES,
        ASN,
        ORG,
        UNSET;

    }
}

