/*
 * Decompiled with CFR 0.152.
 */
package com.elikill58.ipmanager.ban;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class Ban {
    private final UUID playerId;
    private final String reason;
    private final String bannedBy;

    public Ban(UUID playerId, String reason, String bannedBy) {
        this.playerId = playerId;
        this.reason = reason;
        this.bannedBy = bannedBy;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public OfflinePlayer getOfflinePlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.getPlayerId());
    }

    public String getReason() {
        return this.reason;
    }

    public String getBannedBy() {
        return this.bannedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ban ban = (Ban)o;
        return this.playerId.equals(ban.playerId) && this.reason.equals(ban.reason) && this.bannedBy.equals(ban.bannedBy);
    }

    public int hashCode() {
        return Objects.hash(this.playerId, this.reason, this.bannedBy);
    }

    public static Ban from(Ban from) {
        return new Ban(from.getPlayerId(), from.getReason(), from.getBannedBy());
    }

    public static Ban create(UUID playerId, String reason, String bannedBy) {
        return new Ban(playerId, reason, bannedBy);
    }
}

