/*
 * Decompiled with CFR 0.152.
 */
package com.elikill58.ipmanager;

import com.elikill58.ipmanager.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public enum Version {
    V1_7("1.7", 7, 500, 0, 5),
    V1_8("1.8", 8, 500, 6, 47),
    V1_9("1.9", 9, 400, 48, 110),
    V1_10("1.10", 10, 400, 201, 210),
    V1_11("1.11", 11, 300, 301, 316),
    V1_12("1.12", 12, 150, 317, 340),
    V1_13("1.13", 13, 150, 341, 404),
    V1_14("1.14", 14, 100, 441, 500),
    V1_15("1.15", 15, 100, 550, 578),
    V1_16("1.16", 16, 100, 700, 800),
    V1_17("1.17", 17, 100, 800, 1000),
    V1_18("1.18", 17, 100, 800, 1000),
    HIGHER("higher", 42, 100, 1000, 1000);

    private final int power;
    private final int timeBetweenRegen;
    private final List<Integer> protocolNumber = new ArrayList<Integer>();
    private final String name;

    private Version(String name, int power, int timeBetweenRegen, int firstProtocolNumber, int lastProtocolNumber) {
        this.name = name;
        this.power = power;
        this.timeBetweenRegen = timeBetweenRegen;
        int i = firstProtocolNumber;
        while (i <= lastProtocolNumber) {
            this.protocolNumber.add(i);
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isNewerThan(Version other) {
        return this.power > other.getPower();
    }

    public boolean isNewerOrEquals(Version other) {
        return this.power >= other.getPower();
    }

    public int getPower() {
        return this.power;
    }

    public int getTimeBetweenTwoRegenFromVersion() {
        return this.timeBetweenRegen;
    }

    public List<Integer> getProtocolNumber() {
        return this.protocolNumber;
    }

    public static Version getVersionByName(String name) {
        Version[] versionArray = Version.values();
        int n = versionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Version v = versionArray[n2];
            if (name.startsWith(v.getName())) {
                return v;
            }
            ++n2;
        }
        return HIGHER;
    }

    public static Version getVersionByProtocolID(int id) {
        Version[] versionArray = Version.values();
        int n = versionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Version v = versionArray[n2];
            if (v.getProtocolNumber().contains(id)) {
                return v;
            }
            ++n2;
        }
        return HIGHER;
    }

    public static boolean isNewerOrEquals(Version v1, Version v2) {
        return v1.isNewerOrEquals(v2);
    }

    public static Version getVersion() {
        return Version.getVersion(Utils.VERSION);
    }

    public static Version getVersion(String version) {
        Version[] versionArray = Version.values();
        int n = versionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Version v = versionArray[n2];
            if (version.toLowerCase(Locale.ROOT).startsWith(v.name().toLowerCase(Locale.ROOT))) {
                return v;
            }
            ++n2;
        }
        return HIGHER;
    }
}

