/*
 * Decompiled with CFR 0.152.
 */
package com.elikill58.ipmanager;

import com.elikill58.ipmanager.Version;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class PacketUtils {
    public static final String VERSION = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
    public static final String NMS_PREFIX;
    public static Class<?> CRAFT_PLAYER_CLASS;
    private static final HashMap<String, Class<?>> ALL_CLASS;

    static {
        ALL_CLASS = new HashMap();
        NMS_PREFIX = Version.getVersion(VERSION).isNewerOrEquals(Version.V1_17) ? "net.minecraft." : "net.minecraft.server." + VERSION + ".";
        try {
            CRAFT_PLAYER_CLASS = Class.forName("org.bukkit.craftbukkit." + VERSION + ".entity.CraftPlayer");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Class<?> getNmsClass(String name, String packagePrefix) {
        if (ALL_CLASS.containsKey(name)) {
            return ALL_CLASS.get(name);
        }
        try {
            Class<?> clazz = Class.forName(String.valueOf(NMS_PREFIX) + (Version.getVersion(VERSION).isNewerOrEquals(Version.V1_17) ? packagePrefix : "") + name);
            ALL_CLASS.put(name, clazz);
            return clazz;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getPing(Player p) {
        try {
            Object entityPlayer = PacketUtils.getEntityPlayer(p);
            return entityPlayer.getClass().getField("ping").getInt(entityPlayer);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static Object getPlayerConnection(Player p) {
        try {
            Object entityPlayer = PacketUtils.getEntityPlayer(p);
            if (Version.getVersion().isNewerOrEquals(Version.V1_17)) {
                return entityPlayer.getClass().getField("b").get(entityPlayer);
            }
            return entityPlayer.getClass().getField("playerConnection").get(entityPlayer);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getEntityPlayer(Player p) {
        try {
            Object craftPlayer = CRAFT_PLAYER_CLASS.cast(p);
            return craftPlayer.getClass().getMethod("getHandle", new Class[0]).invoke(craftPlayer, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getWorldServer(Location loc) {
        try {
            Object object = Class.forName("org.bukkit.craftbukkit." + VERSION + ".CraftWorld").cast(loc.getWorld());
            return object.getClass().getMethod("getHandle", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

