/*
 * Decompiled with CFR 0.152.
 */
package com.elikill58.ipmanager;

import com.elikill58.ipmanager.ConnectionEvents;
import com.elikill58.ipmanager.GetIpCommand;
import com.elikill58.ipmanager.Utils;
import com.elikill58.ipmanager.handler.IP;
import com.elikill58.ipmanager.handler.IpPlayer;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class IpManager
extends JavaPlugin {
    private static IpManager instance;
    private YamlConfiguration ipConfig;
    private File ipFile;

    public static IpManager getInstance() {
        return instance;
    }

    public void onLoad() {
        instance = this;
    }

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)new ConnectionEvents(this), (Plugin)this);
        this.saveDefaultConfig();
        this.getConfig().addDefault("log_console", (Object)"true");
        this.loadIpConfig();
        this.getCommand("getip").setExecutor((CommandExecutor)new GetIpCommand());
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            for (Player p : Utils.getOnlinePlayers()) {
                IpPlayer ip = IpPlayer.getIpPlayer(p);
                ip.setIp(IP.getIP(ip.getBasicIP()));
                ip.setFaiIP(p.getAddress().getHostName());
                ip.save();
            }
        });
    }

    private void loadIpConfig() {
        this.ipFile = new File(String.valueOf(this.getDataFolder().getAbsolutePath()) + File.separator + "users.yml");
        if (!this.ipFile.exists()) {
            Utils.copy((Plugin)this, "users.yml", this.ipFile);
        }
        this.ipConfig = YamlConfiguration.loadConfiguration((File)this.ipFile);
    }

    public YamlConfiguration getIPConfig() {
        return this.ipConfig;
    }

    public void saveIPConfig() {
        try {
            this.ipConfig.save(this.ipFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reload() {
        this.reloadConfig();
        this.loadIpConfig();
    }
}

