/*
 * Decompiled with CFR 0.152.
 */
package com.elikill58.ipmanager;

import com.elikill58.ipmanager.IpManager;
import com.elikill58.ipmanager.Messages;
import com.elikill58.ipmanager.Utils;
import com.elikill58.ipmanager.ban.Ban;
import com.elikill58.ipmanager.ban.BanManager;
import com.elikill58.ipmanager.handler.IP;
import com.elikill58.ipmanager.handler.IpPlayer;
import com.elikill58.ipmanager.listeners.WrongProxyEvent;
import java.util.List;
import java.util.StringJoiner;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class ConnectionEvents
implements Listener {
    private final IpManager pl;

    public ConnectionEvents(IpManager pl) {
        this.pl = pl;
    }

    @EventHandler
    public void onLogin(PlayerLoginEvent e) {
        Player p = e.getPlayer();
        FileConfiguration config = this.pl.getConfig();
        if (config.getBoolean("log_console")) {
            this.pl.getLogger().info(Messages.getMessage("messages.log_console", "%name%", p.getName(), "%uuid%", p.getUniqueId().toString(), "%ip%", e.getAddress().getHostAddress()));
        }
        String bungeeIP = e.getRealAddress().getHostAddress();
        String basicIp = e.getAddress().getHostAddress();
        IpPlayer ip = IpPlayer.getIpPlayer(p);
        ip.setBasicIP(basicIp);
        ip.setBungeeIP(bungeeIP);
        if (config.getBoolean("only_proxy.enabled") && !config.getStringList("only_proxy.bungee_ip").contains(bungeeIP)) {
            String cmd;
            if (config.getBoolean("only_proxy.kick")) {
                e.setKickMessage(Messages.getMessage("messages.wrong_proxy", new String[0]));
                e.setResult(PlayerLoginEvent.Result.KICK_OTHER);
            }
            if (!(cmd = config.getString("only_proxy.command_wrong_proxy")).isEmpty()) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
            }
            Bukkit.getPluginManager().callEvent((Event)new WrongProxyEvent(p, bungeeIP, e));
        }
        if (config.getBoolean("banned-ip.enabled") && config.getStringList("banned-ip.disallow").contains(basicIp)) {
            e.setKickMessage(Messages.getMessage("messages.ip_not_allowed", new String[0]));
            e.setResult(PlayerLoginEvent.Result.KICK_BANNED);
        }
    }

    private ConfigurationSection getConfigForAmountPlayer(ConfigurationSection config, int nb) {
        if (config == null) {
            return null;
        }
        ConfigurationSection sec = null;
        int tempI = -1;
        for (String key : config.getKeys(false)) {
            if (!Utils.isInteger(key) || !(config.get(key) instanceof ConfigurationSection)) continue;
            int i = Integer.parseInt(key);
            if (i == nb) {
                return config.getConfigurationSection(key);
            }
            if (i >= nb || i <= tempI) continue;
            sec = config.getConfigurationSection(key);
            tempI = i;
        }
        return sec;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        IpPlayer ipPlayer = IpPlayer.getIpPlayer(p);
        ipPlayer.setFaiIP(p.getAddress().getHostName());
        ipPlayer.save();
        this.pl.getServer().getScheduler().runTaskAsynchronously((Plugin)this.pl, () -> {
            FileConfiguration config = this.pl.getConfig();
            if (config.getBoolean("check-wrong.enabled")) {
                IP ip = IP.getIP(ipPlayer.getBasicIP());
                ConfigurationSection cwSec = config.getConfigurationSection("check-wrong");
                boolean kick = false;
                boolean ban = false;
                StringJoiner reason = new StringJoiner(", ");
                if (ip.isVPN()) {
                    ConfigurationSection vpnSec = cwSec.getConfigurationSection("vpn");
                    kick = vpnSec.getBoolean("kick", true);
                    ban = vpnSec.getBoolean("ban", true);
                    reason.add("VPN");
                }
                if (ip.isHosting()) {
                    ConfigurationSection hostSec = cwSec.getConfigurationSection("hosting");
                    kick = hostSec.getBoolean("kick", true) || kick;
                    ban = hostSec.getBoolean("ban", true) || ban;
                    reason.add("hosting");
                }
                if (ip.isProxy()) {
                    ConfigurationSection proxySec = cwSec.getConfigurationSection("proxy");
                    kick = proxySec.getBoolean("kick", true) || kick;
                    ban = proxySec.getBoolean("ban", true) || ban;
                    reason.add("proxy");
                }
                if (kick || ban) {
                    boolean finalBan = ban;
                    this.pl.getServer().getScheduler().runTask((Plugin)this.pl, () -> {
                        String msg = Messages.getMessage("messages.not_allowed", "%type%", reason.toString());
                        if (finalBan) {
                            BanManager.getInstance().getProcessor().run(Ban.create(p.getUniqueId(), msg, "Console"));
                        }
                        p.kickPlayer(msg);
                    });
                } else {
                    ipPlayer.setIp(ip);
                }
            }
        });
        List<IpPlayer> playersOnIp = IpPlayer.getPlayersOnIP(ipPlayer.getBasicIP());
        ConfigurationSection playerSection = this.getConfigForAmountPlayer(this.pl.getConfig().getConfigurationSection("ip-notify"), playersOnIp.size());
        if (playerSection == null) {
            return;
        }
        String perm = playerSection.getString("permission", "");
        StringJoiner allNames = new StringJoiner(", ");
        playersOnIp.forEach(pp -> {
            StringJoiner stringJoiner2 = allNames.add(pp.getPlayer().getName());
        });
        playerSection.getStringList("actions").forEach(action -> {
            if (!action.contains(":")) {
                IpManager.getInstance().getLogger().warning("Wrong value for " + action + ", with path " + playerSection.getCurrentPath());
                return;
            }
            String value = Utils.applyColorCodes(action.split(":", 2)[1].replaceAll("%name%", p.getName()).replaceAll("%uuid%", p.getUniqueId().toString()).replaceAll("%count%", String.valueOf(playersOnIp.size())).replaceAll("%all_names%", allNames.toString()));
            if (action.startsWith("console:")) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)value);
            } else if (action.startsWith("run:")) {
                p.performCommand(value);
            } else if (action.startsWith("kick:")) {
                p.kickPlayer(value);
            } else if (action.startsWith("send:")) {
                Utils.getOnlinePlayers().forEach(mod -> {
                    if (perm.isEmpty() && mod.isOp() || mod.hasPermission(perm)) {
                        mod.sendMessage(value);
                    }
                });
            }
        });
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onQuit(PlayerQuitEvent e) {
        IpPlayer.getIpPlayer(e.getPlayer()).remove();
    }
}

