/*
 * Decompiled with CFR 0.152.
 */
package me.bullobily.utils;

import java.util.ArrayList;
import me.bullobily.main.Main;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public enum ItemLibrary {
    VALIDATE_BUTTON("validate_button", Material.EMERALD_BLOCK),
    CANCEL_BUTTON("cancel_button", Material.REDSTONE_BLOCK),
    MONEY_BUTTON("money_button", Material.GOLD_INGOT),
    EXP_BUTTON("exp_button", Material.EXPERIENCE_BOTTLE),
    EXCHANGE_STATE_1("state_1", Material.DIAMOND_PICKAXE),
    EXCHANGE_STATE_2("state_2", Material.ENDER_EYE),
    EXCHANGE_STATE_3("state_3", Material.MINECART),
    PLAYERSTATE_BOTH_WAITING("both_players_managing_exchange", Material.COAL_BLOCK),
    PLAYERSTATE_PARTNER_READY("partner_ready", Material.GLOWSTONE),
    PLAYERSTATE_LOADING_ITEM_1("player_ready", Material.COBBLESTONE_STAIRS),
    PLAYERSTATE_LOADING_ITEM_2("player_ready", Material.COBBLESTONE),
    PLAYERSTATE_COUNTDOWN("countdown_indicator", Material.GUNPOWDER),
    INTERFACE_SEPARATOR("separator", Material.PURPLE_STAINED_GLASS_PANE),
    INTERFACE_PLAYER_ITEMS("your_items", Material.MAGENTA_STAINED_GLASS_PANE),
    INTERFACE_PARTNER_ITEMS("partner_items", Material.MAGENTA_STAINED_GLASS_PANE),
    INTERFACE_FULFILLER("", Material.LIGHT_GRAY_STAINED_GLASS_PANE),
    INTERFACE_DARK_FULFILLER("", Material.BLACK_STAINED_GLASS_PANE);

    private String configId;
    private Material type;

    private ItemLibrary(String s, Material t) {
        this.configId = s;
        this.type = t;
    }

    private String getId() {
        return this.configId;
    }

    private Material getType() {
        return this.type;
    }

    public ItemStack getItem(Main plugin, int amount, Player p) {
        return this.itemGenerator(plugin, amount, p);
    }

    public ItemStack getItem(Main plugin, Player p) {
        return this.itemGenerator(plugin, 1, p);
    }

    private ItemStack itemGenerator(Main plugin, int amount, Player p) {
        ItemStack it = new ItemStack(this.getType(), amount);
        ItemMeta im = it.getItemMeta();
        if (!this.getId().equals("")) {
            im.setDisplayName(plugin.applyVariables(plugin.getConfig().getString("text.title." + this.getId()), p));
            ArrayList<String> lore = new ArrayList<String>();
            for (String s : plugin.getConfig().getStringList("text.lore." + this.getId())) {
                lore.add(plugin.applyVariables(s, p));
            }
            im.setLore(lore);
        } else {
            im.setDisplayName("\u00a71");
        }
        it.setItemMeta(im);
        return it;
    }
}

